/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.CancelSubscriptionRequest;
import com.zuora.model.CancelSubscriptionResponse;
import com.zuora.model.CommonResponse;
import com.zuora.model.CreateSubscriptionRequest;
import com.zuora.model.CreateSubscriptionResponse;
import com.zuora.model.DeleteSubscriptionResponse;
import com.zuora.model.GetMetricsBySubscriptionNumbersResponse;
import com.zuora.model.GetSubscriptionResponse;
import com.zuora.model.GetSubscriptionsResponse;
import com.zuora.model.PreviewExistingSubscriptionRequest;
import com.zuora.model.PreviewExistingSubscriptionResponse;
import com.zuora.model.PreviewSubscriptionRequest;
import com.zuora.model.PreviewSubscriptionResponse;
import com.zuora.model.RenewSubscriptionRequest;
import com.zuora.model.RenewSubscriptionResponse;
import com.zuora.model.ResumeSubscriptionRequest;
import com.zuora.model.ResumeSubscriptionResponse;
import com.zuora.model.SuspendSubscriptionRequest;
import com.zuora.model.SuspendSubscriptionResponse;
import com.zuora.model.UpdateSubscriptionCustomFieldsOfASpecifiedVersionRequest;
import com.zuora.model.UpdateSubscriptionRequest;
import com.zuora.model.UpdateSubscriptionResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class SubscriptionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SubscriptionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubscriptionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call cancelSubscriptionCall(String subscriptionKey, CancelSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CancelSubscriptionRequest localVarPostBody = request;
        String localVarPath = "/v1/subscriptions/{subscription-key}/cancel".replace("{subscription-key}", this.localVarApiClient.escapeString(subscriptionKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelSubscriptionValidateBeforeCall(String subscriptionKey, CancelSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionKey == null) {
            throw new ApiException("Missing the required parameter 'subscriptionKey' when calling cancelSubscription(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling cancelSubscription(Async)");
        }
        return this.cancelSubscriptionCall(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CancelSubscriptionResponse cancelSubscription(String subscriptionKey, CancelSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CancelSubscriptionResponse> localVarResp = this.cancelSubscriptionWithHttpInfo(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CancelSubscriptionResponse> cancelSubscriptionWithHttpInfo(String subscriptionKey, CancelSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.cancelSubscriptionValidateBeforeCall(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<CancelSubscriptionResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call cancelSubscriptionAsync(String subscriptionKey, CancelSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CancelSubscriptionResponse> _callback) throws ApiException {
        Call localVarCall = this.cancelSubscriptionValidateBeforeCall(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CancelSubscriptionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelSubscriptionApi cancelSubscriptionApi(String subscriptionKey, CancelSubscriptionRequest request) {
        return new CancelSubscriptionApi(subscriptionKey, request);
    }

    private Call createSubscriptionCall(CreateSubscriptionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateSubscriptionRequest localVarPostBody = request;
        String localVarPath = "/v1/subscriptions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSubscriptionValidateBeforeCall(CreateSubscriptionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling createSubscription(Async)");
        }
        return this.createSubscriptionCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreateSubscriptionResponse createSubscription(CreateSubscriptionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreateSubscriptionResponse> localVarResp = this.createSubscriptionWithHttpInfo(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreateSubscriptionResponse> createSubscriptionWithHttpInfo(CreateSubscriptionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createSubscriptionValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<CreateSubscriptionResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createSubscriptionAsync(CreateSubscriptionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreateSubscriptionResponse> _callback) throws ApiException {
        Call localVarCall = this.createSubscriptionValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreateSubscriptionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateSubscriptionApi createSubscriptionApi(CreateSubscriptionRequest request) {
        return new CreateSubscriptionApi(request);
    }

    private Call deleteSubscriptionCall(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/subscriptions/{subscription-key}/delete".replace("{subscription-key}", this.localVarApiClient.escapeString(subscriptionKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSubscriptionValidateBeforeCall(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionKey == null) {
            throw new ApiException("Missing the required parameter 'subscriptionKey' when calling deleteSubscription(Async)");
        }
        return this.deleteSubscriptionCall(subscriptionKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected DeleteSubscriptionResponse deleteSubscription(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<DeleteSubscriptionResponse> localVarResp = this.deleteSubscriptionWithHttpInfo(subscriptionKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<DeleteSubscriptionResponse> deleteSubscriptionWithHttpInfo(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deleteSubscriptionValidateBeforeCall(subscriptionKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<DeleteSubscriptionResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteSubscriptionAsync(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<DeleteSubscriptionResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteSubscriptionValidateBeforeCall(subscriptionKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<DeleteSubscriptionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DeleteSubscriptionApi deleteSubscriptionApi(String subscriptionKey) {
        return new DeleteSubscriptionApi(subscriptionKey);
    }

    private Call getMetricsBySubscriptionNumbersCall(List<String> subscriptionNumbers, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String asOfDay, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/subscriptions/subscription-metrics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (asOfDay != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asOfDay", asOfDay));
        }
        if (subscriptionNumbers != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscriptionNumbers[]", subscriptionNumbers));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMetricsBySubscriptionNumbersValidateBeforeCall(List<String> subscriptionNumbers, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String asOfDay, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionNumbers == null) {
            throw new ApiException("Missing the required parameter 'subscriptionNumbers' when calling getMetricsBySubscriptionNumbers(Async)");
        }
        return this.getMetricsBySubscriptionNumbersCall(subscriptionNumbers, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, asOfDay, zuoraOrgIds, _callback);
    }

    protected GetMetricsBySubscriptionNumbersResponse getMetricsBySubscriptionNumbers(List<String> subscriptionNumbers, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String asOfDay, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetMetricsBySubscriptionNumbersResponse> localVarResp = this.getMetricsBySubscriptionNumbersWithHttpInfo(subscriptionNumbers, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, asOfDay, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetMetricsBySubscriptionNumbersResponse> getMetricsBySubscriptionNumbersWithHttpInfo(List<String> subscriptionNumbers, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String asOfDay, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getMetricsBySubscriptionNumbersValidateBeforeCall(subscriptionNumbers, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, asOfDay, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<GetMetricsBySubscriptionNumbersResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getMetricsBySubscriptionNumbersAsync(List<String> subscriptionNumbers, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String asOfDay, String zuoraOrgIds, ApiCallback<GetMetricsBySubscriptionNumbersResponse> _callback) throws ApiException {
        Call localVarCall = this.getMetricsBySubscriptionNumbersValidateBeforeCall(subscriptionNumbers, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, asOfDay, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetMetricsBySubscriptionNumbersResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetMetricsBySubscriptionNumbersApi getMetricsBySubscriptionNumbersApi(List<String> subscriptionNumbers) {
        return new GetMetricsBySubscriptionNumbersApi(subscriptionNumbers);
    }

    private Call getSubscriptionByKeyCall(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String chargeDetail, Boolean excludeRatePlansWithNoCharges, Boolean getDetailedMetrics, String asOfDay, Boolean getSubscriptionOwnerDetails, Boolean getInvoiceOwnerDetails, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/subscriptions/{subscription-key}".replace("{subscription-key}", this.localVarApiClient.escapeString(subscriptionKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (chargeDetail != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("charge-detail", chargeDetail));
        }
        if (excludeRatePlansWithNoCharges != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("exclude-rate-plans-with-no-charges", excludeRatePlansWithNoCharges));
        }
        if (getDetailedMetrics != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("getDetailedMetrics", getDetailedMetrics));
        }
        if (asOfDay != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asOfDay", asOfDay));
        }
        if (getSubscriptionOwnerDetails != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("getSubscriptionOwnerDetails", getSubscriptionOwnerDetails));
        }
        if (getInvoiceOwnerDetails != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("getInvoiceOwnerDetails", getInvoiceOwnerDetails));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSubscriptionByKeyValidateBeforeCall(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String chargeDetail, Boolean excludeRatePlansWithNoCharges, Boolean getDetailedMetrics, String asOfDay, Boolean getSubscriptionOwnerDetails, Boolean getInvoiceOwnerDetails, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionKey == null) {
            throw new ApiException("Missing the required parameter 'subscriptionKey' when calling getSubscriptionByKey(Async)");
        }
        return this.getSubscriptionByKeyCall(subscriptionKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, chargeDetail, excludeRatePlansWithNoCharges, getDetailedMetrics, asOfDay, getSubscriptionOwnerDetails, getInvoiceOwnerDetails, zuoraOrgIds, _callback);
    }

    protected GetSubscriptionResponse getSubscriptionByKey(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String chargeDetail, Boolean excludeRatePlansWithNoCharges, Boolean getDetailedMetrics, String asOfDay, Boolean getSubscriptionOwnerDetails, Boolean getInvoiceOwnerDetails, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetSubscriptionResponse> localVarResp = this.getSubscriptionByKeyWithHttpInfo(subscriptionKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, chargeDetail, excludeRatePlansWithNoCharges, getDetailedMetrics, asOfDay, getSubscriptionOwnerDetails, getInvoiceOwnerDetails, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetSubscriptionResponse> getSubscriptionByKeyWithHttpInfo(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String chargeDetail, Boolean excludeRatePlansWithNoCharges, Boolean getDetailedMetrics, String asOfDay, Boolean getSubscriptionOwnerDetails, Boolean getInvoiceOwnerDetails, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getSubscriptionByKeyValidateBeforeCall(subscriptionKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, chargeDetail, excludeRatePlansWithNoCharges, getDetailedMetrics, asOfDay, getSubscriptionOwnerDetails, getInvoiceOwnerDetails, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<GetSubscriptionResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getSubscriptionByKeyAsync(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String chargeDetail, Boolean excludeRatePlansWithNoCharges, Boolean getDetailedMetrics, String asOfDay, Boolean getSubscriptionOwnerDetails, Boolean getInvoiceOwnerDetails, String zuoraOrgIds, ApiCallback<GetSubscriptionResponse> _callback) throws ApiException {
        Call localVarCall = this.getSubscriptionByKeyValidateBeforeCall(subscriptionKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, chargeDetail, excludeRatePlansWithNoCharges, getDetailedMetrics, asOfDay, getSubscriptionOwnerDetails, getInvoiceOwnerDetails, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetSubscriptionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetSubscriptionByKeyApi getSubscriptionByKeyApi(String subscriptionKey) {
        return new GetSubscriptionByKeyApi(subscriptionKey);
    }

    private Call getSubscriptionByKeyAndVersionCall(String subscriptionKey, String version, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String chargeDetail, Boolean excludeRatePlansWithNoCharges, Boolean getDetailedMetrics, String asOfDay, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/subscriptions/{subscription-key}/versions/{version}".replace("{subscription-key}", this.localVarApiClient.escapeString(subscriptionKey.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (chargeDetail != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("charge-detail", chargeDetail));
        }
        if (excludeRatePlansWithNoCharges != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("exclude-rate-plans-with-no-charges", excludeRatePlansWithNoCharges));
        }
        if (getDetailedMetrics != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("getDetailedMetrics", getDetailedMetrics));
        }
        if (asOfDay != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asOfDay", asOfDay));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSubscriptionByKeyAndVersionValidateBeforeCall(String subscriptionKey, String version, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String chargeDetail, Boolean excludeRatePlansWithNoCharges, Boolean getDetailedMetrics, String asOfDay, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionKey == null) {
            throw new ApiException("Missing the required parameter 'subscriptionKey' when calling getSubscriptionByKeyAndVersion(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getSubscriptionByKeyAndVersion(Async)");
        }
        return this.getSubscriptionByKeyAndVersionCall(subscriptionKey, version, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, chargeDetail, excludeRatePlansWithNoCharges, getDetailedMetrics, asOfDay, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetSubscriptionResponse getSubscriptionByKeyAndVersion(String subscriptionKey, String version, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String chargeDetail, Boolean excludeRatePlansWithNoCharges, Boolean getDetailedMetrics, String asOfDay, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetSubscriptionResponse> localVarResp = this.getSubscriptionByKeyAndVersionWithHttpInfo(subscriptionKey, version, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, chargeDetail, excludeRatePlansWithNoCharges, getDetailedMetrics, asOfDay, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetSubscriptionResponse> getSubscriptionByKeyAndVersionWithHttpInfo(String subscriptionKey, String version, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String chargeDetail, Boolean excludeRatePlansWithNoCharges, Boolean getDetailedMetrics, String asOfDay, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getSubscriptionByKeyAndVersionValidateBeforeCall(subscriptionKey, version, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, chargeDetail, excludeRatePlansWithNoCharges, getDetailedMetrics, asOfDay, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<GetSubscriptionResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getSubscriptionByKeyAndVersionAsync(String subscriptionKey, String version, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String chargeDetail, Boolean excludeRatePlansWithNoCharges, Boolean getDetailedMetrics, String asOfDay, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetSubscriptionResponse> _callback) throws ApiException {
        Call localVarCall = this.getSubscriptionByKeyAndVersionValidateBeforeCall(subscriptionKey, version, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, chargeDetail, excludeRatePlansWithNoCharges, getDetailedMetrics, asOfDay, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetSubscriptionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetSubscriptionByKeyAndVersionApi getSubscriptionByKeyAndVersionApi(String subscriptionKey, String version) {
        return new GetSubscriptionByKeyAndVersionApi(subscriptionKey, version);
    }

    private Call getSubscriptionsByAccountCall(String accountKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String ownerType, Boolean getDetailedMetrics, String asOfDay, String chargeDetail, Boolean excludeRatePlansWithNoCharges, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/subscriptions/accounts/{account-key}".replace("{account-key}", this.localVarApiClient.escapeString(accountKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (ownerType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ownerType", ownerType));
        }
        if (getDetailedMetrics != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("getDetailedMetrics", getDetailedMetrics));
        }
        if (asOfDay != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asOfDay", asOfDay));
        }
        if (chargeDetail != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("charge-detail", chargeDetail));
        }
        if (excludeRatePlansWithNoCharges != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("exclude-rate-plans-with-no-charges", excludeRatePlansWithNoCharges));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSubscriptionsByAccountValidateBeforeCall(String accountKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String ownerType, Boolean getDetailedMetrics, String asOfDay, String chargeDetail, Boolean excludeRatePlansWithNoCharges, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (accountKey == null) {
            throw new ApiException("Missing the required parameter 'accountKey' when calling getSubscriptionsByAccount(Async)");
        }
        return this.getSubscriptionsByAccountCall(accountKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, ownerType, getDetailedMetrics, asOfDay, chargeDetail, excludeRatePlansWithNoCharges, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetSubscriptionsResponse getSubscriptionsByAccount(String accountKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String ownerType, Boolean getDetailedMetrics, String asOfDay, String chargeDetail, Boolean excludeRatePlansWithNoCharges, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetSubscriptionsResponse> localVarResp = this.getSubscriptionsByAccountWithHttpInfo(accountKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, ownerType, getDetailedMetrics, asOfDay, chargeDetail, excludeRatePlansWithNoCharges, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetSubscriptionsResponse> getSubscriptionsByAccountWithHttpInfo(String accountKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String ownerType, Boolean getDetailedMetrics, String asOfDay, String chargeDetail, Boolean excludeRatePlansWithNoCharges, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getSubscriptionsByAccountValidateBeforeCall(accountKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, ownerType, getDetailedMetrics, asOfDay, chargeDetail, excludeRatePlansWithNoCharges, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<GetSubscriptionsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getSubscriptionsByAccountAsync(String accountKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String ownerType, Boolean getDetailedMetrics, String asOfDay, String chargeDetail, Boolean excludeRatePlansWithNoCharges, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetSubscriptionsResponse> _callback) throws ApiException {
        Call localVarCall = this.getSubscriptionsByAccountValidateBeforeCall(accountKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, ownerType, getDetailedMetrics, asOfDay, chargeDetail, excludeRatePlansWithNoCharges, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetSubscriptionsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetSubscriptionsByAccountApi getSubscriptionsByAccountApi(String accountKey) {
        return new GetSubscriptionsByAccountApi(accountKey);
    }

    private Call previewExistingSubscriptionCall(String subscriptionKey, PreviewExistingSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PreviewExistingSubscriptionRequest localVarPostBody = request;
        String localVarPath = "/v1/subscriptions/{subscription-key}/preview".replace("{subscription-key}", this.localVarApiClient.escapeString(subscriptionKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call previewExistingSubscriptionValidateBeforeCall(String subscriptionKey, PreviewExistingSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionKey == null) {
            throw new ApiException("Missing the required parameter 'subscriptionKey' when calling previewExistingSubscription(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling previewExistingSubscription(Async)");
        }
        return this.previewExistingSubscriptionCall(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected PreviewExistingSubscriptionResponse previewExistingSubscription(String subscriptionKey, PreviewExistingSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<PreviewExistingSubscriptionResponse> localVarResp = this.previewExistingSubscriptionWithHttpInfo(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<PreviewExistingSubscriptionResponse> previewExistingSubscriptionWithHttpInfo(String subscriptionKey, PreviewExistingSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.previewExistingSubscriptionValidateBeforeCall(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<PreviewExistingSubscriptionResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call previewExistingSubscriptionAsync(String subscriptionKey, PreviewExistingSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<PreviewExistingSubscriptionResponse> _callback) throws ApiException {
        Call localVarCall = this.previewExistingSubscriptionValidateBeforeCall(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PreviewExistingSubscriptionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PreviewExistingSubscriptionApi previewExistingSubscriptionApi(String subscriptionKey, PreviewExistingSubscriptionRequest request) {
        return new PreviewExistingSubscriptionApi(subscriptionKey, request);
    }

    private Call previewSubscriptionCall(PreviewSubscriptionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PreviewSubscriptionRequest localVarPostBody = request;
        String localVarPath = "/v1/subscriptions/preview";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call previewSubscriptionValidateBeforeCall(PreviewSubscriptionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling previewSubscription(Async)");
        }
        return this.previewSubscriptionCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected PreviewSubscriptionResponse previewSubscription(PreviewSubscriptionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<PreviewSubscriptionResponse> localVarResp = this.previewSubscriptionWithHttpInfo(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<PreviewSubscriptionResponse> previewSubscriptionWithHttpInfo(PreviewSubscriptionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.previewSubscriptionValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<PreviewSubscriptionResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call previewSubscriptionAsync(PreviewSubscriptionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<PreviewSubscriptionResponse> _callback) throws ApiException {
        Call localVarCall = this.previewSubscriptionValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PreviewSubscriptionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PreviewSubscriptionApi previewSubscriptionApi(PreviewSubscriptionRequest request) {
        return new PreviewSubscriptionApi(request);
    }

    private Call renewSubscriptionCall(String subscriptionKey, RenewSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RenewSubscriptionRequest localVarPostBody = request;
        String localVarPath = "/v1/subscriptions/{subscription-key}/renew".replace("{subscription-key}", this.localVarApiClient.escapeString(subscriptionKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call renewSubscriptionValidateBeforeCall(String subscriptionKey, RenewSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionKey == null) {
            throw new ApiException("Missing the required parameter 'subscriptionKey' when calling renewSubscription(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling renewSubscription(Async)");
        }
        return this.renewSubscriptionCall(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected RenewSubscriptionResponse renewSubscription(String subscriptionKey, RenewSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<RenewSubscriptionResponse> localVarResp = this.renewSubscriptionWithHttpInfo(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<RenewSubscriptionResponse> renewSubscriptionWithHttpInfo(String subscriptionKey, RenewSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.renewSubscriptionValidateBeforeCall(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<RenewSubscriptionResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call renewSubscriptionAsync(String subscriptionKey, RenewSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<RenewSubscriptionResponse> _callback) throws ApiException {
        Call localVarCall = this.renewSubscriptionValidateBeforeCall(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<RenewSubscriptionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public RenewSubscriptionApi renewSubscriptionApi(String subscriptionKey, RenewSubscriptionRequest request) {
        return new RenewSubscriptionApi(subscriptionKey, request);
    }

    private Call resumeSubscriptionCall(String subscriptionKey, ResumeSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ResumeSubscriptionRequest localVarPostBody = request;
        String localVarPath = "/v1/subscriptions/{subscription-key}/resume".replace("{subscription-key}", this.localVarApiClient.escapeString(subscriptionKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resumeSubscriptionValidateBeforeCall(String subscriptionKey, ResumeSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionKey == null) {
            throw new ApiException("Missing the required parameter 'subscriptionKey' when calling resumeSubscription(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling resumeSubscription(Async)");
        }
        return this.resumeSubscriptionCall(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected ResumeSubscriptionResponse resumeSubscription(String subscriptionKey, ResumeSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<ResumeSubscriptionResponse> localVarResp = this.resumeSubscriptionWithHttpInfo(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<ResumeSubscriptionResponse> resumeSubscriptionWithHttpInfo(String subscriptionKey, ResumeSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.resumeSubscriptionValidateBeforeCall(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<ResumeSubscriptionResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call resumeSubscriptionAsync(String subscriptionKey, ResumeSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<ResumeSubscriptionResponse> _callback) throws ApiException {
        Call localVarCall = this.resumeSubscriptionValidateBeforeCall(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<ResumeSubscriptionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ResumeSubscriptionApi resumeSubscriptionApi(String subscriptionKey, ResumeSubscriptionRequest request) {
        return new ResumeSubscriptionApi(subscriptionKey, request);
    }

    private Call suspendSubscriptionCall(String subscriptionKey, SuspendSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SuspendSubscriptionRequest localVarPostBody = request;
        String localVarPath = "/v1/subscriptions/{subscription-key}/suspend".replace("{subscription-key}", this.localVarApiClient.escapeString(subscriptionKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call suspendSubscriptionValidateBeforeCall(String subscriptionKey, SuspendSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionKey == null) {
            throw new ApiException("Missing the required parameter 'subscriptionKey' when calling suspendSubscription(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling suspendSubscription(Async)");
        }
        return this.suspendSubscriptionCall(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected SuspendSubscriptionResponse suspendSubscription(String subscriptionKey, SuspendSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<SuspendSubscriptionResponse> localVarResp = this.suspendSubscriptionWithHttpInfo(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<SuspendSubscriptionResponse> suspendSubscriptionWithHttpInfo(String subscriptionKey, SuspendSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.suspendSubscriptionValidateBeforeCall(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<SuspendSubscriptionResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call suspendSubscriptionAsync(String subscriptionKey, SuspendSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<SuspendSubscriptionResponse> _callback) throws ApiException {
        Call localVarCall = this.suspendSubscriptionValidateBeforeCall(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<SuspendSubscriptionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public SuspendSubscriptionApi suspendSubscriptionApi(String subscriptionKey, SuspendSubscriptionRequest request) {
        return new SuspendSubscriptionApi(subscriptionKey, request);
    }

    private Call updateSubscriptionCall(String subscriptionKey, UpdateSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateSubscriptionRequest localVarPostBody = request;
        String localVarPath = "/v1/subscriptions/{subscription-key}".replace("{subscription-key}", this.localVarApiClient.escapeString(subscriptionKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSubscriptionValidateBeforeCall(String subscriptionKey, UpdateSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionKey == null) {
            throw new ApiException("Missing the required parameter 'subscriptionKey' when calling updateSubscription(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling updateSubscription(Async)");
        }
        return this.updateSubscriptionCall(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected UpdateSubscriptionResponse updateSubscription(String subscriptionKey, UpdateSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<UpdateSubscriptionResponse> localVarResp = this.updateSubscriptionWithHttpInfo(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<UpdateSubscriptionResponse> updateSubscriptionWithHttpInfo(String subscriptionKey, UpdateSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updateSubscriptionValidateBeforeCall(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<UpdateSubscriptionResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call updateSubscriptionAsync(String subscriptionKey, UpdateSubscriptionRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<UpdateSubscriptionResponse> _callback) throws ApiException {
        Call localVarCall = this.updateSubscriptionValidateBeforeCall(subscriptionKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<UpdateSubscriptionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateSubscriptionApi updateSubscriptionApi(String subscriptionKey, UpdateSubscriptionRequest request) {
        return new UpdateSubscriptionApi(subscriptionKey, request);
    }

    private Call updateSubscriptionCustomFieldsOfASpecifiedVersionCall(String subscriptionNumber, String version, UpdateSubscriptionCustomFieldsOfASpecifiedVersionRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateSubscriptionCustomFieldsOfASpecifiedVersionRequest localVarPostBody = body;
        String localVarPath = "/v1/subscriptions/{subscriptionNumber}/versions/{version}/customFields".replace("{subscriptionNumber}", this.localVarApiClient.escapeString(subscriptionNumber.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSubscriptionCustomFieldsOfASpecifiedVersionValidateBeforeCall(String subscriptionNumber, String version, UpdateSubscriptionCustomFieldsOfASpecifiedVersionRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionNumber == null) {
            throw new ApiException("Missing the required parameter 'subscriptionNumber' when calling updateSubscriptionCustomFieldsOfASpecifiedVersion(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling updateSubscriptionCustomFieldsOfASpecifiedVersion(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateSubscriptionCustomFieldsOfASpecifiedVersion(Async)");
        }
        return this.updateSubscriptionCustomFieldsOfASpecifiedVersionCall(subscriptionNumber, version, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse updateSubscriptionCustomFieldsOfASpecifiedVersion(String subscriptionNumber, String version, UpdateSubscriptionCustomFieldsOfASpecifiedVersionRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.updateSubscriptionCustomFieldsOfASpecifiedVersionWithHttpInfo(subscriptionNumber, version, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> updateSubscriptionCustomFieldsOfASpecifiedVersionWithHttpInfo(String subscriptionNumber, String version, UpdateSubscriptionCustomFieldsOfASpecifiedVersionRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updateSubscriptionCustomFieldsOfASpecifiedVersionValidateBeforeCall(subscriptionNumber, version, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call updateSubscriptionCustomFieldsOfASpecifiedVersionAsync(String subscriptionNumber, String version, UpdateSubscriptionCustomFieldsOfASpecifiedVersionRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.updateSubscriptionCustomFieldsOfASpecifiedVersionValidateBeforeCall(subscriptionNumber, version, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateSubscriptionCustomFieldsOfASpecifiedVersionApi updateSubscriptionCustomFieldsOfASpecifiedVersionApi(String subscriptionNumber, String version, UpdateSubscriptionCustomFieldsOfASpecifiedVersionRequest body) {
        return new UpdateSubscriptionCustomFieldsOfASpecifiedVersionApi(subscriptionNumber, version, body);
    }

    public class UpdateSubscriptionCustomFieldsOfASpecifiedVersionApi {
        private final String subscriptionNumber;
        private final String version;
        private final UpdateSubscriptionCustomFieldsOfASpecifiedVersionRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private UpdateSubscriptionCustomFieldsOfASpecifiedVersionApi(String subscriptionNumber, String version, UpdateSubscriptionCustomFieldsOfASpecifiedVersionRequest body) {
            this.subscriptionNumber = subscriptionNumber;
            this.version = version;
            this.body = body;
        }

        public UpdateSubscriptionCustomFieldsOfASpecifiedVersionApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdateSubscriptionCustomFieldsOfASpecifiedVersionApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdateSubscriptionCustomFieldsOfASpecifiedVersionApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdateSubscriptionCustomFieldsOfASpecifiedVersionApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdateSubscriptionCustomFieldsOfASpecifiedVersionApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdateSubscriptionCustomFieldsOfASpecifiedVersionApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UpdateSubscriptionCustomFieldsOfASpecifiedVersionApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SubscriptionsApi.this.updateSubscriptionCustomFieldsOfASpecifiedVersionCall(this.subscriptionNumber, this.version, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse localVarResp = SubscriptionsApi.this.updateSubscriptionCustomFieldsOfASpecifiedVersionWithHttpInfo(this.subscriptionNumber, this.version, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (CommonResponse)localVarResp.getData();
        }

        private ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return SubscriptionsApi.this.updateSubscriptionCustomFieldsOfASpecifiedVersionWithHttpInfo(this.subscriptionNumber, this.version, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return SubscriptionsApi.this.updateSubscriptionCustomFieldsOfASpecifiedVersionAsync(this.subscriptionNumber, this.version, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class UpdateSubscriptionApi {
        private final String subscriptionKey;
        private final UpdateSubscriptionRequest request;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private UpdateSubscriptionApi(String subscriptionKey, UpdateSubscriptionRequest request) {
            this.subscriptionKey = subscriptionKey;
            this.request = request;
        }

        public UpdateSubscriptionApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdateSubscriptionApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdateSubscriptionApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdateSubscriptionApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdateSubscriptionApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdateSubscriptionApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UpdateSubscriptionApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SubscriptionsApi.this.updateSubscriptionCall(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public UpdateSubscriptionResponse execute() throws ApiException {
            ApiResponse localVarResp = SubscriptionsApi.this.updateSubscriptionWithHttpInfo(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (UpdateSubscriptionResponse)localVarResp.getData();
        }

        private ApiResponse<UpdateSubscriptionResponse> executeWithHttpInfo() throws ApiException {
            return SubscriptionsApi.this.updateSubscriptionWithHttpInfo(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<UpdateSubscriptionResponse> _callback) throws ApiException {
            return SubscriptionsApi.this.updateSubscriptionAsync(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class SuspendSubscriptionApi {
        private final String subscriptionKey;
        private final SuspendSubscriptionRequest request;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private SuspendSubscriptionApi(String subscriptionKey, SuspendSubscriptionRequest request) {
            this.subscriptionKey = subscriptionKey;
            this.request = request;
        }

        public SuspendSubscriptionApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public SuspendSubscriptionApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public SuspendSubscriptionApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public SuspendSubscriptionApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public SuspendSubscriptionApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public SuspendSubscriptionApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public SuspendSubscriptionApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SubscriptionsApi.this.suspendSubscriptionCall(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public SuspendSubscriptionResponse execute() throws ApiException {
            ApiResponse localVarResp = SubscriptionsApi.this.suspendSubscriptionWithHttpInfo(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (SuspendSubscriptionResponse)localVarResp.getData();
        }

        private ApiResponse<SuspendSubscriptionResponse> executeWithHttpInfo() throws ApiException {
            return SubscriptionsApi.this.suspendSubscriptionWithHttpInfo(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<SuspendSubscriptionResponse> _callback) throws ApiException {
            return SubscriptionsApi.this.suspendSubscriptionAsync(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class ResumeSubscriptionApi {
        private final String subscriptionKey;
        private final ResumeSubscriptionRequest request;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private ResumeSubscriptionApi(String subscriptionKey, ResumeSubscriptionRequest request) {
            this.subscriptionKey = subscriptionKey;
            this.request = request;
        }

        public ResumeSubscriptionApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public ResumeSubscriptionApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public ResumeSubscriptionApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public ResumeSubscriptionApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public ResumeSubscriptionApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public ResumeSubscriptionApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public ResumeSubscriptionApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SubscriptionsApi.this.resumeSubscriptionCall(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public ResumeSubscriptionResponse execute() throws ApiException {
            ApiResponse localVarResp = SubscriptionsApi.this.resumeSubscriptionWithHttpInfo(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (ResumeSubscriptionResponse)localVarResp.getData();
        }

        private ApiResponse<ResumeSubscriptionResponse> executeWithHttpInfo() throws ApiException {
            return SubscriptionsApi.this.resumeSubscriptionWithHttpInfo(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<ResumeSubscriptionResponse> _callback) throws ApiException {
            return SubscriptionsApi.this.resumeSubscriptionAsync(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class RenewSubscriptionApi {
        private final String subscriptionKey;
        private final RenewSubscriptionRequest request;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private RenewSubscriptionApi(String subscriptionKey, RenewSubscriptionRequest request) {
            this.subscriptionKey = subscriptionKey;
            this.request = request;
        }

        public RenewSubscriptionApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public RenewSubscriptionApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public RenewSubscriptionApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public RenewSubscriptionApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public RenewSubscriptionApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public RenewSubscriptionApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public RenewSubscriptionApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SubscriptionsApi.this.renewSubscriptionCall(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public RenewSubscriptionResponse execute() throws ApiException {
            ApiResponse localVarResp = SubscriptionsApi.this.renewSubscriptionWithHttpInfo(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (RenewSubscriptionResponse)localVarResp.getData();
        }

        private ApiResponse<RenewSubscriptionResponse> executeWithHttpInfo() throws ApiException {
            return SubscriptionsApi.this.renewSubscriptionWithHttpInfo(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<RenewSubscriptionResponse> _callback) throws ApiException {
            return SubscriptionsApi.this.renewSubscriptionAsync(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class PreviewSubscriptionApi {
        private final PreviewSubscriptionRequest request;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private PreviewSubscriptionApi(PreviewSubscriptionRequest request) {
            this.request = request;
        }

        public PreviewSubscriptionApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PreviewSubscriptionApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PreviewSubscriptionApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PreviewSubscriptionApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PreviewSubscriptionApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PreviewSubscriptionApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PreviewSubscriptionApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public PreviewSubscriptionApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SubscriptionsApi.this.previewSubscriptionCall(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public PreviewSubscriptionResponse execute() throws ApiException {
            ApiResponse localVarResp = SubscriptionsApi.this.previewSubscriptionWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (PreviewSubscriptionResponse)localVarResp.getData();
        }

        private ApiResponse<PreviewSubscriptionResponse> executeWithHttpInfo() throws ApiException {
            return SubscriptionsApi.this.previewSubscriptionWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<PreviewSubscriptionResponse> _callback) throws ApiException {
            return SubscriptionsApi.this.previewSubscriptionAsync(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class PreviewExistingSubscriptionApi {
        private final String subscriptionKey;
        private final PreviewExistingSubscriptionRequest request;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private PreviewExistingSubscriptionApi(String subscriptionKey, PreviewExistingSubscriptionRequest request) {
            this.subscriptionKey = subscriptionKey;
            this.request = request;
        }

        public PreviewExistingSubscriptionApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PreviewExistingSubscriptionApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PreviewExistingSubscriptionApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PreviewExistingSubscriptionApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PreviewExistingSubscriptionApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PreviewExistingSubscriptionApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public PreviewExistingSubscriptionApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SubscriptionsApi.this.previewExistingSubscriptionCall(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public PreviewExistingSubscriptionResponse execute() throws ApiException {
            ApiResponse localVarResp = SubscriptionsApi.this.previewExistingSubscriptionWithHttpInfo(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (PreviewExistingSubscriptionResponse)localVarResp.getData();
        }

        private ApiResponse<PreviewExistingSubscriptionResponse> executeWithHttpInfo() throws ApiException {
            return SubscriptionsApi.this.previewExistingSubscriptionWithHttpInfo(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<PreviewExistingSubscriptionResponse> _callback) throws ApiException {
            return SubscriptionsApi.this.previewExistingSubscriptionAsync(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetSubscriptionsByAccountApi {
        private final String accountKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer page;
        private Integer pageSize;
        private String ownerType;
        private Boolean getDetailedMetrics;
        private String asOfDay;
        private String chargeDetail;
        private Boolean excludeRatePlansWithNoCharges;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetSubscriptionsByAccountApi(String accountKey) {
            this.accountKey = accountKey;
        }

        public GetSubscriptionsByAccountApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetSubscriptionsByAccountApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetSubscriptionsByAccountApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetSubscriptionsByAccountApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetSubscriptionsByAccountApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetSubscriptionsByAccountApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetSubscriptionsByAccountApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetSubscriptionsByAccountApi ownerType(String ownerType) {
            this.ownerType = ownerType;
            return this;
        }

        public GetSubscriptionsByAccountApi getDetailedMetrics(Boolean getDetailedMetrics) {
            this.getDetailedMetrics = getDetailedMetrics;
            return this;
        }

        public GetSubscriptionsByAccountApi asOfDay(String asOfDay) {
            this.asOfDay = asOfDay;
            return this;
        }

        public GetSubscriptionsByAccountApi chargeDetail(String chargeDetail) {
            this.chargeDetail = chargeDetail;
            return this;
        }

        public GetSubscriptionsByAccountApi excludeRatePlansWithNoCharges(Boolean excludeRatePlansWithNoCharges) {
            this.excludeRatePlansWithNoCharges = excludeRatePlansWithNoCharges;
            return this;
        }

        public GetSubscriptionsByAccountApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetSubscriptionsByAccountApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SubscriptionsApi.this.getSubscriptionsByAccountCall(this.accountKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.ownerType, this.getDetailedMetrics, this.asOfDay, this.chargeDetail, this.excludeRatePlansWithNoCharges, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetSubscriptionsResponse execute() throws ApiException {
            ApiResponse localVarResp = SubscriptionsApi.this.getSubscriptionsByAccountWithHttpInfo(this.accountKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.ownerType, this.getDetailedMetrics, this.asOfDay, this.chargeDetail, this.excludeRatePlansWithNoCharges, this.zuoraVersion, this.zuoraOrgIds);
            return (GetSubscriptionsResponse)localVarResp.getData();
        }

        private ApiResponse<GetSubscriptionsResponse> executeWithHttpInfo() throws ApiException {
            return SubscriptionsApi.this.getSubscriptionsByAccountWithHttpInfo(this.accountKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.ownerType, this.getDetailedMetrics, this.asOfDay, this.chargeDetail, this.excludeRatePlansWithNoCharges, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetSubscriptionsResponse> _callback) throws ApiException {
            return SubscriptionsApi.this.getSubscriptionsByAccountAsync(this.accountKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.ownerType, this.getDetailedMetrics, this.asOfDay, this.chargeDetail, this.excludeRatePlansWithNoCharges, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetSubscriptionByKeyAndVersionApi {
        private final String subscriptionKey;
        private final String version;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String chargeDetail;
        private Boolean excludeRatePlansWithNoCharges;
        private Boolean getDetailedMetrics;
        private String asOfDay;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetSubscriptionByKeyAndVersionApi(String subscriptionKey, String version) {
            this.subscriptionKey = subscriptionKey;
            this.version = version;
        }

        public GetSubscriptionByKeyAndVersionApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetSubscriptionByKeyAndVersionApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetSubscriptionByKeyAndVersionApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetSubscriptionByKeyAndVersionApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetSubscriptionByKeyAndVersionApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetSubscriptionByKeyAndVersionApi chargeDetail(String chargeDetail) {
            this.chargeDetail = chargeDetail;
            return this;
        }

        public GetSubscriptionByKeyAndVersionApi excludeRatePlansWithNoCharges(Boolean excludeRatePlansWithNoCharges) {
            this.excludeRatePlansWithNoCharges = excludeRatePlansWithNoCharges;
            return this;
        }

        public GetSubscriptionByKeyAndVersionApi getDetailedMetrics(Boolean getDetailedMetrics) {
            this.getDetailedMetrics = getDetailedMetrics;
            return this;
        }

        public GetSubscriptionByKeyAndVersionApi asOfDay(String asOfDay) {
            this.asOfDay = asOfDay;
            return this;
        }

        public GetSubscriptionByKeyAndVersionApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetSubscriptionByKeyAndVersionApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SubscriptionsApi.this.getSubscriptionByKeyAndVersionCall(this.subscriptionKey, this.version, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.chargeDetail, this.excludeRatePlansWithNoCharges, this.getDetailedMetrics, this.asOfDay, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetSubscriptionResponse execute() throws ApiException {
            ApiResponse localVarResp = SubscriptionsApi.this.getSubscriptionByKeyAndVersionWithHttpInfo(this.subscriptionKey, this.version, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.chargeDetail, this.excludeRatePlansWithNoCharges, this.getDetailedMetrics, this.asOfDay, this.zuoraVersion, this.zuoraOrgIds);
            return (GetSubscriptionResponse)localVarResp.getData();
        }

        private ApiResponse<GetSubscriptionResponse> executeWithHttpInfo() throws ApiException {
            return SubscriptionsApi.this.getSubscriptionByKeyAndVersionWithHttpInfo(this.subscriptionKey, this.version, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.chargeDetail, this.excludeRatePlansWithNoCharges, this.getDetailedMetrics, this.asOfDay, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetSubscriptionResponse> _callback) throws ApiException {
            return SubscriptionsApi.this.getSubscriptionByKeyAndVersionAsync(this.subscriptionKey, this.version, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.chargeDetail, this.excludeRatePlansWithNoCharges, this.getDetailedMetrics, this.asOfDay, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetSubscriptionByKeyApi {
        private final String subscriptionKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String chargeDetail;
        private Boolean excludeRatePlansWithNoCharges;
        private Boolean getDetailedMetrics;
        private String asOfDay;
        private Boolean getSubscriptionOwnerDetails;
        private Boolean getInvoiceOwnerDetails;
        private String zuoraOrgIds;

        private GetSubscriptionByKeyApi(String subscriptionKey) {
            this.subscriptionKey = subscriptionKey;
        }

        public GetSubscriptionByKeyApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetSubscriptionByKeyApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetSubscriptionByKeyApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetSubscriptionByKeyApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetSubscriptionByKeyApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetSubscriptionByKeyApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetSubscriptionByKeyApi chargeDetail(String chargeDetail) {
            this.chargeDetail = chargeDetail;
            return this;
        }

        public GetSubscriptionByKeyApi excludeRatePlansWithNoCharges(Boolean excludeRatePlansWithNoCharges) {
            this.excludeRatePlansWithNoCharges = excludeRatePlansWithNoCharges;
            return this;
        }

        public GetSubscriptionByKeyApi getDetailedMetrics(Boolean getDetailedMetrics) {
            this.getDetailedMetrics = getDetailedMetrics;
            return this;
        }

        public GetSubscriptionByKeyApi asOfDay(String asOfDay) {
            this.asOfDay = asOfDay;
            return this;
        }

        public GetSubscriptionByKeyApi getSubscriptionOwnerDetails(Boolean getSubscriptionOwnerDetails) {
            this.getSubscriptionOwnerDetails = getSubscriptionOwnerDetails;
            return this;
        }

        public GetSubscriptionByKeyApi getInvoiceOwnerDetails(Boolean getInvoiceOwnerDetails) {
            this.getInvoiceOwnerDetails = getInvoiceOwnerDetails;
            return this;
        }

        public GetSubscriptionByKeyApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SubscriptionsApi.this.getSubscriptionByKeyCall(this.subscriptionKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.chargeDetail, this.excludeRatePlansWithNoCharges, this.getDetailedMetrics, this.asOfDay, this.getSubscriptionOwnerDetails, this.getInvoiceOwnerDetails, this.zuoraOrgIds, _callback);
        }

        public GetSubscriptionResponse execute() throws ApiException {
            ApiResponse localVarResp = SubscriptionsApi.this.getSubscriptionByKeyWithHttpInfo(this.subscriptionKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.chargeDetail, this.excludeRatePlansWithNoCharges, this.getDetailedMetrics, this.asOfDay, this.getSubscriptionOwnerDetails, this.getInvoiceOwnerDetails, this.zuoraOrgIds);
            return (GetSubscriptionResponse)localVarResp.getData();
        }

        private ApiResponse<GetSubscriptionResponse> executeWithHttpInfo() throws ApiException {
            return SubscriptionsApi.this.getSubscriptionByKeyWithHttpInfo(this.subscriptionKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.chargeDetail, this.excludeRatePlansWithNoCharges, this.getDetailedMetrics, this.asOfDay, this.getSubscriptionOwnerDetails, this.getInvoiceOwnerDetails, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetSubscriptionResponse> _callback) throws ApiException {
            return SubscriptionsApi.this.getSubscriptionByKeyAsync(this.subscriptionKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.chargeDetail, this.excludeRatePlansWithNoCharges, this.getDetailedMetrics, this.asOfDay, this.getSubscriptionOwnerDetails, this.getInvoiceOwnerDetails, this.zuoraOrgIds, _callback);
        }
    }

    public class GetMetricsBySubscriptionNumbersApi {
        private final List<String> subscriptionNumbers;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String asOfDay;
        private String zuoraOrgIds;

        private GetMetricsBySubscriptionNumbersApi(List<String> subscriptionNumbers) {
            this.subscriptionNumbers = subscriptionNumbers;
        }

        public GetMetricsBySubscriptionNumbersApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetMetricsBySubscriptionNumbersApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetMetricsBySubscriptionNumbersApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetMetricsBySubscriptionNumbersApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetMetricsBySubscriptionNumbersApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetMetricsBySubscriptionNumbersApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetMetricsBySubscriptionNumbersApi asOfDay(String asOfDay) {
            this.asOfDay = asOfDay;
            return this;
        }

        public GetMetricsBySubscriptionNumbersApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SubscriptionsApi.this.getMetricsBySubscriptionNumbersCall(this.subscriptionNumbers, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.asOfDay, this.zuoraOrgIds, _callback);
        }

        public GetMetricsBySubscriptionNumbersResponse execute() throws ApiException {
            ApiResponse localVarResp = SubscriptionsApi.this.getMetricsBySubscriptionNumbersWithHttpInfo(this.subscriptionNumbers, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.asOfDay, this.zuoraOrgIds);
            return (GetMetricsBySubscriptionNumbersResponse)localVarResp.getData();
        }

        private ApiResponse<GetMetricsBySubscriptionNumbersResponse> executeWithHttpInfo() throws ApiException {
            return SubscriptionsApi.this.getMetricsBySubscriptionNumbersWithHttpInfo(this.subscriptionNumbers, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.asOfDay, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetMetricsBySubscriptionNumbersResponse> _callback) throws ApiException {
            return SubscriptionsApi.this.getMetricsBySubscriptionNumbersAsync(this.subscriptionNumbers, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.asOfDay, this.zuoraOrgIds, _callback);
        }
    }

    public class DeleteSubscriptionApi {
        private final String subscriptionKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private DeleteSubscriptionApi(String subscriptionKey) {
            this.subscriptionKey = subscriptionKey;
        }

        public DeleteSubscriptionApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public DeleteSubscriptionApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public DeleteSubscriptionApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public DeleteSubscriptionApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public DeleteSubscriptionApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public DeleteSubscriptionApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public DeleteSubscriptionApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SubscriptionsApi.this.deleteSubscriptionCall(this.subscriptionKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public DeleteSubscriptionResponse execute() throws ApiException {
            ApiResponse localVarResp = SubscriptionsApi.this.deleteSubscriptionWithHttpInfo(this.subscriptionKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (DeleteSubscriptionResponse)localVarResp.getData();
        }

        private ApiResponse<DeleteSubscriptionResponse> executeWithHttpInfo() throws ApiException {
            return SubscriptionsApi.this.deleteSubscriptionWithHttpInfo(this.subscriptionKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<DeleteSubscriptionResponse> _callback) throws ApiException {
            return SubscriptionsApi.this.deleteSubscriptionAsync(this.subscriptionKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CreateSubscriptionApi {
        private final CreateSubscriptionRequest request;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CreateSubscriptionApi(CreateSubscriptionRequest request) {
            this.request = request;
        }

        public CreateSubscriptionApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateSubscriptionApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreateSubscriptionApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreateSubscriptionApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreateSubscriptionApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreateSubscriptionApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreateSubscriptionApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreateSubscriptionApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SubscriptionsApi.this.createSubscriptionCall(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreateSubscriptionResponse execute() throws ApiException {
            ApiResponse localVarResp = SubscriptionsApi.this.createSubscriptionWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (CreateSubscriptionResponse)localVarResp.getData();
        }

        private ApiResponse<CreateSubscriptionResponse> executeWithHttpInfo() throws ApiException {
            return SubscriptionsApi.this.createSubscriptionWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreateSubscriptionResponse> _callback) throws ApiException {
            return SubscriptionsApi.this.createSubscriptionAsync(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CancelSubscriptionApi {
        private final String subscriptionKey;
        private final CancelSubscriptionRequest request;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CancelSubscriptionApi(String subscriptionKey, CancelSubscriptionRequest request) {
            this.subscriptionKey = subscriptionKey;
            this.request = request;
        }

        public CancelSubscriptionApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CancelSubscriptionApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CancelSubscriptionApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CancelSubscriptionApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CancelSubscriptionApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CancelSubscriptionApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CancelSubscriptionApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SubscriptionsApi.this.cancelSubscriptionCall(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CancelSubscriptionResponse execute() throws ApiException {
            ApiResponse localVarResp = SubscriptionsApi.this.cancelSubscriptionWithHttpInfo(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (CancelSubscriptionResponse)localVarResp.getData();
        }

        private ApiResponse<CancelSubscriptionResponse> executeWithHttpInfo() throws ApiException {
            return SubscriptionsApi.this.cancelSubscriptionWithHttpInfo(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CancelSubscriptionResponse> _callback) throws ApiException {
            return SubscriptionsApi.this.cancelSubscriptionAsync(this.subscriptionKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }
}

