/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.DeleteResult;
import com.zuora.model.ProxyActioncreateRequest;
import com.zuora.model.ProxyActiondeleteRequest;
import com.zuora.model.ProxyActionqueryMoreRequest;
import com.zuora.model.ProxyActionqueryMoreResponse;
import com.zuora.model.ProxyActionqueryRequest;
import com.zuora.model.ProxyActionqueryResponse;
import com.zuora.model.ProxyActionupdateRequest;
import com.zuora.model.SaveResult;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class ActionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ActionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ActionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call actionPostCreateCall(ProxyActioncreateRequest createRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ProxyActioncreateRequest localVarPostBody = createRequest;
        String localVarPath = "/v1/action/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (rejectUnknownFields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("rejectUnknownFields", rejectUnknownFields));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (xZuoraWSDLVersion != null) {
            localVarHeaderParams.put("X-Zuora-WSDL-Version", this.localVarApiClient.parameterToString(xZuoraWSDLVersion));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call actionPostCreateValidateBeforeCall(ProxyActioncreateRequest createRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (createRequest == null) {
            throw new ApiException("Missing the required parameter 'createRequest' when calling actionPostCreate(Async)");
        }
        return this.actionPostCreateCall(createRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected List<SaveResult> actionPostCreate(ProxyActioncreateRequest createRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<List<SaveResult>> localVarResp = this.actionPostCreateWithHttpInfo(createRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<List<SaveResult>> actionPostCreateWithHttpInfo(ProxyActioncreateRequest createRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.actionPostCreateValidateBeforeCall(createRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<List<SaveResult>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call actionPostCreateAsync(ProxyActioncreateRequest createRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback<List<SaveResult>> _callback) throws ApiException {
        Call localVarCall = this.actionPostCreateValidateBeforeCall(createRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<List<SaveResult>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ActionPostCreateApi actionPostCreateApi(ProxyActioncreateRequest createRequest) {
        return new ActionPostCreateApi(createRequest);
    }

    private Call actionPostDeleteCall(ProxyActiondeleteRequest deleteRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ProxyActiondeleteRequest localVarPostBody = deleteRequest;
        String localVarPath = "/v1/action/delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (rejectUnknownFields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("rejectUnknownFields", rejectUnknownFields));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (xZuoraWSDLVersion != null) {
            localVarHeaderParams.put("X-Zuora-WSDL-Version", this.localVarApiClient.parameterToString(xZuoraWSDLVersion));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call actionPostDeleteValidateBeforeCall(ProxyActiondeleteRequest deleteRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (deleteRequest == null) {
            throw new ApiException("Missing the required parameter 'deleteRequest' when calling actionPostDelete(Async)");
        }
        return this.actionPostDeleteCall(deleteRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected List<DeleteResult> actionPostDelete(ProxyActiondeleteRequest deleteRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<List<DeleteResult>> localVarResp = this.actionPostDeleteWithHttpInfo(deleteRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<List<DeleteResult>> actionPostDeleteWithHttpInfo(ProxyActiondeleteRequest deleteRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.actionPostDeleteValidateBeforeCall(deleteRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<List<DeleteResult>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call actionPostDeleteAsync(ProxyActiondeleteRequest deleteRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback<List<DeleteResult>> _callback) throws ApiException {
        Call localVarCall = this.actionPostDeleteValidateBeforeCall(deleteRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<List<DeleteResult>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ActionPostDeleteApi actionPostDeleteApi(ProxyActiondeleteRequest deleteRequest) {
        return new ActionPostDeleteApi(deleteRequest);
    }

    private Call actionPostQueryCall(ProxyActionqueryRequest queryRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ProxyActionqueryRequest localVarPostBody = queryRequest;
        String localVarPath = "/v1/action/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (rejectUnknownFields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("rejectUnknownFields", rejectUnknownFields));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (xZuoraWSDLVersion != null) {
            localVarHeaderParams.put("X-Zuora-WSDL-Version", this.localVarApiClient.parameterToString(xZuoraWSDLVersion));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call actionPostQueryValidateBeforeCall(ProxyActionqueryRequest queryRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (queryRequest == null) {
            throw new ApiException("Missing the required parameter 'queryRequest' when calling actionPostQuery(Async)");
        }
        return this.actionPostQueryCall(queryRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected ProxyActionqueryResponse actionPostQuery(ProxyActionqueryRequest queryRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<ProxyActionqueryResponse> localVarResp = this.actionPostQueryWithHttpInfo(queryRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<ProxyActionqueryResponse> actionPostQueryWithHttpInfo(ProxyActionqueryRequest queryRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.actionPostQueryValidateBeforeCall(queryRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<ProxyActionqueryResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call actionPostQueryAsync(ProxyActionqueryRequest queryRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback<ProxyActionqueryResponse> _callback) throws ApiException {
        Call localVarCall = this.actionPostQueryValidateBeforeCall(queryRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<ProxyActionqueryResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ActionPostQueryApi actionPostQueryApi(ProxyActionqueryRequest queryRequest) {
        return new ActionPostQueryApi(queryRequest);
    }

    private Call actionPostqueryMoreCall(ProxyActionqueryMoreRequest queryMoreRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ProxyActionqueryMoreRequest localVarPostBody = queryMoreRequest;
        String localVarPath = "/v1/action/queryMore";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (rejectUnknownFields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("rejectUnknownFields", rejectUnknownFields));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (xZuoraWSDLVersion != null) {
            localVarHeaderParams.put("X-Zuora-WSDL-Version", this.localVarApiClient.parameterToString(xZuoraWSDLVersion));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call actionPostqueryMoreValidateBeforeCall(ProxyActionqueryMoreRequest queryMoreRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (queryMoreRequest == null) {
            throw new ApiException("Missing the required parameter 'queryMoreRequest' when calling actionPostqueryMore(Async)");
        }
        return this.actionPostqueryMoreCall(queryMoreRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected ProxyActionqueryMoreResponse actionPostqueryMore(ProxyActionqueryMoreRequest queryMoreRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<ProxyActionqueryMoreResponse> localVarResp = this.actionPostqueryMoreWithHttpInfo(queryMoreRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<ProxyActionqueryMoreResponse> actionPostqueryMoreWithHttpInfo(ProxyActionqueryMoreRequest queryMoreRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.actionPostqueryMoreValidateBeforeCall(queryMoreRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<ProxyActionqueryMoreResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call actionPostqueryMoreAsync(ProxyActionqueryMoreRequest queryMoreRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback<ProxyActionqueryMoreResponse> _callback) throws ApiException {
        Call localVarCall = this.actionPostqueryMoreValidateBeforeCall(queryMoreRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<ProxyActionqueryMoreResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ActionPostqueryMoreApi actionPostqueryMoreApi(ProxyActionqueryMoreRequest queryMoreRequest) {
        return new ActionPostqueryMoreApi(queryMoreRequest);
    }

    private Call actionPostupdateCall(ProxyActionupdateRequest updateRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ProxyActionupdateRequest localVarPostBody = updateRequest;
        String localVarPath = "/v1/action/update";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (rejectUnknownFields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("rejectUnknownFields", rejectUnknownFields));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (xZuoraWSDLVersion != null) {
            localVarHeaderParams.put("X-Zuora-WSDL-Version", this.localVarApiClient.parameterToString(xZuoraWSDLVersion));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call actionPostupdateValidateBeforeCall(ProxyActionupdateRequest updateRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (updateRequest == null) {
            throw new ApiException("Missing the required parameter 'updateRequest' when calling actionPostupdate(Async)");
        }
        return this.actionPostupdateCall(updateRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected List<SaveResult> actionPostupdate(ProxyActionupdateRequest updateRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<List<SaveResult>> localVarResp = this.actionPostupdateWithHttpInfo(updateRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<List<SaveResult>> actionPostupdateWithHttpInfo(ProxyActionupdateRequest updateRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.actionPostupdateValidateBeforeCall(updateRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<List<SaveResult>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call actionPostupdateAsync(ProxyActionupdateRequest updateRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback<List<SaveResult>> _callback) throws ApiException {
        Call localVarCall = this.actionPostupdateValidateBeforeCall(updateRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<List<SaveResult>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ActionPostupdateApi actionPostupdateApi(ProxyActionupdateRequest updateRequest) {
        return new ActionPostupdateApi(updateRequest);
    }

    public class ActionPostupdateApi {
        private final ProxyActionupdateRequest updateRequest;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private Boolean rejectUnknownFields;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String xZuoraWSDLVersion;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private ActionPostupdateApi(ProxyActionupdateRequest updateRequest) {
            this.updateRequest = updateRequest;
        }

        public ActionPostupdateApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public ActionPostupdateApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public ActionPostupdateApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public ActionPostupdateApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public ActionPostupdateApi rejectUnknownFields(Boolean rejectUnknownFields) {
            this.rejectUnknownFields = rejectUnknownFields;
            return this;
        }

        public ActionPostupdateApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public ActionPostupdateApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public ActionPostupdateApi xZuoraWSDLVersion(String xZuoraWSDLVersion) {
            this.xZuoraWSDLVersion = xZuoraWSDLVersion;
            return this;
        }

        public ActionPostupdateApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public ActionPostupdateApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ActionsApi.this.actionPostupdateCall(this.updateRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public List<SaveResult> execute() throws ApiException {
            ApiResponse localVarResp = ActionsApi.this.actionPostupdateWithHttpInfo(this.updateRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds);
            return (List)localVarResp.getData();
        }

        private ApiResponse<List<SaveResult>> executeWithHttpInfo() throws ApiException {
            return ActionsApi.this.actionPostupdateWithHttpInfo(this.updateRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<List<SaveResult>> _callback) throws ApiException {
            return ActionsApi.this.actionPostupdateAsync(this.updateRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class ActionPostqueryMoreApi {
        private final ProxyActionqueryMoreRequest queryMoreRequest;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private Boolean rejectUnknownFields;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String xZuoraWSDLVersion;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private ActionPostqueryMoreApi(ProxyActionqueryMoreRequest queryMoreRequest) {
            this.queryMoreRequest = queryMoreRequest;
        }

        public ActionPostqueryMoreApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public ActionPostqueryMoreApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public ActionPostqueryMoreApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public ActionPostqueryMoreApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public ActionPostqueryMoreApi rejectUnknownFields(Boolean rejectUnknownFields) {
            this.rejectUnknownFields = rejectUnknownFields;
            return this;
        }

        public ActionPostqueryMoreApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public ActionPostqueryMoreApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public ActionPostqueryMoreApi xZuoraWSDLVersion(String xZuoraWSDLVersion) {
            this.xZuoraWSDLVersion = xZuoraWSDLVersion;
            return this;
        }

        public ActionPostqueryMoreApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public ActionPostqueryMoreApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ActionsApi.this.actionPostqueryMoreCall(this.queryMoreRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public ProxyActionqueryMoreResponse execute() throws ApiException {
            ApiResponse localVarResp = ActionsApi.this.actionPostqueryMoreWithHttpInfo(this.queryMoreRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds);
            return (ProxyActionqueryMoreResponse)localVarResp.getData();
        }

        private ApiResponse<ProxyActionqueryMoreResponse> executeWithHttpInfo() throws ApiException {
            return ActionsApi.this.actionPostqueryMoreWithHttpInfo(this.queryMoreRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<ProxyActionqueryMoreResponse> _callback) throws ApiException {
            return ActionsApi.this.actionPostqueryMoreAsync(this.queryMoreRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class ActionPostQueryApi {
        private final ProxyActionqueryRequest queryRequest;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private Boolean rejectUnknownFields;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String xZuoraWSDLVersion;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private ActionPostQueryApi(ProxyActionqueryRequest queryRequest) {
            this.queryRequest = queryRequest;
        }

        public ActionPostQueryApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public ActionPostQueryApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public ActionPostQueryApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public ActionPostQueryApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public ActionPostQueryApi rejectUnknownFields(Boolean rejectUnknownFields) {
            this.rejectUnknownFields = rejectUnknownFields;
            return this;
        }

        public ActionPostQueryApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public ActionPostQueryApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public ActionPostQueryApi xZuoraWSDLVersion(String xZuoraWSDLVersion) {
            this.xZuoraWSDLVersion = xZuoraWSDLVersion;
            return this;
        }

        public ActionPostQueryApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public ActionPostQueryApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ActionsApi.this.actionPostQueryCall(this.queryRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public ProxyActionqueryResponse execute() throws ApiException {
            ApiResponse localVarResp = ActionsApi.this.actionPostQueryWithHttpInfo(this.queryRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds);
            return (ProxyActionqueryResponse)localVarResp.getData();
        }

        private ApiResponse<ProxyActionqueryResponse> executeWithHttpInfo() throws ApiException {
            return ActionsApi.this.actionPostQueryWithHttpInfo(this.queryRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<ProxyActionqueryResponse> _callback) throws ApiException {
            return ActionsApi.this.actionPostQueryAsync(this.queryRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class ActionPostDeleteApi {
        private final ProxyActiondeleteRequest deleteRequest;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private Boolean rejectUnknownFields;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String xZuoraWSDLVersion;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private ActionPostDeleteApi(ProxyActiondeleteRequest deleteRequest) {
            this.deleteRequest = deleteRequest;
        }

        public ActionPostDeleteApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public ActionPostDeleteApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public ActionPostDeleteApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public ActionPostDeleteApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public ActionPostDeleteApi rejectUnknownFields(Boolean rejectUnknownFields) {
            this.rejectUnknownFields = rejectUnknownFields;
            return this;
        }

        public ActionPostDeleteApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public ActionPostDeleteApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public ActionPostDeleteApi xZuoraWSDLVersion(String xZuoraWSDLVersion) {
            this.xZuoraWSDLVersion = xZuoraWSDLVersion;
            return this;
        }

        public ActionPostDeleteApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public ActionPostDeleteApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ActionsApi.this.actionPostDeleteCall(this.deleteRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public List<DeleteResult> execute() throws ApiException {
            ApiResponse localVarResp = ActionsApi.this.actionPostDeleteWithHttpInfo(this.deleteRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds);
            return (List)localVarResp.getData();
        }

        private ApiResponse<List<DeleteResult>> executeWithHttpInfo() throws ApiException {
            return ActionsApi.this.actionPostDeleteWithHttpInfo(this.deleteRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<List<DeleteResult>> _callback) throws ApiException {
            return ActionsApi.this.actionPostDeleteAsync(this.deleteRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class ActionPostCreateApi {
        private final ProxyActioncreateRequest createRequest;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private Boolean rejectUnknownFields;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String xZuoraWSDLVersion;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private ActionPostCreateApi(ProxyActioncreateRequest createRequest) {
            this.createRequest = createRequest;
        }

        public ActionPostCreateApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public ActionPostCreateApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public ActionPostCreateApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public ActionPostCreateApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public ActionPostCreateApi rejectUnknownFields(Boolean rejectUnknownFields) {
            this.rejectUnknownFields = rejectUnknownFields;
            return this;
        }

        public ActionPostCreateApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public ActionPostCreateApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public ActionPostCreateApi xZuoraWSDLVersion(String xZuoraWSDLVersion) {
            this.xZuoraWSDLVersion = xZuoraWSDLVersion;
            return this;
        }

        public ActionPostCreateApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public ActionPostCreateApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ActionsApi.this.actionPostCreateCall(this.createRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public List<SaveResult> execute() throws ApiException {
            ApiResponse localVarResp = ActionsApi.this.actionPostCreateWithHttpInfo(this.createRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds);
            return (List)localVarResp.getData();
        }

        private ApiResponse<List<SaveResult>> executeWithHttpInfo() throws ApiException {
            return ActionsApi.this.actionPostCreateWithHttpInfo(this.createRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<List<SaveResult>> _callback) throws ApiException {
            return ActionsApi.this.actionPostCreateAsync(this.createRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }
}

