/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.BillingDocument;
import org.openapitools.client.model.BillingDocumentCreateRequest;
import org.openapitools.client.model.BillingDocumentListResponse;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.ListQueryParams;

public class BillingDocumentsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public BillingDocumentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BillingDocumentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getBillingDocumentCall(String billingDocumentId, List<String> fields, List<String> billingDocumentFields, List<String> billingDocumentItemsFields, List<String> taxationItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/billing_documents/{billing_document_id}".replace("{billing_document_id}", this.localVarApiClient.escapeString(billingDocumentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (billingDocumentFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "billing_document.fields[]", billingDocumentFields));
        }
        if (billingDocumentItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "billing_document_items.fields[]", billingDocumentItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBillingDocumentValidateBeforeCall(String billingDocumentId, List<String> fields, List<String> billingDocumentFields, List<String> billingDocumentItemsFields, List<String> taxationItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (billingDocumentId == null) {
            throw new ApiException("Missing the required parameter 'billingDocumentId' when calling getBillingDocument(Async)");
        }
        return this.getBillingDocumentCall(billingDocumentId, fields, billingDocumentFields, billingDocumentItemsFields, taxationItemsFields, expand, filter, pageSize, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<BillingDocument> getBillingDocumentWithHttpInfo(String billingDocumentId, List<String> fields, List<String> billingDocumentFields, List<String> billingDocumentItemsFields, List<String> taxationItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getBillingDocumentValidateBeforeCall(billingDocumentId, fields, billingDocumentFields, billingDocumentItemsFields, taxationItemsFields, expand, filter, pageSize, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<BillingDocument>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getBillingDocumentAsync(String billingDocumentId, List<String> fields, List<String> billingDocumentFields, List<String> billingDocumentItemsFields, List<String> taxationItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<BillingDocument> _callback) throws ApiException {
        Call localVarCall = this.getBillingDocumentValidateBeforeCall(billingDocumentId, fields, billingDocumentFields, billingDocumentItemsFields, taxationItemsFields, expand, filter, pageSize, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<BillingDocument>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetBillingDocumentParams getBillingDocumentParams(String billingDocumentId) {
        return new GetBillingDocumentParams(billingDocumentId);
    }

    public BillingDocument getBillingDocument(String billingDocumentId) throws ApiException {
        GetBillingDocumentParams params = new GetBillingDocumentParams(billingDocumentId);
        return this.executeGetBillingDocumentAPICall(params).getData();
    }

    public BillingDocument getBillingDocument(String billingDocumentId, List<String> expand) throws ApiException {
        GetBillingDocumentParams params = new GetBillingDocumentParams(billingDocumentId);
        params.expand(expand);
        return this.executeGetBillingDocumentAPICall(params).getData();
    }

    public BillingDocument getBillingDocument(String billingDocumentId, List<String> expand, Headers headers) throws ApiException {
        GetBillingDocumentParams params = new GetBillingDocumentParams(billingDocumentId).expand(expand).headers(headers);
        return this.executeGetBillingDocumentAPICall(params).getData();
    }

    public BillingDocument get(GetBillingDocumentParams params) throws ApiException {
        return this.executeGetBillingDocumentAPICall(params).getData();
    }

    public ApiResponse<BillingDocument> getWithHttpInfo(GetBillingDocumentParams params) throws ApiException {
        return this.executeGetBillingDocumentAPICall(params);
    }

    ApiResponse<BillingDocument> executeGetBillingDocumentAPICall(GetBillingDocumentParams params) throws ApiException {
        return this.getBillingDocumentWithHttpInfo(params.billingDocumentId, params.fields, params.billingDocumentFields, params.billingDocumentItemsFields, params.taxationItemsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getBillingDocumentsCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> billingDocumentFields, List<String> billingDocumentItemsFields, List<String> taxationItemsFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/billing_documents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (billingDocumentFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "billing_document.fields[]", billingDocumentFields));
        }
        if (billingDocumentItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "billing_document_items.fields[]", billingDocumentItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBillingDocumentsValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> billingDocumentFields, List<String> billingDocumentItemsFields, List<String> taxationItemsFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getBillingDocumentsCall(cursor, expand, filter, sort, pageSize, fields, billingDocumentFields, billingDocumentItemsFields, taxationItemsFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<BillingDocumentListResponse> getBillingDocumentsWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> billingDocumentFields, List<String> billingDocumentItemsFields, List<String> taxationItemsFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getBillingDocumentsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, billingDocumentFields, billingDocumentItemsFields, taxationItemsFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<BillingDocumentListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getBillingDocumentsAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> billingDocumentFields, List<String> billingDocumentItemsFields, List<String> taxationItemsFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<BillingDocumentListResponse> _callback) throws ApiException {
        Call localVarCall = this.getBillingDocumentsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, billingDocumentFields, billingDocumentItemsFields, taxationItemsFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<BillingDocumentListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetBillingDocumentsParams getBillingDocumentsParams() {
        return new GetBillingDocumentsParams();
    }

    public BillingDocumentListResponse getBillingDocuments() throws ApiException {
        GetBillingDocumentsParams params = new GetBillingDocumentsParams();
        return this.executeGetBillingDocumentsAPICall(params).getData();
    }

    public BillingDocumentListResponse getBillingDocuments(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetBillingDocumentsParams params = new GetBillingDocumentsParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetBillingDocumentsAPICall(params).getData();
    }

    public BillingDocumentListResponse getBillingDocuments(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetBillingDocumentsParams params = new GetBillingDocumentsParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetBillingDocumentsAPICall(params).getData();
    }

    public BillingDocumentListResponse list(GetBillingDocumentsParams params) throws ApiException {
        return this.executeGetBillingDocumentsAPICall(params).getData();
    }

    public ApiResponse<BillingDocumentListResponse> listWithHttpInfo(GetBillingDocumentsParams params) throws ApiException {
        return this.executeGetBillingDocumentsAPICall(params);
    }

    ApiResponse<BillingDocumentListResponse> executeGetBillingDocumentsAPICall(GetBillingDocumentsParams params) throws ApiException {
        return this.getBillingDocumentsWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.billingDocumentFields, params.billingDocumentItemsFields, params.taxationItemsFields, params.zuoraTrackId, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call postBillingDocumentCall(BillingDocumentCreateRequest billingDocumentCreateRequest, List<String> fields, List<String> billingDocumentFields, List<String> billingDocumentItemsFields, List<String> taxationItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BillingDocumentCreateRequest localVarPostBody = billingDocumentCreateRequest;
        String localVarPath = "/billing_documents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (billingDocumentFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "billing_document.fields[]", billingDocumentFields));
        }
        if (billingDocumentItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "billing_document_items.fields[]", billingDocumentItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postBillingDocumentValidateBeforeCall(BillingDocumentCreateRequest billingDocumentCreateRequest, List<String> fields, List<String> billingDocumentFields, List<String> billingDocumentItemsFields, List<String> taxationItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (billingDocumentCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'billingDocumentCreateRequest' when calling postBillingDocument(Async)");
        }
        return this.postBillingDocumentCall(billingDocumentCreateRequest, fields, billingDocumentFields, billingDocumentItemsFields, taxationItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<BillingDocument> postBillingDocumentWithHttpInfo(BillingDocumentCreateRequest billingDocumentCreateRequest, List<String> fields, List<String> billingDocumentFields, List<String> billingDocumentItemsFields, List<String> taxationItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.postBillingDocumentValidateBeforeCall(billingDocumentCreateRequest, fields, billingDocumentFields, billingDocumentItemsFields, taxationItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<BillingDocument>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call postBillingDocumentAsync(BillingDocumentCreateRequest billingDocumentCreateRequest, List<String> fields, List<String> billingDocumentFields, List<String> billingDocumentItemsFields, List<String> taxationItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<BillingDocument> _callback) throws ApiException {
        Call localVarCall = this.postBillingDocumentValidateBeforeCall(billingDocumentCreateRequest, fields, billingDocumentFields, billingDocumentItemsFields, taxationItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<BillingDocument>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostBillingDocumentParams postBillingDocumentParams(BillingDocumentCreateRequest billingDocumentCreateRequest) {
        return new PostBillingDocumentParams(billingDocumentCreateRequest);
    }

    public BillingDocument postBillingDocument(BillingDocumentCreateRequest billingDocumentCreateRequest) throws ApiException {
        PostBillingDocumentParams params = new PostBillingDocumentParams(billingDocumentCreateRequest);
        return this.executePostBillingDocumentAPICall(params).getData();
    }

    public BillingDocument postBillingDocument(BillingDocumentCreateRequest billingDocumentCreateRequest, List<String> expand) throws ApiException {
        PostBillingDocumentParams params = new PostBillingDocumentParams(billingDocumentCreateRequest);
        params.expand(expand);
        return this.executePostBillingDocumentAPICall(params).getData();
    }

    public BillingDocument postBillingDocument(BillingDocumentCreateRequest billingDocumentCreateRequest, List<String> expand, Headers headers) throws ApiException {
        PostBillingDocumentParams params = new PostBillingDocumentParams(billingDocumentCreateRequest).expand(expand).headers(headers);
        return this.executePostBillingDocumentAPICall(params).getData();
    }

    public BillingDocument create(PostBillingDocumentParams params) throws ApiException {
        return this.executePostBillingDocumentAPICall(params).getData();
    }

    public ApiResponse<BillingDocument> createWithHttpInfo(PostBillingDocumentParams params) throws ApiException {
        return this.executePostBillingDocumentAPICall(params);
    }

    ApiResponse<BillingDocument> executePostBillingDocumentAPICall(PostBillingDocumentParams params) throws ApiException {
        return this.postBillingDocumentWithHttpInfo(params.billingDocumentCreateRequest, params.fields, params.billingDocumentFields, params.billingDocumentItemsFields, params.taxationItemsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    public static class PostBillingDocumentParams {
        private final BillingDocumentCreateRequest billingDocumentCreateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> billingDocumentFields;
        private List<String> billingDocumentItemsFields;
        private List<String> taxationItemsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public PostBillingDocumentParams(BillingDocumentCreateRequest billingDocumentCreateRequest) {
            this.billingDocumentCreateRequest = billingDocumentCreateRequest;
        }

        public PostBillingDocumentParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public PostBillingDocumentParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public PostBillingDocumentParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public PostBillingDocumentParams billingDocumentFields(List<String> billingDocumentFields) {
            this.billingDocumentFields = billingDocumentFields;
            return this;
        }

        public PostBillingDocumentParams billingDocumentItemsFields(List<String> billingDocumentItemsFields) {
            this.billingDocumentItemsFields = billingDocumentItemsFields;
            return this;
        }

        public PostBillingDocumentParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public PostBillingDocumentParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public PostBillingDocumentParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public PostBillingDocumentParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class GetBillingDocumentsParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> billingDocumentFields;
        private List<String> billingDocumentItemsFields;
        private List<String> taxationItemsFields;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetBillingDocumentsParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetBillingDocumentsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetBillingDocumentsParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetBillingDocumentsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetBillingDocumentsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetBillingDocumentsParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetBillingDocumentsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetBillingDocumentsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetBillingDocumentsParams billingDocumentFields(List<String> billingDocumentFields) {
            this.billingDocumentFields = billingDocumentFields;
            return this;
        }

        public GetBillingDocumentsParams billingDocumentItemsFields(List<String> billingDocumentItemsFields) {
            this.billingDocumentItemsFields = billingDocumentItemsFields;
            return this;
        }

        public GetBillingDocumentsParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }
    }

    public static class GetBillingDocumentParams {
        private final String billingDocumentId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> billingDocumentFields;
        private List<String> billingDocumentItemsFields;
        private List<String> taxationItemsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetBillingDocumentParams(String billingDocumentId) {
            this.billingDocumentId = billingDocumentId;
        }

        public GetBillingDocumentParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetBillingDocumentParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetBillingDocumentParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetBillingDocumentParams billingDocumentFields(List<String> billingDocumentFields) {
            this.billingDocumentFields = billingDocumentFields;
            return this;
        }

        public GetBillingDocumentParams billingDocumentItemsFields(List<String> billingDocumentItemsFields) {
            this.billingDocumentItemsFields = billingDocumentItemsFields;
            return this;
        }

        public GetBillingDocumentParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public GetBillingDocumentParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetBillingDocumentParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetBillingDocumentParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

