/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.FilfillmentListResponse;
import org.openapitools.client.model.Fulfillment;
import org.openapitools.client.model.FulfillmentCreateBulkRequest;
import org.openapitools.client.model.FulfillmentCreateBulkResponse;
import org.openapitools.client.model.FulfillmentCreateRequest;
import org.openapitools.client.model.FulfillmentPatchRequest;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.ListQueryParams;

public class FulfillmentsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public FulfillmentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FulfillmentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createFulfillmentCall(FulfillmentCreateRequest fulfillmentCreateRequest, List<String> fields, List<String> fulfillmentFields, List<String> fulfillmentItemFields, List<String> creditMemoItemFields, List<String> invoiceItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FulfillmentCreateRequest localVarPostBody = fulfillmentCreateRequest;
        String localVarPath = "/fulfillments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (fulfillmentFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fulfillment.fields[]", fulfillmentFields));
        }
        if (fulfillmentItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fulfillment_item.fields[]", fulfillmentItemFields));
        }
        if (creditMemoItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo_item.fields[]", creditMemoItemFields));
        }
        if (invoiceItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_item.fields[]", invoiceItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createFulfillmentValidateBeforeCall(FulfillmentCreateRequest fulfillmentCreateRequest, List<String> fields, List<String> fulfillmentFields, List<String> fulfillmentItemFields, List<String> creditMemoItemFields, List<String> invoiceItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (fulfillmentCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'fulfillmentCreateRequest' when calling createFulfillment(Async)");
        }
        return this.createFulfillmentCall(fulfillmentCreateRequest, fields, fulfillmentFields, fulfillmentItemFields, creditMemoItemFields, invoiceItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Fulfillment> createFulfillmentWithHttpInfo(FulfillmentCreateRequest fulfillmentCreateRequest, List<String> fields, List<String> fulfillmentFields, List<String> fulfillmentItemFields, List<String> creditMemoItemFields, List<String> invoiceItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createFulfillmentValidateBeforeCall(fulfillmentCreateRequest, fields, fulfillmentFields, fulfillmentItemFields, creditMemoItemFields, invoiceItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Fulfillment>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createFulfillmentAsync(FulfillmentCreateRequest fulfillmentCreateRequest, List<String> fields, List<String> fulfillmentFields, List<String> fulfillmentItemFields, List<String> creditMemoItemFields, List<String> invoiceItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Fulfillment> _callback) throws ApiException {
        Call localVarCall = this.createFulfillmentValidateBeforeCall(fulfillmentCreateRequest, fields, fulfillmentFields, fulfillmentItemFields, creditMemoItemFields, invoiceItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Fulfillment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateFulfillmentParams createFulfillmentParams(FulfillmentCreateRequest fulfillmentCreateRequest) {
        return new CreateFulfillmentParams(fulfillmentCreateRequest);
    }

    public Fulfillment createFulfillment(FulfillmentCreateRequest fulfillmentCreateRequest) throws ApiException {
        CreateFulfillmentParams params = new CreateFulfillmentParams(fulfillmentCreateRequest);
        return this.executeCreateFulfillmentAPICall(params).getData();
    }

    public Fulfillment createFulfillment(FulfillmentCreateRequest fulfillmentCreateRequest, List<String> expand) throws ApiException {
        CreateFulfillmentParams params = new CreateFulfillmentParams(fulfillmentCreateRequest);
        params.expand(expand);
        return this.executeCreateFulfillmentAPICall(params).getData();
    }

    public Fulfillment createFulfillment(FulfillmentCreateRequest fulfillmentCreateRequest, List<String> expand, Headers headers) throws ApiException {
        CreateFulfillmentParams params = new CreateFulfillmentParams(fulfillmentCreateRequest).expand(expand).headers(headers);
        return this.executeCreateFulfillmentAPICall(params).getData();
    }

    public Fulfillment create(CreateFulfillmentParams params) throws ApiException {
        return this.executeCreateFulfillmentAPICall(params).getData();
    }

    public ApiResponse<Fulfillment> createWithHttpInfo(CreateFulfillmentParams params) throws ApiException {
        return this.executeCreateFulfillmentAPICall(params);
    }

    ApiResponse<Fulfillment> executeCreateFulfillmentAPICall(CreateFulfillmentParams params) throws ApiException {
        return this.createFulfillmentWithHttpInfo(params.fulfillmentCreateRequest, params.fields, params.fulfillmentFields, params.fulfillmentItemFields, params.creditMemoItemFields, params.invoiceItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call createFulfillmentsCall(FulfillmentCreateBulkRequest fulfillmentCreateBulkRequest, List<String> fields, List<String> fulfillmentFields, List<String> fulfillmentItemFields, List<String> creditMemoItemFields, List<String> invoiceItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FulfillmentCreateBulkRequest localVarPostBody = fulfillmentCreateBulkRequest;
        String localVarPath = "/fulfillments/bulk_create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (fulfillmentFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fulfillment.fields[]", fulfillmentFields));
        }
        if (fulfillmentItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fulfillment_item.fields[]", fulfillmentItemFields));
        }
        if (creditMemoItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo_item.fields[]", creditMemoItemFields));
        }
        if (invoiceItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_item.fields[]", invoiceItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createFulfillmentsValidateBeforeCall(FulfillmentCreateBulkRequest fulfillmentCreateBulkRequest, List<String> fields, List<String> fulfillmentFields, List<String> fulfillmentItemFields, List<String> creditMemoItemFields, List<String> invoiceItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (fulfillmentCreateBulkRequest == null) {
            throw new ApiException("Missing the required parameter 'fulfillmentCreateBulkRequest' when calling createFulfillments(Async)");
        }
        return this.createFulfillmentsCall(fulfillmentCreateBulkRequest, fields, fulfillmentFields, fulfillmentItemFields, creditMemoItemFields, invoiceItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<FulfillmentCreateBulkResponse> createFulfillmentsWithHttpInfo(FulfillmentCreateBulkRequest fulfillmentCreateBulkRequest, List<String> fields, List<String> fulfillmentFields, List<String> fulfillmentItemFields, List<String> creditMemoItemFields, List<String> invoiceItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createFulfillmentsValidateBeforeCall(fulfillmentCreateBulkRequest, fields, fulfillmentFields, fulfillmentItemFields, creditMemoItemFields, invoiceItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<FulfillmentCreateBulkResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createFulfillmentsAsync(FulfillmentCreateBulkRequest fulfillmentCreateBulkRequest, List<String> fields, List<String> fulfillmentFields, List<String> fulfillmentItemFields, List<String> creditMemoItemFields, List<String> invoiceItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<FulfillmentCreateBulkResponse> _callback) throws ApiException {
        Call localVarCall = this.createFulfillmentsValidateBeforeCall(fulfillmentCreateBulkRequest, fields, fulfillmentFields, fulfillmentItemFields, creditMemoItemFields, invoiceItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<FulfillmentCreateBulkResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateFulfillmentsParams createFulfillmentsParams(FulfillmentCreateBulkRequest fulfillmentCreateBulkRequest) {
        return new CreateFulfillmentsParams(fulfillmentCreateBulkRequest);
    }

    public FulfillmentCreateBulkResponse createFulfillments(FulfillmentCreateBulkRequest fulfillmentCreateBulkRequest) throws ApiException {
        CreateFulfillmentsParams params = new CreateFulfillmentsParams(fulfillmentCreateBulkRequest);
        return this.executeCreateFulfillmentsAPICall(params).getData();
    }

    public FulfillmentCreateBulkResponse createFulfillments(FulfillmentCreateBulkRequest fulfillmentCreateBulkRequest, List<String> expand) throws ApiException {
        CreateFulfillmentsParams params = new CreateFulfillmentsParams(fulfillmentCreateBulkRequest);
        params.expand(expand);
        return this.executeCreateFulfillmentsAPICall(params).getData();
    }

    public FulfillmentCreateBulkResponse createFulfillments(FulfillmentCreateBulkRequest fulfillmentCreateBulkRequest, List<String> expand, Headers headers) throws ApiException {
        CreateFulfillmentsParams params = new CreateFulfillmentsParams(fulfillmentCreateBulkRequest).expand(expand).headers(headers);
        return this.executeCreateFulfillmentsAPICall(params).getData();
    }

    public FulfillmentCreateBulkResponse bulkCreate(CreateFulfillmentsParams params) throws ApiException {
        return this.executeCreateFulfillmentsAPICall(params).getData();
    }

    public ApiResponse<FulfillmentCreateBulkResponse> bulkCreateWithHttpInfo(CreateFulfillmentsParams params) throws ApiException {
        return this.executeCreateFulfillmentsAPICall(params);
    }

    ApiResponse<FulfillmentCreateBulkResponse> executeCreateFulfillmentsAPICall(CreateFulfillmentsParams params) throws ApiException {
        return this.createFulfillmentsWithHttpInfo(params.fulfillmentCreateBulkRequest, params.fields, params.fulfillmentFields, params.fulfillmentItemFields, params.creditMemoItemFields, params.invoiceItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call deleteFulfillmentCall(String fulfillmentId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/fulfillments/{fulfillment_id}".replace("{fulfillment_id}", this.localVarApiClient.escapeString(fulfillmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteFulfillmentValidateBeforeCall(String fulfillmentId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (fulfillmentId == null) {
            throw new ApiException("Missing the required parameter 'fulfillmentId' when calling deleteFulfillment(Async)");
        }
        return this.deleteFulfillmentCall(fulfillmentId, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Void> deleteFulfillmentWithHttpInfo(String fulfillmentId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deleteFulfillmentValidateBeforeCall(fulfillmentId, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteFulfillmentAsync(String fulfillmentId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteFulfillmentValidateBeforeCall(fulfillmentId, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public DeleteFulfillmentParams deleteFulfillmentParams(String fulfillmentId) {
        return new DeleteFulfillmentParams(fulfillmentId);
    }

    public void deleteFulfillment(String fulfillmentId) throws ApiException {
        DeleteFulfillmentParams params = new DeleteFulfillmentParams(fulfillmentId);
        this.executeDeleteFulfillmentAPICall(params);
    }

    public void deleteFulfillment(String fulfillmentId, Headers headers) throws ApiException {
        DeleteFulfillmentParams params = new DeleteFulfillmentParams(fulfillmentId).headers(headers);
        this.executeDeleteFulfillmentAPICall(params);
    }

    public void delete(DeleteFulfillmentParams params) throws ApiException {
        this.executeDeleteFulfillmentAPICall(params).getData();
    }

    public ApiResponse<Void> deleteWithHttpInfo(DeleteFulfillmentParams params) throws ApiException {
        return this.executeDeleteFulfillmentAPICall(params);
    }

    ApiResponse<Void> executeDeleteFulfillmentAPICall(DeleteFulfillmentParams params) throws ApiException {
        return this.deleteFulfillmentWithHttpInfo(params.fulfillmentId, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getFulfillmentCall(String fulfillmentId, List<String> fields, List<String> fulfillmentFields, List<String> fulfillmentItemFields, List<String> creditMemoItemFields, List<String> invoiceItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/fulfillments/{fulfillment_id}".replace("{fulfillment_id}", this.localVarApiClient.escapeString(fulfillmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (fulfillmentFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fulfillment.fields[]", fulfillmentFields));
        }
        if (fulfillmentItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fulfillment_item.fields[]", fulfillmentItemFields));
        }
        if (creditMemoItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo_item.fields[]", creditMemoItemFields));
        }
        if (invoiceItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_item.fields[]", invoiceItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFulfillmentValidateBeforeCall(String fulfillmentId, List<String> fields, List<String> fulfillmentFields, List<String> fulfillmentItemFields, List<String> creditMemoItemFields, List<String> invoiceItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (fulfillmentId == null) {
            throw new ApiException("Missing the required parameter 'fulfillmentId' when calling getFulfillment(Async)");
        }
        return this.getFulfillmentCall(fulfillmentId, fields, fulfillmentFields, fulfillmentItemFields, creditMemoItemFields, invoiceItemFields, expand, filter, pageSize, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Fulfillment> getFulfillmentWithHttpInfo(String fulfillmentId, List<String> fields, List<String> fulfillmentFields, List<String> fulfillmentItemFields, List<String> creditMemoItemFields, List<String> invoiceItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getFulfillmentValidateBeforeCall(fulfillmentId, fields, fulfillmentFields, fulfillmentItemFields, creditMemoItemFields, invoiceItemFields, expand, filter, pageSize, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Fulfillment>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getFulfillmentAsync(String fulfillmentId, List<String> fields, List<String> fulfillmentFields, List<String> fulfillmentItemFields, List<String> creditMemoItemFields, List<String> invoiceItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Fulfillment> _callback) throws ApiException {
        Call localVarCall = this.getFulfillmentValidateBeforeCall(fulfillmentId, fields, fulfillmentFields, fulfillmentItemFields, creditMemoItemFields, invoiceItemFields, expand, filter, pageSize, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Fulfillment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetFulfillmentParams getFulfillmentParams(String fulfillmentId) {
        return new GetFulfillmentParams(fulfillmentId);
    }

    public Fulfillment getFulfillment(String fulfillmentId) throws ApiException {
        GetFulfillmentParams params = new GetFulfillmentParams(fulfillmentId);
        return this.executeGetFulfillmentAPICall(params).getData();
    }

    public Fulfillment getFulfillment(String fulfillmentId, List<String> expand) throws ApiException {
        GetFulfillmentParams params = new GetFulfillmentParams(fulfillmentId);
        params.expand(expand);
        return this.executeGetFulfillmentAPICall(params).getData();
    }

    public Fulfillment getFulfillment(String fulfillmentId, List<String> expand, Headers headers) throws ApiException {
        GetFulfillmentParams params = new GetFulfillmentParams(fulfillmentId).expand(expand).headers(headers);
        return this.executeGetFulfillmentAPICall(params).getData();
    }

    public Fulfillment get(GetFulfillmentParams params) throws ApiException {
        return this.executeGetFulfillmentAPICall(params).getData();
    }

    public ApiResponse<Fulfillment> getWithHttpInfo(GetFulfillmentParams params) throws ApiException {
        return this.executeGetFulfillmentAPICall(params);
    }

    ApiResponse<Fulfillment> executeGetFulfillmentAPICall(GetFulfillmentParams params) throws ApiException {
        return this.getFulfillmentWithHttpInfo(params.fulfillmentId, params.fields, params.fulfillmentFields, params.fulfillmentItemFields, params.creditMemoItemFields, params.invoiceItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getFulfillmentsCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> fulfillmentFields, List<String> fulfillmentItemFields, List<String> creditMemoItemFields, List<String> invoiceItemFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/fulfillments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (fulfillmentFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fulfillment.fields[]", fulfillmentFields));
        }
        if (fulfillmentItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fulfillment_item.fields[]", fulfillmentItemFields));
        }
        if (creditMemoItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo_item.fields[]", creditMemoItemFields));
        }
        if (invoiceItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_item.fields[]", invoiceItemFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFulfillmentsValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> fulfillmentFields, List<String> fulfillmentItemFields, List<String> creditMemoItemFields, List<String> invoiceItemFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getFulfillmentsCall(cursor, expand, filter, sort, pageSize, fields, fulfillmentFields, fulfillmentItemFields, creditMemoItemFields, invoiceItemFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<FilfillmentListResponse> getFulfillmentsWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> fulfillmentFields, List<String> fulfillmentItemFields, List<String> creditMemoItemFields, List<String> invoiceItemFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getFulfillmentsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, fulfillmentFields, fulfillmentItemFields, creditMemoItemFields, invoiceItemFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<FilfillmentListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getFulfillmentsAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> fulfillmentFields, List<String> fulfillmentItemFields, List<String> creditMemoItemFields, List<String> invoiceItemFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<FilfillmentListResponse> _callback) throws ApiException {
        Call localVarCall = this.getFulfillmentsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, fulfillmentFields, fulfillmentItemFields, creditMemoItemFields, invoiceItemFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<FilfillmentListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetFulfillmentsParams getFulfillmentsParams() {
        return new GetFulfillmentsParams();
    }

    public FilfillmentListResponse getFulfillments() throws ApiException {
        GetFulfillmentsParams params = new GetFulfillmentsParams();
        return this.executeGetFulfillmentsAPICall(params).getData();
    }

    public FilfillmentListResponse getFulfillments(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetFulfillmentsParams params = new GetFulfillmentsParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetFulfillmentsAPICall(params).getData();
    }

    public FilfillmentListResponse getFulfillments(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetFulfillmentsParams params = new GetFulfillmentsParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetFulfillmentsAPICall(params).getData();
    }

    public FilfillmentListResponse list(GetFulfillmentsParams params) throws ApiException {
        return this.executeGetFulfillmentsAPICall(params).getData();
    }

    public ApiResponse<FilfillmentListResponse> listWithHttpInfo(GetFulfillmentsParams params) throws ApiException {
        return this.executeGetFulfillmentsAPICall(params);
    }

    ApiResponse<FilfillmentListResponse> executeGetFulfillmentsAPICall(GetFulfillmentsParams params) throws ApiException {
        return this.getFulfillmentsWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.fulfillmentFields, params.fulfillmentItemFields, params.creditMemoItemFields, params.invoiceItemFields, params.zuoraTrackId, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call updateFulfillmentCall(String fulfillmentId, FulfillmentPatchRequest fulfillmentPatchRequest, List<String> fields, List<String> fulfillmentFields, List<String> fulfillmentItemFields, List<String> creditMemoItemFields, List<String> invoiceItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FulfillmentPatchRequest localVarPostBody = fulfillmentPatchRequest;
        String localVarPath = "/fulfillments/{fulfillment_id}".replace("{fulfillment_id}", this.localVarApiClient.escapeString(fulfillmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (fulfillmentFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fulfillment.fields[]", fulfillmentFields));
        }
        if (fulfillmentItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fulfillment_item.fields[]", fulfillmentItemFields));
        }
        if (creditMemoItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo_item.fields[]", creditMemoItemFields));
        }
        if (invoiceItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_item.fields[]", invoiceItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateFulfillmentValidateBeforeCall(String fulfillmentId, FulfillmentPatchRequest fulfillmentPatchRequest, List<String> fields, List<String> fulfillmentFields, List<String> fulfillmentItemFields, List<String> creditMemoItemFields, List<String> invoiceItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (fulfillmentId == null) {
            throw new ApiException("Missing the required parameter 'fulfillmentId' when calling updateFulfillment(Async)");
        }
        if (fulfillmentPatchRequest == null) {
            throw new ApiException("Missing the required parameter 'fulfillmentPatchRequest' when calling updateFulfillment(Async)");
        }
        return this.updateFulfillmentCall(fulfillmentId, fulfillmentPatchRequest, fields, fulfillmentFields, fulfillmentItemFields, creditMemoItemFields, invoiceItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Fulfillment> updateFulfillmentWithHttpInfo(String fulfillmentId, FulfillmentPatchRequest fulfillmentPatchRequest, List<String> fields, List<String> fulfillmentFields, List<String> fulfillmentItemFields, List<String> creditMemoItemFields, List<String> invoiceItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updateFulfillmentValidateBeforeCall(fulfillmentId, fulfillmentPatchRequest, fields, fulfillmentFields, fulfillmentItemFields, creditMemoItemFields, invoiceItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Fulfillment>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updateFulfillmentAsync(String fulfillmentId, FulfillmentPatchRequest fulfillmentPatchRequest, List<String> fields, List<String> fulfillmentFields, List<String> fulfillmentItemFields, List<String> creditMemoItemFields, List<String> invoiceItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Fulfillment> _callback) throws ApiException {
        Call localVarCall = this.updateFulfillmentValidateBeforeCall(fulfillmentId, fulfillmentPatchRequest, fields, fulfillmentFields, fulfillmentItemFields, creditMemoItemFields, invoiceItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Fulfillment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateFulfillmentParams updateFulfillmentParams(String fulfillmentId, FulfillmentPatchRequest fulfillmentPatchRequest) {
        return new UpdateFulfillmentParams(fulfillmentId, fulfillmentPatchRequest);
    }

    public Fulfillment updateFulfillment(String fulfillmentId, FulfillmentPatchRequest fulfillmentPatchRequest) throws ApiException {
        UpdateFulfillmentParams params = new UpdateFulfillmentParams(fulfillmentId, fulfillmentPatchRequest);
        return this.executeUpdateFulfillmentAPICall(params).getData();
    }

    public Fulfillment updateFulfillment(String fulfillmentId, FulfillmentPatchRequest fulfillmentPatchRequest, List<String> expand) throws ApiException {
        UpdateFulfillmentParams params = new UpdateFulfillmentParams(fulfillmentId, fulfillmentPatchRequest);
        params.expand(expand);
        return this.executeUpdateFulfillmentAPICall(params).getData();
    }

    public Fulfillment updateFulfillment(String fulfillmentId, FulfillmentPatchRequest fulfillmentPatchRequest, List<String> expand, Headers headers) throws ApiException {
        UpdateFulfillmentParams params = new UpdateFulfillmentParams(fulfillmentId, fulfillmentPatchRequest).expand(expand).headers(headers);
        return this.executeUpdateFulfillmentAPICall(params).getData();
    }

    public Fulfillment update(UpdateFulfillmentParams params) throws ApiException {
        return this.executeUpdateFulfillmentAPICall(params).getData();
    }

    public ApiResponse<Fulfillment> updateWithHttpInfo(UpdateFulfillmentParams params) throws ApiException {
        return this.executeUpdateFulfillmentAPICall(params);
    }

    ApiResponse<Fulfillment> executeUpdateFulfillmentAPICall(UpdateFulfillmentParams params) throws ApiException {
        return this.updateFulfillmentWithHttpInfo(params.fulfillmentId, params.fulfillmentPatchRequest, params.fields, params.fulfillmentFields, params.fulfillmentItemFields, params.creditMemoItemFields, params.invoiceItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    public static class UpdateFulfillmentParams {
        private final String fulfillmentId;
        private final FulfillmentPatchRequest fulfillmentPatchRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> fulfillmentFields;
        private List<String> fulfillmentItemFields;
        private List<String> creditMemoItemFields;
        private List<String> invoiceItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public UpdateFulfillmentParams(String fulfillmentId, FulfillmentPatchRequest fulfillmentPatchRequest) {
            this.fulfillmentId = fulfillmentId;
            this.fulfillmentPatchRequest = fulfillmentPatchRequest;
        }

        public UpdateFulfillmentParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public UpdateFulfillmentParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public UpdateFulfillmentParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public UpdateFulfillmentParams fulfillmentFields(List<String> fulfillmentFields) {
            this.fulfillmentFields = fulfillmentFields;
            return this;
        }

        public UpdateFulfillmentParams fulfillmentItemFields(List<String> fulfillmentItemFields) {
            this.fulfillmentItemFields = fulfillmentItemFields;
            return this;
        }

        public UpdateFulfillmentParams creditMemoItemFields(List<String> creditMemoItemFields) {
            this.creditMemoItemFields = creditMemoItemFields;
            return this;
        }

        public UpdateFulfillmentParams invoiceItemFields(List<String> invoiceItemFields) {
            this.invoiceItemFields = invoiceItemFields;
            return this;
        }

        public UpdateFulfillmentParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public UpdateFulfillmentParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public UpdateFulfillmentParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class GetFulfillmentsParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> fulfillmentFields;
        private List<String> fulfillmentItemFields;
        private List<String> creditMemoItemFields;
        private List<String> invoiceItemFields;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetFulfillmentsParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetFulfillmentsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetFulfillmentsParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetFulfillmentsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetFulfillmentsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetFulfillmentsParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetFulfillmentsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetFulfillmentsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetFulfillmentsParams fulfillmentFields(List<String> fulfillmentFields) {
            this.fulfillmentFields = fulfillmentFields;
            return this;
        }

        public GetFulfillmentsParams fulfillmentItemFields(List<String> fulfillmentItemFields) {
            this.fulfillmentItemFields = fulfillmentItemFields;
            return this;
        }

        public GetFulfillmentsParams creditMemoItemFields(List<String> creditMemoItemFields) {
            this.creditMemoItemFields = creditMemoItemFields;
            return this;
        }

        public GetFulfillmentsParams invoiceItemFields(List<String> invoiceItemFields) {
            this.invoiceItemFields = invoiceItemFields;
            return this;
        }
    }

    public static class GetFulfillmentParams {
        private final String fulfillmentId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> fulfillmentFields;
        private List<String> fulfillmentItemFields;
        private List<String> creditMemoItemFields;
        private List<String> invoiceItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetFulfillmentParams(String fulfillmentId) {
            this.fulfillmentId = fulfillmentId;
        }

        public GetFulfillmentParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetFulfillmentParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetFulfillmentParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetFulfillmentParams fulfillmentFields(List<String> fulfillmentFields) {
            this.fulfillmentFields = fulfillmentFields;
            return this;
        }

        public GetFulfillmentParams fulfillmentItemFields(List<String> fulfillmentItemFields) {
            this.fulfillmentItemFields = fulfillmentItemFields;
            return this;
        }

        public GetFulfillmentParams creditMemoItemFields(List<String> creditMemoItemFields) {
            this.creditMemoItemFields = creditMemoItemFields;
            return this;
        }

        public GetFulfillmentParams invoiceItemFields(List<String> invoiceItemFields) {
            this.invoiceItemFields = invoiceItemFields;
            return this;
        }

        public GetFulfillmentParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetFulfillmentParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetFulfillmentParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class DeleteFulfillmentParams {
        private final String fulfillmentId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public DeleteFulfillmentParams(String fulfillmentId) {
            this.fulfillmentId = fulfillmentId;
        }

        public DeleteFulfillmentParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class CreateFulfillmentsParams {
        private final FulfillmentCreateBulkRequest fulfillmentCreateBulkRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> fulfillmentFields;
        private List<String> fulfillmentItemFields;
        private List<String> creditMemoItemFields;
        private List<String> invoiceItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CreateFulfillmentsParams(FulfillmentCreateBulkRequest fulfillmentCreateBulkRequest) {
            this.fulfillmentCreateBulkRequest = fulfillmentCreateBulkRequest;
        }

        public CreateFulfillmentsParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CreateFulfillmentsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreateFulfillmentsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreateFulfillmentsParams fulfillmentFields(List<String> fulfillmentFields) {
            this.fulfillmentFields = fulfillmentFields;
            return this;
        }

        public CreateFulfillmentsParams fulfillmentItemFields(List<String> fulfillmentItemFields) {
            this.fulfillmentItemFields = fulfillmentItemFields;
            return this;
        }

        public CreateFulfillmentsParams creditMemoItemFields(List<String> creditMemoItemFields) {
            this.creditMemoItemFields = creditMemoItemFields;
            return this;
        }

        public CreateFulfillmentsParams invoiceItemFields(List<String> invoiceItemFields) {
            this.invoiceItemFields = invoiceItemFields;
            return this;
        }

        public CreateFulfillmentsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CreateFulfillmentsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreateFulfillmentsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class CreateFulfillmentParams {
        private final FulfillmentCreateRequest fulfillmentCreateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> fulfillmentFields;
        private List<String> fulfillmentItemFields;
        private List<String> creditMemoItemFields;
        private List<String> invoiceItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CreateFulfillmentParams(FulfillmentCreateRequest fulfillmentCreateRequest) {
            this.fulfillmentCreateRequest = fulfillmentCreateRequest;
        }

        public CreateFulfillmentParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CreateFulfillmentParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreateFulfillmentParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreateFulfillmentParams fulfillmentFields(List<String> fulfillmentFields) {
            this.fulfillmentFields = fulfillmentFields;
            return this;
        }

        public CreateFulfillmentParams fulfillmentItemFields(List<String> fulfillmentItemFields) {
            this.fulfillmentItemFields = fulfillmentItemFields;
            return this;
        }

        public CreateFulfillmentParams creditMemoItemFields(List<String> creditMemoItemFields) {
            this.creditMemoItemFields = creditMemoItemFields;
            return this;
        }

        public CreateFulfillmentParams invoiceItemFields(List<String> invoiceItemFields) {
            this.invoiceItemFields = invoiceItemFields;
            return this;
        }

        public CreateFulfillmentParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CreateFulfillmentParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreateFulfillmentParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

