/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.FilfillmentItemListResponse;
import org.openapitools.client.model.FulfillmentItem;
import org.openapitools.client.model.FulfillmentItemCreateBulkRequest;
import org.openapitools.client.model.FulfillmentItemCreateBulkResponse;
import org.openapitools.client.model.FulfillmentItemCreateRequest;
import org.openapitools.client.model.FulfillmentItemPatchRequest;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.ListQueryParams;

public class FulfillmentItemsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public FulfillmentItemsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FulfillmentItemsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createFulfillmentItemCall(FulfillmentItemCreateRequest fulfillmentItemCreateRequest, List<String> fields, List<String> fulfillmentItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FulfillmentItemCreateRequest localVarPostBody = fulfillmentItemCreateRequest;
        String localVarPath = "/fulfillments_items";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (fulfillmentItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fulfillment_item.fields[]", fulfillmentItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createFulfillmentItemValidateBeforeCall(FulfillmentItemCreateRequest fulfillmentItemCreateRequest, List<String> fields, List<String> fulfillmentItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (fulfillmentItemCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'fulfillmentItemCreateRequest' when calling createFulfillmentItem(Async)");
        }
        return this.createFulfillmentItemCall(fulfillmentItemCreateRequest, fields, fulfillmentItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<FulfillmentItem> createFulfillmentItemWithHttpInfo(FulfillmentItemCreateRequest fulfillmentItemCreateRequest, List<String> fields, List<String> fulfillmentItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createFulfillmentItemValidateBeforeCall(fulfillmentItemCreateRequest, fields, fulfillmentItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<FulfillmentItem>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createFulfillmentItemAsync(FulfillmentItemCreateRequest fulfillmentItemCreateRequest, List<String> fields, List<String> fulfillmentItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<FulfillmentItem> _callback) throws ApiException {
        Call localVarCall = this.createFulfillmentItemValidateBeforeCall(fulfillmentItemCreateRequest, fields, fulfillmentItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<FulfillmentItem>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateFulfillmentItemParams createFulfillmentItemParams(FulfillmentItemCreateRequest fulfillmentItemCreateRequest) {
        return new CreateFulfillmentItemParams(fulfillmentItemCreateRequest);
    }

    public FulfillmentItem createFulfillmentItem(FulfillmentItemCreateRequest fulfillmentItemCreateRequest) throws ApiException {
        CreateFulfillmentItemParams params = new CreateFulfillmentItemParams(fulfillmentItemCreateRequest);
        return this.executeCreateFulfillmentItemAPICall(params).getData();
    }

    public FulfillmentItem createFulfillmentItem(FulfillmentItemCreateRequest fulfillmentItemCreateRequest, List<String> expand) throws ApiException {
        CreateFulfillmentItemParams params = new CreateFulfillmentItemParams(fulfillmentItemCreateRequest);
        params.expand(expand);
        return this.executeCreateFulfillmentItemAPICall(params).getData();
    }

    public FulfillmentItem createFulfillmentItem(FulfillmentItemCreateRequest fulfillmentItemCreateRequest, List<String> expand, Headers headers) throws ApiException {
        CreateFulfillmentItemParams params = new CreateFulfillmentItemParams(fulfillmentItemCreateRequest).expand(expand).headers(headers);
        return this.executeCreateFulfillmentItemAPICall(params).getData();
    }

    public FulfillmentItem create(CreateFulfillmentItemParams params) throws ApiException {
        return this.executeCreateFulfillmentItemAPICall(params).getData();
    }

    public ApiResponse<FulfillmentItem> createWithHttpInfo(CreateFulfillmentItemParams params) throws ApiException {
        return this.executeCreateFulfillmentItemAPICall(params);
    }

    ApiResponse<FulfillmentItem> executeCreateFulfillmentItemAPICall(CreateFulfillmentItemParams params) throws ApiException {
        return this.createFulfillmentItemWithHttpInfo(params.fulfillmentItemCreateRequest, params.fields, params.fulfillmentItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call createFulfillmentItemsCall(FulfillmentItemCreateBulkRequest fulfillmentItemCreateBulkRequest, List<String> fields, List<String> fulfillmentItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FulfillmentItemCreateBulkRequest localVarPostBody = fulfillmentItemCreateBulkRequest;
        String localVarPath = "/fulfillments_items/bulk_create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (fulfillmentItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fulfillment_item.fields[]", fulfillmentItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createFulfillmentItemsValidateBeforeCall(FulfillmentItemCreateBulkRequest fulfillmentItemCreateBulkRequest, List<String> fields, List<String> fulfillmentItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (fulfillmentItemCreateBulkRequest == null) {
            throw new ApiException("Missing the required parameter 'fulfillmentItemCreateBulkRequest' when calling createFulfillmentItems(Async)");
        }
        return this.createFulfillmentItemsCall(fulfillmentItemCreateBulkRequest, fields, fulfillmentItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<FulfillmentItemCreateBulkResponse> createFulfillmentItemsWithHttpInfo(FulfillmentItemCreateBulkRequest fulfillmentItemCreateBulkRequest, List<String> fields, List<String> fulfillmentItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createFulfillmentItemsValidateBeforeCall(fulfillmentItemCreateBulkRequest, fields, fulfillmentItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<FulfillmentItemCreateBulkResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createFulfillmentItemsAsync(FulfillmentItemCreateBulkRequest fulfillmentItemCreateBulkRequest, List<String> fields, List<String> fulfillmentItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<FulfillmentItemCreateBulkResponse> _callback) throws ApiException {
        Call localVarCall = this.createFulfillmentItemsValidateBeforeCall(fulfillmentItemCreateBulkRequest, fields, fulfillmentItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<FulfillmentItemCreateBulkResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateFulfillmentItemsParams createFulfillmentItemsParams(FulfillmentItemCreateBulkRequest fulfillmentItemCreateBulkRequest) {
        return new CreateFulfillmentItemsParams(fulfillmentItemCreateBulkRequest);
    }

    public FulfillmentItemCreateBulkResponse createFulfillmentItems(FulfillmentItemCreateBulkRequest fulfillmentItemCreateBulkRequest) throws ApiException {
        CreateFulfillmentItemsParams params = new CreateFulfillmentItemsParams(fulfillmentItemCreateBulkRequest);
        return this.executeCreateFulfillmentItemsAPICall(params).getData();
    }

    public FulfillmentItemCreateBulkResponse createFulfillmentItems(FulfillmentItemCreateBulkRequest fulfillmentItemCreateBulkRequest, List<String> expand) throws ApiException {
        CreateFulfillmentItemsParams params = new CreateFulfillmentItemsParams(fulfillmentItemCreateBulkRequest);
        params.expand(expand);
        return this.executeCreateFulfillmentItemsAPICall(params).getData();
    }

    public FulfillmentItemCreateBulkResponse createFulfillmentItems(FulfillmentItemCreateBulkRequest fulfillmentItemCreateBulkRequest, List<String> expand, Headers headers) throws ApiException {
        CreateFulfillmentItemsParams params = new CreateFulfillmentItemsParams(fulfillmentItemCreateBulkRequest).expand(expand).headers(headers);
        return this.executeCreateFulfillmentItemsAPICall(params).getData();
    }

    public FulfillmentItemCreateBulkResponse bulkCreate(CreateFulfillmentItemsParams params) throws ApiException {
        return this.executeCreateFulfillmentItemsAPICall(params).getData();
    }

    public ApiResponse<FulfillmentItemCreateBulkResponse> bulkCreateWithHttpInfo(CreateFulfillmentItemsParams params) throws ApiException {
        return this.executeCreateFulfillmentItemsAPICall(params);
    }

    ApiResponse<FulfillmentItemCreateBulkResponse> executeCreateFulfillmentItemsAPICall(CreateFulfillmentItemsParams params) throws ApiException {
        return this.createFulfillmentItemsWithHttpInfo(params.fulfillmentItemCreateBulkRequest, params.fields, params.fulfillmentItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call deleteFulfillmentItemCall(String fulfillmentItemId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/fulfillments_items/{fulfillment_item_id}".replace("{fulfillment_item_id}", this.localVarApiClient.escapeString(fulfillmentItemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteFulfillmentItemValidateBeforeCall(String fulfillmentItemId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (fulfillmentItemId == null) {
            throw new ApiException("Missing the required parameter 'fulfillmentItemId' when calling deleteFulfillmentItem(Async)");
        }
        return this.deleteFulfillmentItemCall(fulfillmentItemId, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Void> deleteFulfillmentItemWithHttpInfo(String fulfillmentItemId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deleteFulfillmentItemValidateBeforeCall(fulfillmentItemId, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteFulfillmentItemAsync(String fulfillmentItemId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteFulfillmentItemValidateBeforeCall(fulfillmentItemId, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public DeleteFulfillmentItemParams deleteFulfillmentItemParams(String fulfillmentItemId) {
        return new DeleteFulfillmentItemParams(fulfillmentItemId);
    }

    public void deleteFulfillmentItem(String fulfillmentItemId) throws ApiException {
        DeleteFulfillmentItemParams params = new DeleteFulfillmentItemParams(fulfillmentItemId);
        this.executeDeleteFulfillmentItemAPICall(params);
    }

    public void deleteFulfillmentItem(String fulfillmentItemId, Headers headers) throws ApiException {
        DeleteFulfillmentItemParams params = new DeleteFulfillmentItemParams(fulfillmentItemId).headers(headers);
        this.executeDeleteFulfillmentItemAPICall(params);
    }

    public void delete(DeleteFulfillmentItemParams params) throws ApiException {
        this.executeDeleteFulfillmentItemAPICall(params).getData();
    }

    public ApiResponse<Void> deleteWithHttpInfo(DeleteFulfillmentItemParams params) throws ApiException {
        return this.executeDeleteFulfillmentItemAPICall(params);
    }

    ApiResponse<Void> executeDeleteFulfillmentItemAPICall(DeleteFulfillmentItemParams params) throws ApiException {
        return this.deleteFulfillmentItemWithHttpInfo(params.fulfillmentItemId, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getFulfillmentItemCall(String fulfillmentItemId, List<String> fields, List<String> fulfillmentItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/fulfillments_items/{fulfillment_item_id}".replace("{fulfillment_item_id}", this.localVarApiClient.escapeString(fulfillmentItemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (fulfillmentItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fulfillment_item.fields[]", fulfillmentItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFulfillmentItemValidateBeforeCall(String fulfillmentItemId, List<String> fields, List<String> fulfillmentItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (fulfillmentItemId == null) {
            throw new ApiException("Missing the required parameter 'fulfillmentItemId' when calling getFulfillmentItem(Async)");
        }
        return this.getFulfillmentItemCall(fulfillmentItemId, fields, fulfillmentItemFields, expand, filter, pageSize, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<FulfillmentItem> getFulfillmentItemWithHttpInfo(String fulfillmentItemId, List<String> fields, List<String> fulfillmentItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getFulfillmentItemValidateBeforeCall(fulfillmentItemId, fields, fulfillmentItemFields, expand, filter, pageSize, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<FulfillmentItem>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getFulfillmentItemAsync(String fulfillmentItemId, List<String> fields, List<String> fulfillmentItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<FulfillmentItem> _callback) throws ApiException {
        Call localVarCall = this.getFulfillmentItemValidateBeforeCall(fulfillmentItemId, fields, fulfillmentItemFields, expand, filter, pageSize, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<FulfillmentItem>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetFulfillmentItemParams getFulfillmentItemParams(String fulfillmentItemId) {
        return new GetFulfillmentItemParams(fulfillmentItemId);
    }

    public FulfillmentItem getFulfillmentItem(String fulfillmentItemId) throws ApiException {
        GetFulfillmentItemParams params = new GetFulfillmentItemParams(fulfillmentItemId);
        return this.executeGetFulfillmentItemAPICall(params).getData();
    }

    public FulfillmentItem getFulfillmentItem(String fulfillmentItemId, List<String> expand) throws ApiException {
        GetFulfillmentItemParams params = new GetFulfillmentItemParams(fulfillmentItemId);
        params.expand(expand);
        return this.executeGetFulfillmentItemAPICall(params).getData();
    }

    public FulfillmentItem getFulfillmentItem(String fulfillmentItemId, List<String> expand, Headers headers) throws ApiException {
        GetFulfillmentItemParams params = new GetFulfillmentItemParams(fulfillmentItemId).expand(expand).headers(headers);
        return this.executeGetFulfillmentItemAPICall(params).getData();
    }

    public FulfillmentItem get(GetFulfillmentItemParams params) throws ApiException {
        return this.executeGetFulfillmentItemAPICall(params).getData();
    }

    public ApiResponse<FulfillmentItem> getWithHttpInfo(GetFulfillmentItemParams params) throws ApiException {
        return this.executeGetFulfillmentItemAPICall(params);
    }

    ApiResponse<FulfillmentItem> executeGetFulfillmentItemAPICall(GetFulfillmentItemParams params) throws ApiException {
        return this.getFulfillmentItemWithHttpInfo(params.fulfillmentItemId, params.fields, params.fulfillmentItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getFulfillmentItemsCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> fulfillmentItemFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/fulfillments_items";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (fulfillmentItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fulfillment_item.fields[]", fulfillmentItemFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFulfillmentItemsValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> fulfillmentItemFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getFulfillmentItemsCall(cursor, expand, filter, sort, pageSize, fields, fulfillmentItemFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<FilfillmentItemListResponse> getFulfillmentItemsWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> fulfillmentItemFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getFulfillmentItemsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, fulfillmentItemFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<FilfillmentItemListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getFulfillmentItemsAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> fulfillmentItemFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<FilfillmentItemListResponse> _callback) throws ApiException {
        Call localVarCall = this.getFulfillmentItemsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, fulfillmentItemFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<FilfillmentItemListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetFulfillmentItemsParams getFulfillmentItemsParams() {
        return new GetFulfillmentItemsParams();
    }

    public FilfillmentItemListResponse getFulfillmentItems() throws ApiException {
        GetFulfillmentItemsParams params = new GetFulfillmentItemsParams();
        return this.executeGetFulfillmentItemsAPICall(params).getData();
    }

    public FilfillmentItemListResponse getFulfillmentItems(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetFulfillmentItemsParams params = new GetFulfillmentItemsParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetFulfillmentItemsAPICall(params).getData();
    }

    public FilfillmentItemListResponse getFulfillmentItems(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetFulfillmentItemsParams params = new GetFulfillmentItemsParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetFulfillmentItemsAPICall(params).getData();
    }

    public FilfillmentItemListResponse list(GetFulfillmentItemsParams params) throws ApiException {
        return this.executeGetFulfillmentItemsAPICall(params).getData();
    }

    public ApiResponse<FilfillmentItemListResponse> listWithHttpInfo(GetFulfillmentItemsParams params) throws ApiException {
        return this.executeGetFulfillmentItemsAPICall(params);
    }

    ApiResponse<FilfillmentItemListResponse> executeGetFulfillmentItemsAPICall(GetFulfillmentItemsParams params) throws ApiException {
        return this.getFulfillmentItemsWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.fulfillmentItemFields, params.zuoraTrackId, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call updateFulfillmentItemCall(String fulfillmentItemId, FulfillmentItemPatchRequest fulfillmentItemPatchRequest, List<String> fields, List<String> fulfillmentItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FulfillmentItemPatchRequest localVarPostBody = fulfillmentItemPatchRequest;
        String localVarPath = "/fulfillments_items/{fulfillment_item_id}".replace("{fulfillment_item_id}", this.localVarApiClient.escapeString(fulfillmentItemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (fulfillmentItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fulfillment_item.fields[]", fulfillmentItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateFulfillmentItemValidateBeforeCall(String fulfillmentItemId, FulfillmentItemPatchRequest fulfillmentItemPatchRequest, List<String> fields, List<String> fulfillmentItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (fulfillmentItemId == null) {
            throw new ApiException("Missing the required parameter 'fulfillmentItemId' when calling updateFulfillmentItem(Async)");
        }
        if (fulfillmentItemPatchRequest == null) {
            throw new ApiException("Missing the required parameter 'fulfillmentItemPatchRequest' when calling updateFulfillmentItem(Async)");
        }
        return this.updateFulfillmentItemCall(fulfillmentItemId, fulfillmentItemPatchRequest, fields, fulfillmentItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<FulfillmentItem> updateFulfillmentItemWithHttpInfo(String fulfillmentItemId, FulfillmentItemPatchRequest fulfillmentItemPatchRequest, List<String> fields, List<String> fulfillmentItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updateFulfillmentItemValidateBeforeCall(fulfillmentItemId, fulfillmentItemPatchRequest, fields, fulfillmentItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<FulfillmentItem>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updateFulfillmentItemAsync(String fulfillmentItemId, FulfillmentItemPatchRequest fulfillmentItemPatchRequest, List<String> fields, List<String> fulfillmentItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<FulfillmentItem> _callback) throws ApiException {
        Call localVarCall = this.updateFulfillmentItemValidateBeforeCall(fulfillmentItemId, fulfillmentItemPatchRequest, fields, fulfillmentItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<FulfillmentItem>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateFulfillmentItemParams updateFulfillmentItemParams(String fulfillmentItemId, FulfillmentItemPatchRequest fulfillmentItemPatchRequest) {
        return new UpdateFulfillmentItemParams(fulfillmentItemId, fulfillmentItemPatchRequest);
    }

    public FulfillmentItem updateFulfillmentItem(String fulfillmentItemId, FulfillmentItemPatchRequest fulfillmentItemPatchRequest) throws ApiException {
        UpdateFulfillmentItemParams params = new UpdateFulfillmentItemParams(fulfillmentItemId, fulfillmentItemPatchRequest);
        return this.executeUpdateFulfillmentItemAPICall(params).getData();
    }

    public FulfillmentItem updateFulfillmentItem(String fulfillmentItemId, FulfillmentItemPatchRequest fulfillmentItemPatchRequest, List<String> expand) throws ApiException {
        UpdateFulfillmentItemParams params = new UpdateFulfillmentItemParams(fulfillmentItemId, fulfillmentItemPatchRequest);
        params.expand(expand);
        return this.executeUpdateFulfillmentItemAPICall(params).getData();
    }

    public FulfillmentItem updateFulfillmentItem(String fulfillmentItemId, FulfillmentItemPatchRequest fulfillmentItemPatchRequest, List<String> expand, Headers headers) throws ApiException {
        UpdateFulfillmentItemParams params = new UpdateFulfillmentItemParams(fulfillmentItemId, fulfillmentItemPatchRequest).expand(expand).headers(headers);
        return this.executeUpdateFulfillmentItemAPICall(params).getData();
    }

    public FulfillmentItem update(UpdateFulfillmentItemParams params) throws ApiException {
        return this.executeUpdateFulfillmentItemAPICall(params).getData();
    }

    public ApiResponse<FulfillmentItem> updateWithHttpInfo(UpdateFulfillmentItemParams params) throws ApiException {
        return this.executeUpdateFulfillmentItemAPICall(params);
    }

    ApiResponse<FulfillmentItem> executeUpdateFulfillmentItemAPICall(UpdateFulfillmentItemParams params) throws ApiException {
        return this.updateFulfillmentItemWithHttpInfo(params.fulfillmentItemId, params.fulfillmentItemPatchRequest, params.fields, params.fulfillmentItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    public static class UpdateFulfillmentItemParams {
        private final String fulfillmentItemId;
        private final FulfillmentItemPatchRequest fulfillmentItemPatchRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> fulfillmentItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public UpdateFulfillmentItemParams(String fulfillmentItemId, FulfillmentItemPatchRequest fulfillmentItemPatchRequest) {
            this.fulfillmentItemId = fulfillmentItemId;
            this.fulfillmentItemPatchRequest = fulfillmentItemPatchRequest;
        }

        public UpdateFulfillmentItemParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public UpdateFulfillmentItemParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public UpdateFulfillmentItemParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public UpdateFulfillmentItemParams fulfillmentItemFields(List<String> fulfillmentItemFields) {
            this.fulfillmentItemFields = fulfillmentItemFields;
            return this;
        }

        public UpdateFulfillmentItemParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public UpdateFulfillmentItemParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public UpdateFulfillmentItemParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class GetFulfillmentItemsParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> fulfillmentItemFields;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetFulfillmentItemsParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetFulfillmentItemsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetFulfillmentItemsParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetFulfillmentItemsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetFulfillmentItemsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetFulfillmentItemsParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetFulfillmentItemsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetFulfillmentItemsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetFulfillmentItemsParams fulfillmentItemFields(List<String> fulfillmentItemFields) {
            this.fulfillmentItemFields = fulfillmentItemFields;
            return this;
        }
    }

    public static class GetFulfillmentItemParams {
        private final String fulfillmentItemId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> fulfillmentItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetFulfillmentItemParams(String fulfillmentItemId) {
            this.fulfillmentItemId = fulfillmentItemId;
        }

        public GetFulfillmentItemParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetFulfillmentItemParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetFulfillmentItemParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetFulfillmentItemParams fulfillmentItemFields(List<String> fulfillmentItemFields) {
            this.fulfillmentItemFields = fulfillmentItemFields;
            return this;
        }

        public GetFulfillmentItemParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetFulfillmentItemParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetFulfillmentItemParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class DeleteFulfillmentItemParams {
        private final String fulfillmentItemId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public DeleteFulfillmentItemParams(String fulfillmentItemId) {
            this.fulfillmentItemId = fulfillmentItemId;
        }

        public DeleteFulfillmentItemParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class CreateFulfillmentItemsParams {
        private final FulfillmentItemCreateBulkRequest fulfillmentItemCreateBulkRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> fulfillmentItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CreateFulfillmentItemsParams(FulfillmentItemCreateBulkRequest fulfillmentItemCreateBulkRequest) {
            this.fulfillmentItemCreateBulkRequest = fulfillmentItemCreateBulkRequest;
        }

        public CreateFulfillmentItemsParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CreateFulfillmentItemsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreateFulfillmentItemsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreateFulfillmentItemsParams fulfillmentItemFields(List<String> fulfillmentItemFields) {
            this.fulfillmentItemFields = fulfillmentItemFields;
            return this;
        }

        public CreateFulfillmentItemsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CreateFulfillmentItemsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreateFulfillmentItemsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class CreateFulfillmentItemParams {
        private final FulfillmentItemCreateRequest fulfillmentItemCreateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> fulfillmentItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CreateFulfillmentItemParams(FulfillmentItemCreateRequest fulfillmentItemCreateRequest) {
            this.fulfillmentItemCreateRequest = fulfillmentItemCreateRequest;
        }

        public CreateFulfillmentItemParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CreateFulfillmentItemParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreateFulfillmentItemParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreateFulfillmentItemParams fulfillmentItemFields(List<String> fulfillmentItemFields) {
            this.fulfillmentItemFields = fulfillmentItemFields;
            return this;
        }

        public CreateFulfillmentItemParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CreateFulfillmentItemParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreateFulfillmentItemParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

