/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.LineItemCreateRequest;
import org.openapitools.client.model.PostSubscriptionOrderRequest;
import org.openapitools.client.model.SubscriptionPreviewAccountRequest;
import org.threeten.bp.LocalDate;

public class OrderPreviewCreateRequest {
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private CategoryEnum category;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ORDER_DATE = "order_date";
    @SerializedName(value="order_date")
    private LocalDate orderDate;
    public static final String SERIALIZED_NAME_ORDER_NUMBER = "order_number";
    @SerializedName(value="order_number")
    private String orderNumber;
    public static final String SERIALIZED_NAME_LINE_ITEMS = "line_items";
    @SerializedName(value="line_items")
    private List<LineItemCreateRequest> lineItems = null;
    public static final String SERIALIZED_NAME_SUBSCRIPTIONS = "subscriptions";
    @SerializedName(value="subscriptions")
    private List<PostSubscriptionOrderRequest> subscriptions = null;
    public static final String SERIALIZED_NAME_ACCOUNT_DATA = "account_data";
    @SerializedName(value="account_data")
    private SubscriptionPreviewAccountRequest accountData;
    public static final String SERIALIZED_NAME_NUMBER_OF_PERIODS = "number_of_periods";
    @SerializedName(value="number_of_periods")
    private Integer numberOfPeriods;
    public static final String SERIALIZED_NAME_TERM_END = "term_end";
    @SerializedName(value="term_end")
    private Boolean termEnd;
    public static final String SERIALIZED_NAME_METRICS = "metrics";
    @SerializedName(value="metrics")
    private List<MetricsEnum> metrics = new ArrayList<MetricsEnum>();
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;

    public OrderPreviewCreateRequest category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Category of the order to indicate a product sale or return. Default value is `sale`.")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public OrderPreviewCreateRequest customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public OrderPreviewCreateRequest putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    public OrderPreviewCreateRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="description of test account", value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OrderPreviewCreateRequest accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="A-100001", value="Human-readable identifier of the account. It can be user-supplied.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public OrderPreviewCreateRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0f86a8dd422016a9e7a70116b0d", value="Identifier of the account.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OrderPreviewCreateRequest orderDate(LocalDate orderDate) {
        this.orderDate = orderDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date when the order is signed. All the order actions under this order will use this order date as the contract effective date if the contract effective date field is skipped or its value is left as null.")
    public LocalDate getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(LocalDate orderDate) {
        this.orderDate = orderDate;
    }

    public OrderPreviewCreateRequest orderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The order number of the new order. If not provided, system will auto-generate a number for this order.     Note: Ensure that the order number does not contain a slash.")
    public String getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public OrderPreviewCreateRequest lineItems(List<LineItemCreateRequest> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public OrderPreviewCreateRequest addLineItemsItem(LineItemCreateRequest lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItemCreateRequest>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Order line items are non-subscription-based items created by an order, representing transactional charges such as one-time fees, physical goods, or professional service charges that are not sold as subscription services.    By specifying this field, you can launch non-subscription and unified monetization business models in Zuora, in addition to subscription business models.")
    public List<LineItemCreateRequest> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItemCreateRequest> lineItems) {
        this.lineItems = lineItems;
    }

    public OrderPreviewCreateRequest subscriptions(List<PostSubscriptionOrderRequest> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    public OrderPreviewCreateRequest addSubscriptionsItem(PostSubscriptionOrderRequest subscriptionsItem) {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<PostSubscriptionOrderRequest>();
        }
        this.subscriptions.add(subscriptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Based on the intended order action, each item should include specific fields.     For example, to preview a new subscription for a new account, you must specify the `account_data` and `subscription_plans` fields at a minimum.")
    public List<PostSubscriptionOrderRequest> getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(List<PostSubscriptionOrderRequest> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public OrderPreviewCreateRequest accountData(SubscriptionPreviewAccountRequest accountData) {
        this.accountData = accountData;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SubscriptionPreviewAccountRequest getAccountData() {
        return this.accountData;
    }

    public void setAccountData(SubscriptionPreviewAccountRequest accountData) {
        this.accountData = accountData;
    }

    public OrderPreviewCreateRequest numberOfPeriods(Integer numberOfPeriods) {
        this.numberOfPeriods = numberOfPeriods;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies how many billing periods you want to preview.")
    public Integer getNumberOfPeriods() {
        return this.numberOfPeriods;
    }

    public void setNumberOfPeriods(Integer numberOfPeriods) {
        this.numberOfPeriods = numberOfPeriods;
    }

    public OrderPreviewCreateRequest termEnd(Boolean termEnd) {
        this.termEnd = termEnd;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether to preview the subscription till the end of the current term.")
    public Boolean getTermEnd() {
        return this.termEnd;
    }

    public void setTermEnd(Boolean termEnd) {
        this.termEnd = termEnd;
    }

    public OrderPreviewCreateRequest metrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
        return this;
    }

    public OrderPreviewCreateRequest addMetricsItem(MetricsEnum metricsItem) {
        this.metrics.add(metricsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Specifies the metrics you want to preview.    You can preview metrics of billing documents, the order delta metrics, or both.")
    public List<MetricsEnum> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
    }

    public OrderPreviewCreateRequest endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="End date of the period for which you want to preview the subscription")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderPreviewCreateRequest orderPreviewCreateRequest = (OrderPreviewCreateRequest)o;
        return Objects.equals((Object)this.category, (Object)orderPreviewCreateRequest.category) && Objects.equals(this.customFields, orderPreviewCreateRequest.customFields) && Objects.equals(this.description, orderPreviewCreateRequest.description) && Objects.equals(this.accountNumber, orderPreviewCreateRequest.accountNumber) && Objects.equals(this.accountId, orderPreviewCreateRequest.accountId) && Objects.equals(this.orderDate, orderPreviewCreateRequest.orderDate) && Objects.equals(this.orderNumber, orderPreviewCreateRequest.orderNumber) && Objects.equals(this.lineItems, orderPreviewCreateRequest.lineItems) && Objects.equals(this.subscriptions, orderPreviewCreateRequest.subscriptions) && Objects.equals(this.accountData, orderPreviewCreateRequest.accountData) && Objects.equals(this.numberOfPeriods, orderPreviewCreateRequest.numberOfPeriods) && Objects.equals(this.termEnd, orderPreviewCreateRequest.termEnd) && Objects.equals(this.metrics, orderPreviewCreateRequest.metrics) && Objects.equals(this.endDate, orderPreviewCreateRequest.endDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.category, this.customFields, this.description, this.accountNumber, this.accountId, this.orderDate, this.orderNumber, this.lineItems, this.subscriptions, this.accountData, this.numberOfPeriods, this.termEnd, this.metrics, this.endDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderPreviewCreateRequest {\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    orderDate: ").append(this.toIndentedString(this.orderDate)).append("\n");
        sb.append("    orderNumber: ").append(this.toIndentedString(this.orderNumber)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    subscriptions: ").append(this.toIndentedString(this.subscriptions)).append("\n");
        sb.append("    accountData: ").append(this.toIndentedString(this.accountData)).append("\n");
        sb.append("    numberOfPeriods: ").append(this.toIndentedString(this.numberOfPeriods)).append("\n");
        sb.append("    termEnd: ").append(this.toIndentedString(this.termEnd)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MetricsEnum {
        BILLING_DOCUMENTS("billing_documents"),
        DELTA_METRICS("delta_metrics"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MetricsEnum fromValue(String value) {
            for (MetricsEnum b : MetricsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<MetricsEnum> {
            public void write(JsonWriter jsonWriter, MetricsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MetricsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MetricsEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CategoryEnum {
        SALE("sale"),
        RETURN("return"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CategoryEnum> {
            public void write(JsonWriter jsonWriter, CategoryEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CategoryEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CategoryEnum.fromValue(value);
            }
        }
    }
}

