/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="If the `type` of the payment method is `google_pay`, this hash contains details about the Google Pay payment method. See [Supported payment methods](https://knowledgecenter.zuora.com/Billing/Billing_and_Payments/L_Payment_Methods/A_Supported_Payment_Methods) for payment gateways that support this type of payment method.")
public class GooglePayCreate {
    public static final String SERIALIZED_NAME_CUSTOMER_TOKEN = "customer_token";
    @SerializedName(value="customer_token")
    private Map<String, Object> customerToken = new HashMap<String, Object>();

    public GooglePayCreate customerToken(Map<String, Object> customerToken) {
        this.customerToken = customerToken;
        return this;
    }

    public GooglePayCreate putCustomerTokenItem(String key, Object customerTokenItem) {
        this.customerToken.put(key, customerTokenItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The complete JSON Object representing the encrypted payment token payload returned in the response from the Google Pay session.")
    public Map<String, Object> getCustomerToken() {
        return this.customerToken;
    }

    public void setCustomerToken(Map<String, Object> customerToken) {
        this.customerToken = customerToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GooglePayCreate googlePayCreate = (GooglePayCreate)o;
        return Objects.equals(this.customerToken, googlePayCreate.customerToken);
    }

    public int hashCode() {
        return Objects.hash(this.customerToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GooglePayCreate {\n");
        sb.append("    customerToken: ").append(this.toIndentedString(this.customerToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

