/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class DescribeApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DescribeApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DescribeApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getDescribeCall(String _object, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String showCurrencyConversionInformation, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/describe/{object}".replace("{object}", this.localVarApiClient.escapeString(_object.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (showCurrencyConversionInformation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("showCurrencyConversionInformation", showCurrencyConversionInformation));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"text/xml; charset=utf-8", "application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDescribeValidateBeforeCall(String _object, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String showCurrencyConversionInformation, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (_object == null) {
            throw new ApiException("Missing the required parameter '_object' when calling getDescribe(Async)");
        }
        return this.getDescribeCall(_object, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, showCurrencyConversionInformation, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected String getDescribe(String _object, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String showCurrencyConversionInformation, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<String> localVarResp = this.getDescribeWithHttpInfo(_object, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, showCurrencyConversionInformation, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<String> getDescribeWithHttpInfo(String _object, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String showCurrencyConversionInformation, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getDescribeValidateBeforeCall(_object, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, showCurrencyConversionInformation, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getDescribeAsync(String _object, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String showCurrencyConversionInformation, String zuoraVersion, String zuoraOrgIds, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.getDescribeValidateBeforeCall(_object, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, showCurrencyConversionInformation, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetDescribeApi getDescribeApi(String _object) {
        return new GetDescribeApi(_object);
    }

    public class GetDescribeApi {
        private final String _object;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String showCurrencyConversionInformation;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetDescribeApi(String _object) {
            this._object = _object;
        }

        public GetDescribeApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetDescribeApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetDescribeApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetDescribeApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetDescribeApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetDescribeApi showCurrencyConversionInformation(String showCurrencyConversionInformation) {
            this.showCurrencyConversionInformation = showCurrencyConversionInformation;
            return this;
        }

        public GetDescribeApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetDescribeApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DescribeApi.this.getDescribeCall(this._object, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.showCurrencyConversionInformation, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public String execute() throws ApiException {
            ApiResponse localVarResp = DescribeApi.this.getDescribeWithHttpInfo(this._object, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.showCurrencyConversionInformation, this.zuoraVersion, this.zuoraOrgIds);
            return (String)localVarResp.getData();
        }

        private ApiResponse<String> executeWithHttpInfo() throws ApiException {
            return DescribeApi.this.getDescribeWithHttpInfo(this._object, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.showCurrencyConversionInformation, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<String> _callback) throws ApiException {
            return DescribeApi.this.getDescribeAsync(this._object, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.showCurrencyConversionInformation, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }
}

