/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.CreateProductRatePlanChargeRequest;
import com.zuora.model.GetProductRatePlanChargeResponse;
import com.zuora.model.ProxyCreateOrModifyResponse;
import com.zuora.model.ProxyDeleteResponse;
import com.zuora.model.UpdateProductRatePlanChargeRequest;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ProductRatePlanChargesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ProductRatePlanChargesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProductRatePlanChargesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createProductRatePlanChargeCall(CreateProductRatePlanChargeRequest createRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateProductRatePlanChargeRequest localVarPostBody = createRequest;
        String localVarPath = "/v1/object/product-rate-plan-charge";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (rejectUnknownFields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("rejectUnknownFields", rejectUnknownFields));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (xZuoraWSDLVersion != null) {
            localVarHeaderParams.put("X-Zuora-WSDL-Version", this.localVarApiClient.parameterToString(xZuoraWSDLVersion));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createProductRatePlanChargeValidateBeforeCall(CreateProductRatePlanChargeRequest createRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (createRequest == null) {
            throw new ApiException("Missing the required parameter 'createRequest' when calling createProductRatePlanCharge(Async)");
        }
        return this.createProductRatePlanChargeCall(createRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected ProxyCreateOrModifyResponse createProductRatePlanCharge(CreateProductRatePlanChargeRequest createRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<ProxyCreateOrModifyResponse> localVarResp = this.createProductRatePlanChargeWithHttpInfo(createRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<ProxyCreateOrModifyResponse> createProductRatePlanChargeWithHttpInfo(CreateProductRatePlanChargeRequest createRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.createProductRatePlanChargeValidateBeforeCall(createRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<ProxyCreateOrModifyResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createProductRatePlanChargeAsync(CreateProductRatePlanChargeRequest createRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<ProxyCreateOrModifyResponse> _callback) throws ApiException {
        Call localVarCall = this.createProductRatePlanChargeValidateBeforeCall(createRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<ProxyCreateOrModifyResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateProductRatePlanChargeApi createProductRatePlanChargeApi(CreateProductRatePlanChargeRequest createRequest) {
        return new CreateProductRatePlanChargeApi(createRequest);
    }

    private Call deleteProductRatePlanChargeCall(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/object/product-rate-plan-charge/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProductRatePlanChargeValidateBeforeCall(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteProductRatePlanCharge(Async)");
        }
        return this.deleteProductRatePlanChargeCall(id, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected ProxyDeleteResponse deleteProductRatePlanCharge(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<ProxyDeleteResponse> localVarResp = this.deleteProductRatePlanChargeWithHttpInfo(id, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<ProxyDeleteResponse> deleteProductRatePlanChargeWithHttpInfo(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.deleteProductRatePlanChargeValidateBeforeCall(id, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<ProxyDeleteResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteProductRatePlanChargeAsync(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<ProxyDeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteProductRatePlanChargeValidateBeforeCall(id, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<ProxyDeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DeleteProductRatePlanChargeApi deleteProductRatePlanChargeApi(String id) {
        return new DeleteProductRatePlanChargeApi(id);
    }

    private Call getProductRatePlanChargeCall(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String fields, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/object/product-rate-plan-charge/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (xZuoraWSDLVersion != null) {
            localVarHeaderParams.put("X-Zuora-WSDL-Version", this.localVarApiClient.parameterToString(xZuoraWSDLVersion));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProductRatePlanChargeValidateBeforeCall(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String fields, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getProductRatePlanCharge(Async)");
        }
        return this.getProductRatePlanChargeCall(id, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, fields, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected GetProductRatePlanChargeResponse getProductRatePlanCharge(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String fields, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<GetProductRatePlanChargeResponse> localVarResp = this.getProductRatePlanChargeWithHttpInfo(id, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, fields, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<GetProductRatePlanChargeResponse> getProductRatePlanChargeWithHttpInfo(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String fields, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.getProductRatePlanChargeValidateBeforeCall(id, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, fields, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<GetProductRatePlanChargeResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getProductRatePlanChargeAsync(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String fields, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<GetProductRatePlanChargeResponse> _callback) throws ApiException {
        Call localVarCall = this.getProductRatePlanChargeValidateBeforeCall(id, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, fields, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<GetProductRatePlanChargeResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetProductRatePlanChargeApi getProductRatePlanChargeApi(String id) {
        return new GetProductRatePlanChargeApi(id);
    }

    private Call updateProductRatePlanChargeCall(String id, UpdateProductRatePlanChargeRequest modifyRequest, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateProductRatePlanChargeRequest localVarPostBody = modifyRequest;
        String localVarPath = "/v1/object/product-rate-plan-charge/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (rejectUnknownFields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("rejectUnknownFields", rejectUnknownFields));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (xZuoraWSDLVersion != null) {
            localVarHeaderParams.put("X-Zuora-WSDL-Version", this.localVarApiClient.parameterToString(xZuoraWSDLVersion));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateProductRatePlanChargeValidateBeforeCall(String id, UpdateProductRatePlanChargeRequest modifyRequest, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateProductRatePlanCharge(Async)");
        }
        if (modifyRequest == null) {
            throw new ApiException("Missing the required parameter 'modifyRequest' when calling updateProductRatePlanCharge(Async)");
        }
        return this.updateProductRatePlanChargeCall(id, modifyRequest, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected ProxyCreateOrModifyResponse updateProductRatePlanCharge(String id, UpdateProductRatePlanChargeRequest modifyRequest, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<ProxyCreateOrModifyResponse> localVarResp = this.updateProductRatePlanChargeWithHttpInfo(id, modifyRequest, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<ProxyCreateOrModifyResponse> updateProductRatePlanChargeWithHttpInfo(String id, UpdateProductRatePlanChargeRequest modifyRequest, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.updateProductRatePlanChargeValidateBeforeCall(id, modifyRequest, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<ProxyCreateOrModifyResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call updateProductRatePlanChargeAsync(String id, UpdateProductRatePlanChargeRequest modifyRequest, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<ProxyCreateOrModifyResponse> _callback) throws ApiException {
        Call localVarCall = this.updateProductRatePlanChargeValidateBeforeCall(id, modifyRequest, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<ProxyCreateOrModifyResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateProductRatePlanChargeApi updateProductRatePlanChargeApi(String id, UpdateProductRatePlanChargeRequest modifyRequest) {
        return new UpdateProductRatePlanChargeApi(id, modifyRequest);
    }

    public class UpdateProductRatePlanChargeApi {
        private final String id;
        private final UpdateProductRatePlanChargeRequest modifyRequest;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private Boolean rejectUnknownFields;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String xZuoraWSDLVersion;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private UpdateProductRatePlanChargeApi(String id, UpdateProductRatePlanChargeRequest modifyRequest) {
            this.id = id;
            this.modifyRequest = modifyRequest;
        }

        public UpdateProductRatePlanChargeApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdateProductRatePlanChargeApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdateProductRatePlanChargeApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdateProductRatePlanChargeApi rejectUnknownFields(Boolean rejectUnknownFields) {
            this.rejectUnknownFields = rejectUnknownFields;
            return this;
        }

        public UpdateProductRatePlanChargeApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdateProductRatePlanChargeApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdateProductRatePlanChargeApi xZuoraWSDLVersion(String xZuoraWSDLVersion) {
            this.xZuoraWSDLVersion = xZuoraWSDLVersion;
            return this;
        }

        public UpdateProductRatePlanChargeApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UpdateProductRatePlanChargeApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public UpdateProductRatePlanChargeApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ProductRatePlanChargesApi.this.updateProductRatePlanChargeCall(this.id, this.modifyRequest, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public ProxyCreateOrModifyResponse execute() throws ApiException {
            ApiResponse localVarResp = ProductRatePlanChargesApi.this.updateProductRatePlanChargeWithHttpInfo(this.id, this.modifyRequest, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (ProxyCreateOrModifyResponse)localVarResp.getData();
        }

        private ApiResponse<ProxyCreateOrModifyResponse> executeWithHttpInfo() throws ApiException {
            return ProductRatePlanChargesApi.this.updateProductRatePlanChargeWithHttpInfo(this.id, this.modifyRequest, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<ProxyCreateOrModifyResponse> _callback) throws ApiException {
            return ProductRatePlanChargesApi.this.updateProductRatePlanChargeAsync(this.id, this.modifyRequest, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class GetProductRatePlanChargeApi {
        private final String id;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String xZuoraWSDLVersion;
        private String fields;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private GetProductRatePlanChargeApi(String id) {
            this.id = id;
        }

        public GetProductRatePlanChargeApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetProductRatePlanChargeApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetProductRatePlanChargeApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetProductRatePlanChargeApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetProductRatePlanChargeApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetProductRatePlanChargeApi xZuoraWSDLVersion(String xZuoraWSDLVersion) {
            this.xZuoraWSDLVersion = xZuoraWSDLVersion;
            return this;
        }

        public GetProductRatePlanChargeApi fields(String fields) {
            this.fields = fields;
            return this;
        }

        public GetProductRatePlanChargeApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetProductRatePlanChargeApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public GetProductRatePlanChargeApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ProductRatePlanChargesApi.this.getProductRatePlanChargeCall(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.fields, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public GetProductRatePlanChargeResponse execute() throws ApiException {
            ApiResponse localVarResp = ProductRatePlanChargesApi.this.getProductRatePlanChargeWithHttpInfo(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.fields, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (GetProductRatePlanChargeResponse)localVarResp.getData();
        }

        private ApiResponse<GetProductRatePlanChargeResponse> executeWithHttpInfo() throws ApiException {
            return ProductRatePlanChargesApi.this.getProductRatePlanChargeWithHttpInfo(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.fields, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<GetProductRatePlanChargeResponse> _callback) throws ApiException {
            return ProductRatePlanChargesApi.this.getProductRatePlanChargeAsync(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.fields, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class DeleteProductRatePlanChargeApi {
        private final String id;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private DeleteProductRatePlanChargeApi(String id) {
            this.id = id;
        }

        public DeleteProductRatePlanChargeApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public DeleteProductRatePlanChargeApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public DeleteProductRatePlanChargeApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public DeleteProductRatePlanChargeApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public DeleteProductRatePlanChargeApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public DeleteProductRatePlanChargeApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public DeleteProductRatePlanChargeApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public DeleteProductRatePlanChargeApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ProductRatePlanChargesApi.this.deleteProductRatePlanChargeCall(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public ProxyDeleteResponse execute() throws ApiException {
            ApiResponse localVarResp = ProductRatePlanChargesApi.this.deleteProductRatePlanChargeWithHttpInfo(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (ProxyDeleteResponse)localVarResp.getData();
        }

        private ApiResponse<ProxyDeleteResponse> executeWithHttpInfo() throws ApiException {
            return ProductRatePlanChargesApi.this.deleteProductRatePlanChargeWithHttpInfo(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<ProxyDeleteResponse> _callback) throws ApiException {
            return ProductRatePlanChargesApi.this.deleteProductRatePlanChargeAsync(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class CreateProductRatePlanChargeApi {
        private final CreateProductRatePlanChargeRequest createRequest;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private Boolean rejectUnknownFields;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String xZuoraWSDLVersion;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private CreateProductRatePlanChargeApi(CreateProductRatePlanChargeRequest createRequest) {
            this.createRequest = createRequest;
        }

        public CreateProductRatePlanChargeApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateProductRatePlanChargeApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreateProductRatePlanChargeApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreateProductRatePlanChargeApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreateProductRatePlanChargeApi rejectUnknownFields(Boolean rejectUnknownFields) {
            this.rejectUnknownFields = rejectUnknownFields;
            return this;
        }

        public CreateProductRatePlanChargeApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreateProductRatePlanChargeApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreateProductRatePlanChargeApi xZuoraWSDLVersion(String xZuoraWSDLVersion) {
            this.xZuoraWSDLVersion = xZuoraWSDLVersion;
            return this;
        }

        public CreateProductRatePlanChargeApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreateProductRatePlanChargeApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public CreateProductRatePlanChargeApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ProductRatePlanChargesApi.this.createProductRatePlanChargeCall(this.createRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public ProxyCreateOrModifyResponse execute() throws ApiException {
            ApiResponse localVarResp = ProductRatePlanChargesApi.this.createProductRatePlanChargeWithHttpInfo(this.createRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (ProxyCreateOrModifyResponse)localVarResp.getData();
        }

        private ApiResponse<ProxyCreateOrModifyResponse> executeWithHttpInfo() throws ApiException {
            return ProductRatePlanChargesApi.this.createProductRatePlanChargeWithHttpInfo(this.createRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<ProxyCreateOrModifyResponse> _callback) throws ApiException {
            return ProductRatePlanChargesApi.this.createProductRatePlanChargeAsync(this.createRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }
}

