/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.CustomObjectDefinition;
import com.zuora.model.GetAllCustomObjectDefinitionsInNamespaceResponse;
import com.zuora.model.MigrationUpdateCustomObjectDefinitionsRequest;
import com.zuora.model.MigrationUpdateCustomObjectDefinitionsResponse;
import com.zuora.model.PostCustomObjectDefinitionsRequest;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class CustomObjectDefinitionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CustomObjectDefinitionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomObjectDefinitionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call deleteCustomObjectDefinitionByTypeCall(String _object, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/objects/definitions/default/{object}".replace("{object}", this.localVarApiClient.escapeString(_object.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCustomObjectDefinitionByTypeValidateBeforeCall(String _object, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (_object == null) {
            throw new ApiException("Missing the required parameter '_object' when calling deleteCustomObjectDefinitionByType(Async)");
        }
        return this.deleteCustomObjectDefinitionByTypeCall(_object, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected URI deleteCustomObjectDefinitionByType(String _object, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<URI> localVarResp = this.deleteCustomObjectDefinitionByTypeWithHttpInfo(_object, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<URI> deleteCustomObjectDefinitionByTypeWithHttpInfo(String _object, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.deleteCustomObjectDefinitionByTypeValidateBeforeCall(_object, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<URI>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCustomObjectDefinitionByTypeAsync(String _object, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<URI> _callback) throws ApiException {
        Call localVarCall = this.deleteCustomObjectDefinitionByTypeValidateBeforeCall(_object, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<URI>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DeleteCustomObjectDefinitionByTypeApi deleteCustomObjectDefinitionByTypeApi(String _object) {
        return new DeleteCustomObjectDefinitionByTypeApi(_object);
    }

    private Call getAllCustomObjectDefinitionsInNamespaceCall(String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String select, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/objects/definitions/default";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (select != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("select", select));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllCustomObjectDefinitionsInNamespaceValidateBeforeCall(String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String select, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        return this.getAllCustomObjectDefinitionsInNamespaceCall(acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, select, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected GetAllCustomObjectDefinitionsInNamespaceResponse getAllCustomObjectDefinitionsInNamespace(String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String select, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<GetAllCustomObjectDefinitionsInNamespaceResponse> localVarResp = this.getAllCustomObjectDefinitionsInNamespaceWithHttpInfo(acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, select, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<GetAllCustomObjectDefinitionsInNamespaceResponse> getAllCustomObjectDefinitionsInNamespaceWithHttpInfo(String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String select, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.getAllCustomObjectDefinitionsInNamespaceValidateBeforeCall(acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, select, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<GetAllCustomObjectDefinitionsInNamespaceResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getAllCustomObjectDefinitionsInNamespaceAsync(String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String select, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<GetAllCustomObjectDefinitionsInNamespaceResponse> _callback) throws ApiException {
        Call localVarCall = this.getAllCustomObjectDefinitionsInNamespaceValidateBeforeCall(acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, select, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<GetAllCustomObjectDefinitionsInNamespaceResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetAllCustomObjectDefinitionsInNamespaceApi getAllCustomObjectDefinitionsInNamespaceApi() {
        return new GetAllCustomObjectDefinitionsInNamespaceApi();
    }

    private Call getCustomObjectDefinitionByTypeCall(String _object, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/objects/definitions/default/{object}".replace("{object}", this.localVarApiClient.escapeString(_object.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCustomObjectDefinitionByTypeValidateBeforeCall(String _object, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (_object == null) {
            throw new ApiException("Missing the required parameter '_object' when calling getCustomObjectDefinitionByType(Async)");
        }
        return this.getCustomObjectDefinitionByTypeCall(_object, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected CustomObjectDefinition getCustomObjectDefinitionByType(String _object, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<CustomObjectDefinition> localVarResp = this.getCustomObjectDefinitionByTypeWithHttpInfo(_object, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<CustomObjectDefinition> getCustomObjectDefinitionByTypeWithHttpInfo(String _object, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.getCustomObjectDefinitionByTypeValidateBeforeCall(_object, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<CustomObjectDefinition>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getCustomObjectDefinitionByTypeAsync(String _object, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<CustomObjectDefinition> _callback) throws ApiException {
        Call localVarCall = this.getCustomObjectDefinitionByTypeValidateBeforeCall(_object, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<CustomObjectDefinition>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCustomObjectDefinitionByTypeApi getCustomObjectDefinitionByTypeApi(String _object) {
        return new GetCustomObjectDefinitionByTypeApi(_object);
    }

    private Call postCustomObjectDefinitionsCall(PostCustomObjectDefinitionsRequest customObjectDefinitions, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PostCustomObjectDefinitionsRequest localVarPostBody = customObjectDefinitions;
        String localVarPath = "/objects/definitions/default";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postCustomObjectDefinitionsValidateBeforeCall(PostCustomObjectDefinitionsRequest customObjectDefinitions, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (customObjectDefinitions == null) {
            throw new ApiException("Missing the required parameter 'customObjectDefinitions' when calling postCustomObjectDefinitions(Async)");
        }
        return this.postCustomObjectDefinitionsCall(customObjectDefinitions, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected GetAllCustomObjectDefinitionsInNamespaceResponse postCustomObjectDefinitions(PostCustomObjectDefinitionsRequest customObjectDefinitions, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<GetAllCustomObjectDefinitionsInNamespaceResponse> localVarResp = this.postCustomObjectDefinitionsWithHttpInfo(customObjectDefinitions, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<GetAllCustomObjectDefinitionsInNamespaceResponse> postCustomObjectDefinitionsWithHttpInfo(PostCustomObjectDefinitionsRequest customObjectDefinitions, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.postCustomObjectDefinitionsValidateBeforeCall(customObjectDefinitions, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<GetAllCustomObjectDefinitionsInNamespaceResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call postCustomObjectDefinitionsAsync(PostCustomObjectDefinitionsRequest customObjectDefinitions, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<GetAllCustomObjectDefinitionsInNamespaceResponse> _callback) throws ApiException {
        Call localVarCall = this.postCustomObjectDefinitionsValidateBeforeCall(customObjectDefinitions, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<GetAllCustomObjectDefinitionsInNamespaceResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostCustomObjectDefinitionsApi postCustomObjectDefinitionsApi(PostCustomObjectDefinitionsRequest customObjectDefinitions) {
        return new PostCustomObjectDefinitionsApi(customObjectDefinitions);
    }

    private Call postUpdateCustomObjectDefinitionCall(MigrationUpdateCustomObjectDefinitionsRequest migration, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        MigrationUpdateCustomObjectDefinitionsRequest localVarPostBody = migration;
        String localVarPath = "/objects/migrations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postUpdateCustomObjectDefinitionValidateBeforeCall(MigrationUpdateCustomObjectDefinitionsRequest migration, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (migration == null) {
            throw new ApiException("Missing the required parameter 'migration' when calling postUpdateCustomObjectDefinition(Async)");
        }
        return this.postUpdateCustomObjectDefinitionCall(migration, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected MigrationUpdateCustomObjectDefinitionsResponse postUpdateCustomObjectDefinition(MigrationUpdateCustomObjectDefinitionsRequest migration, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<MigrationUpdateCustomObjectDefinitionsResponse> localVarResp = this.postUpdateCustomObjectDefinitionWithHttpInfo(migration, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<MigrationUpdateCustomObjectDefinitionsResponse> postUpdateCustomObjectDefinitionWithHttpInfo(MigrationUpdateCustomObjectDefinitionsRequest migration, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.postUpdateCustomObjectDefinitionValidateBeforeCall(migration, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<MigrationUpdateCustomObjectDefinitionsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call postUpdateCustomObjectDefinitionAsync(MigrationUpdateCustomObjectDefinitionsRequest migration, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<MigrationUpdateCustomObjectDefinitionsResponse> _callback) throws ApiException {
        Call localVarCall = this.postUpdateCustomObjectDefinitionValidateBeforeCall(migration, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<MigrationUpdateCustomObjectDefinitionsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostUpdateCustomObjectDefinitionApi postUpdateCustomObjectDefinitionApi(MigrationUpdateCustomObjectDefinitionsRequest migration) {
        return new PostUpdateCustomObjectDefinitionApi(migration);
    }

    public class PostUpdateCustomObjectDefinitionApi {
        private final MigrationUpdateCustomObjectDefinitionsRequest migration;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String authorization;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private PostUpdateCustomObjectDefinitionApi(MigrationUpdateCustomObjectDefinitionsRequest migration) {
            this.migration = migration;
        }

        public PostUpdateCustomObjectDefinitionApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PostUpdateCustomObjectDefinitionApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PostUpdateCustomObjectDefinitionApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PostUpdateCustomObjectDefinitionApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PostUpdateCustomObjectDefinitionApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PostUpdateCustomObjectDefinitionApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PostUpdateCustomObjectDefinitionApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public PostUpdateCustomObjectDefinitionApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public PostUpdateCustomObjectDefinitionApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectDefinitionsApi.this.postUpdateCustomObjectDefinitionCall(this.migration, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public MigrationUpdateCustomObjectDefinitionsResponse execute() throws ApiException {
            ApiResponse localVarResp = CustomObjectDefinitionsApi.this.postUpdateCustomObjectDefinitionWithHttpInfo(this.migration, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (MigrationUpdateCustomObjectDefinitionsResponse)localVarResp.getData();
        }

        private ApiResponse<MigrationUpdateCustomObjectDefinitionsResponse> executeWithHttpInfo() throws ApiException {
            return CustomObjectDefinitionsApi.this.postUpdateCustomObjectDefinitionWithHttpInfo(this.migration, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<MigrationUpdateCustomObjectDefinitionsResponse> _callback) throws ApiException {
            return CustomObjectDefinitionsApi.this.postUpdateCustomObjectDefinitionAsync(this.migration, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class PostCustomObjectDefinitionsApi {
        private final PostCustomObjectDefinitionsRequest customObjectDefinitions;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String authorization;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private PostCustomObjectDefinitionsApi(PostCustomObjectDefinitionsRequest customObjectDefinitions) {
            this.customObjectDefinitions = customObjectDefinitions;
        }

        public PostCustomObjectDefinitionsApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PostCustomObjectDefinitionsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PostCustomObjectDefinitionsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PostCustomObjectDefinitionsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PostCustomObjectDefinitionsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PostCustomObjectDefinitionsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PostCustomObjectDefinitionsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public PostCustomObjectDefinitionsApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public PostCustomObjectDefinitionsApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectDefinitionsApi.this.postCustomObjectDefinitionsCall(this.customObjectDefinitions, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public GetAllCustomObjectDefinitionsInNamespaceResponse execute() throws ApiException {
            ApiResponse localVarResp = CustomObjectDefinitionsApi.this.postCustomObjectDefinitionsWithHttpInfo(this.customObjectDefinitions, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (GetAllCustomObjectDefinitionsInNamespaceResponse)localVarResp.getData();
        }

        private ApiResponse<GetAllCustomObjectDefinitionsInNamespaceResponse> executeWithHttpInfo() throws ApiException {
            return CustomObjectDefinitionsApi.this.postCustomObjectDefinitionsWithHttpInfo(this.customObjectDefinitions, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<GetAllCustomObjectDefinitionsInNamespaceResponse> _callback) throws ApiException {
            return CustomObjectDefinitionsApi.this.postCustomObjectDefinitionsAsync(this.customObjectDefinitions, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class GetCustomObjectDefinitionByTypeApi {
        private final String _object;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String authorization;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private GetCustomObjectDefinitionByTypeApi(String _object) {
            this._object = _object;
        }

        public GetCustomObjectDefinitionByTypeApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetCustomObjectDefinitionByTypeApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetCustomObjectDefinitionByTypeApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetCustomObjectDefinitionByTypeApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetCustomObjectDefinitionByTypeApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetCustomObjectDefinitionByTypeApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetCustomObjectDefinitionByTypeApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public GetCustomObjectDefinitionByTypeApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectDefinitionsApi.this.getCustomObjectDefinitionByTypeCall(this._object, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public CustomObjectDefinition execute() throws ApiException {
            ApiResponse localVarResp = CustomObjectDefinitionsApi.this.getCustomObjectDefinitionByTypeWithHttpInfo(this._object, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (CustomObjectDefinition)localVarResp.getData();
        }

        private ApiResponse<CustomObjectDefinition> executeWithHttpInfo() throws ApiException {
            return CustomObjectDefinitionsApi.this.getCustomObjectDefinitionByTypeWithHttpInfo(this._object, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<CustomObjectDefinition> _callback) throws ApiException {
            return CustomObjectDefinitionsApi.this.getCustomObjectDefinitionByTypeAsync(this._object, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class GetAllCustomObjectDefinitionsInNamespaceApi {
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String authorization;
        private String zuoraVersion;
        private String select;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private GetAllCustomObjectDefinitionsInNamespaceApi() {
        }

        public GetAllCustomObjectDefinitionsInNamespaceApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetAllCustomObjectDefinitionsInNamespaceApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetAllCustomObjectDefinitionsInNamespaceApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetAllCustomObjectDefinitionsInNamespaceApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetAllCustomObjectDefinitionsInNamespaceApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetAllCustomObjectDefinitionsInNamespaceApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetAllCustomObjectDefinitionsInNamespaceApi select(String select) {
            this.select = select;
            return this;
        }

        public GetAllCustomObjectDefinitionsInNamespaceApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public GetAllCustomObjectDefinitionsInNamespaceApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectDefinitionsApi.this.getAllCustomObjectDefinitionsInNamespaceCall(this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.select, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public GetAllCustomObjectDefinitionsInNamespaceResponse execute() throws ApiException {
            ApiResponse localVarResp = CustomObjectDefinitionsApi.this.getAllCustomObjectDefinitionsInNamespaceWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.select, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (GetAllCustomObjectDefinitionsInNamespaceResponse)localVarResp.getData();
        }

        private ApiResponse<GetAllCustomObjectDefinitionsInNamespaceResponse> executeWithHttpInfo() throws ApiException {
            return CustomObjectDefinitionsApi.this.getAllCustomObjectDefinitionsInNamespaceWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.select, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<GetAllCustomObjectDefinitionsInNamespaceResponse> _callback) throws ApiException {
            return CustomObjectDefinitionsApi.this.getAllCustomObjectDefinitionsInNamespaceAsync(this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.select, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class DeleteCustomObjectDefinitionByTypeApi {
        private final String _object;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String authorization;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private DeleteCustomObjectDefinitionByTypeApi(String _object) {
            this._object = _object;
        }

        public DeleteCustomObjectDefinitionByTypeApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public DeleteCustomObjectDefinitionByTypeApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public DeleteCustomObjectDefinitionByTypeApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public DeleteCustomObjectDefinitionByTypeApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public DeleteCustomObjectDefinitionByTypeApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public DeleteCustomObjectDefinitionByTypeApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public DeleteCustomObjectDefinitionByTypeApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public DeleteCustomObjectDefinitionByTypeApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectDefinitionsApi.this.deleteCustomObjectDefinitionByTypeCall(this._object, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public URI execute() throws ApiException {
            ApiResponse localVarResp = CustomObjectDefinitionsApi.this.deleteCustomObjectDefinitionByTypeWithHttpInfo(this._object, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (URI)localVarResp.getData();
        }

        private ApiResponse<URI> executeWithHttpInfo() throws ApiException {
            return CustomObjectDefinitionsApi.this.deleteCustomObjectDefinitionByTypeWithHttpInfo(this._object, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<URI> _callback) throws ApiException {
            return CustomObjectDefinitionsApi.this.deleteCustomObjectDefinitionByTypeAsync(this._object, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }
}

