/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.ListQueryParams;
import org.openapitools.client.model.SubscriptionItemListResponse;

public class SubscriptionItemsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SubscriptionItemsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubscriptionItemsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getSubscriptionItemsCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> subscriptionItemFields, List<String> priceFields, List<String> subscriptionPlanFields, List<String> planFields, List<String> productFields, List<String> subscriptionFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/subscription_items";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (subscriptionItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_item.fields[]", subscriptionItemFields));
        }
        if (priceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "price.fields[]", priceFields));
        }
        if (subscriptionPlanFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plan.fields[]", subscriptionPlanFields));
        }
        if (planFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plan.fields[]", planFields));
        }
        if (productFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "product.fields[]", productFields));
        }
        if (subscriptionFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription.fields[]", subscriptionFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSubscriptionItemsValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> subscriptionItemFields, List<String> priceFields, List<String> subscriptionPlanFields, List<String> planFields, List<String> productFields, List<String> subscriptionFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getSubscriptionItemsCall(cursor, expand, filter, sort, pageSize, fields, subscriptionItemFields, priceFields, subscriptionPlanFields, planFields, productFields, subscriptionFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<SubscriptionItemListResponse> getSubscriptionItemsWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> subscriptionItemFields, List<String> priceFields, List<String> subscriptionPlanFields, List<String> planFields, List<String> productFields, List<String> subscriptionFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getSubscriptionItemsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, subscriptionItemFields, priceFields, subscriptionPlanFields, planFields, productFields, subscriptionFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<SubscriptionItemListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getSubscriptionItemsAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> subscriptionItemFields, List<String> priceFields, List<String> subscriptionPlanFields, List<String> planFields, List<String> productFields, List<String> subscriptionFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<SubscriptionItemListResponse> _callback) throws ApiException {
        Call localVarCall = this.getSubscriptionItemsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, subscriptionItemFields, priceFields, subscriptionPlanFields, planFields, productFields, subscriptionFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<SubscriptionItemListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetSubscriptionItemsParams getSubscriptionItemsParams() {
        return new GetSubscriptionItemsParams();
    }

    public SubscriptionItemListResponse getSubscriptionItems() throws ApiException {
        GetSubscriptionItemsParams params = new GetSubscriptionItemsParams();
        return this.executeGetSubscriptionItemsAPICall(params).getData();
    }

    public SubscriptionItemListResponse getSubscriptionItems(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetSubscriptionItemsParams params = new GetSubscriptionItemsParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetSubscriptionItemsAPICall(params).getData();
    }

    public SubscriptionItemListResponse getSubscriptionItems(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetSubscriptionItemsParams params = new GetSubscriptionItemsParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetSubscriptionItemsAPICall(params).getData();
    }

    public SubscriptionItemListResponse list(GetSubscriptionItemsParams params) throws ApiException {
        return this.executeGetSubscriptionItemsAPICall(params).getData();
    }

    public ApiResponse<SubscriptionItemListResponse> listWithHttpInfo(GetSubscriptionItemsParams params) throws ApiException {
        return this.executeGetSubscriptionItemsAPICall(params);
    }

    ApiResponse<SubscriptionItemListResponse> executeGetSubscriptionItemsAPICall(GetSubscriptionItemsParams params) throws ApiException {
        return this.getSubscriptionItemsWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.subscriptionItemFields, params.priceFields, params.subscriptionPlanFields, params.planFields, params.productFields, params.subscriptionFields, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    public static class GetSubscriptionItemsParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> subscriptionItemFields;
        private List<String> priceFields;
        private List<String> subscriptionPlanFields;
        private List<String> planFields;
        private List<String> productFields;
        private List<String> subscriptionFields;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetSubscriptionItemsParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetSubscriptionItemsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetSubscriptionItemsParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetSubscriptionItemsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetSubscriptionItemsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetSubscriptionItemsParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetSubscriptionItemsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetSubscriptionItemsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetSubscriptionItemsParams subscriptionItemFields(List<String> subscriptionItemFields) {
            this.subscriptionItemFields = subscriptionItemFields;
            return this;
        }

        public GetSubscriptionItemsParams priceFields(List<String> priceFields) {
            this.priceFields = priceFields;
            return this;
        }

        public GetSubscriptionItemsParams subscriptionPlanFields(List<String> subscriptionPlanFields) {
            this.subscriptionPlanFields = subscriptionPlanFields;
            return this;
        }

        public GetSubscriptionItemsParams planFields(List<String> planFields) {
            this.planFields = planFields;
            return this;
        }

        public GetSubscriptionItemsParams productFields(List<String> productFields) {
            this.productFields = productFields;
            return this;
        }

        public GetSubscriptionItemsParams subscriptionFields(List<String> subscriptionFields) {
            this.subscriptionFields = subscriptionFields;
            return this;
        }
    }
}

