/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.Drawdown;
import org.openapitools.client.model.Overage;
import org.openapitools.client.model.Prepayment;
import org.openapitools.client.model.Recurring;
import org.openapitools.client.model.Revenue;
import org.openapitools.client.model.Tier;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.OffsetDateTime;

public class PricePatchRequest {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_RECOGNIZED_REVENUE_ACCOUNTING_CODE = "recognized_revenue_accounting_code";
    @SerializedName(value="recognized_revenue_accounting_code")
    private String recognizedRevenueAccountingCode;
    public static final String SERIALIZED_NAME_DEFERRED_REVENUE_ACCOUNTING_CODE = "deferred_revenue_accounting_code";
    @SerializedName(value="deferred_revenue_accounting_code")
    private String deferredRevenueAccountingCode;
    public static final String SERIALIZED_NAME_RECURRING = "recurring";
    @SerializedName(value="recurring")
    private Recurring recurring;
    public static final String SERIALIZED_NAME_START_EVENT = "start_event";
    @SerializedName(value="start_event")
    private StartEventEnum startEvent;
    public static final String SERIALIZED_NAME_TIERS_MODE = "tiers_mode";
    @SerializedName(value="tiers_mode")
    private TiersModeEnum tiersMode;
    public static final String SERIALIZED_NAME_APPLY_DISCOUNT_TO = "apply_discount_to";
    @SerializedName(value="apply_discount_to")
    private List<ApplyDiscountToEnum> applyDiscountTo = null;
    public static final String SERIALIZED_NAME_TIERS = "tiers";
    @SerializedName(value="tiers")
    private List<Tier> tiers = null;
    public static final String SERIALIZED_NAME_TAX_CODE = "tax_code";
    @SerializedName(value="tax_code")
    private String taxCode;
    public static final String SERIALIZED_NAME_TAX_INCLUSIVE = "tax_inclusive";
    @SerializedName(value="tax_inclusive")
    private Boolean taxInclusive;
    public static final String SERIALIZED_NAME_UNIT_OF_MEASURE = "unit_of_measure";
    @SerializedName(value="unit_of_measure")
    private String unitOfMeasure;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private BigDecimal quantity;
    public static final String SERIALIZED_NAME_MIN_QUANTITY = "min_quantity";
    @SerializedName(value="min_quantity")
    private BigDecimal minQuantity;
    public static final String SERIALIZED_NAME_MAX_QUANTITY = "max_quantity";
    @SerializedName(value="max_quantity")
    private BigDecimal maxQuantity;
    public static final String SERIALIZED_NAME_DISCOUNT_LEVEL = "discount_level";
    @SerializedName(value="discount_level")
    private DiscountLevelEnum discountLevel;
    public static final String SERIALIZED_NAME_REVENUE_RECOGNITION_RULE = "revenue_recognition_rule";
    @SerializedName(value="revenue_recognition_rule")
    private RevenueRecognitionRuleEnum revenueRecognitionRule;
    public static final String SERIALIZED_NAME_STACKED_DISCOUNT = "stacked_discount";
    @SerializedName(value="stacked_discount")
    private Boolean stackedDiscount;
    public static final String SERIALIZED_NAME_AMOUNTS = "amounts";
    @SerializedName(value="amounts")
    private Map<String, BigDecimal> amounts = null;
    public static final String SERIALIZED_NAME_UNIT_AMOUNTS = "unit_amounts";
    @SerializedName(value="unit_amounts")
    private Map<String, BigDecimal> unitAmounts = null;
    public static final String SERIALIZED_NAME_DISCOUNT_AMOUNTS = "discount_amounts";
    @SerializedName(value="discount_amounts")
    private Map<String, BigDecimal> discountAmounts = null;
    public static final String SERIALIZED_NAME_DISCOUNT_PERCENT = "discount_percent";
    @SerializedName(value="discount_percent")
    private BigDecimal discountPercent;
    public static final String SERIALIZED_NAME_PRICE_BASE_INTERVAL = "price_base_interval";
    @SerializedName(value="price_base_interval")
    private PriceBaseIntervalEnum priceBaseInterval;
    public static final String SERIALIZED_NAME_OVERAGE = "overage";
    @SerializedName(value="overage")
    private Overage overage;
    public static final String SERIALIZED_NAME_REVENUE = "revenue";
    @SerializedName(value="revenue")
    private Revenue revenue;
    public static final String SERIALIZED_NAME_ACCOUNTING_CODE = "accounting_code";
    @SerializedName(value="accounting_code")
    private String accountingCode;
    public static final String SERIALIZED_NAME_PREPAYMENT = "prepayment";
    @SerializedName(value="prepayment")
    private Prepayment prepayment;
    public static final String SERIALIZED_NAME_DRAWDOWN = "drawdown";
    @SerializedName(value="drawdown")
    private Drawdown drawdown;
    public static final String SERIALIZED_NAME_TAXABLE = "taxable";
    @SerializedName(value="taxable")
    private Boolean taxable;
    public static final String SERIALIZED_NAME_PRICE_CHANGE_PERCENTAGE = "price_change_percentage";
    @SerializedName(value="price_change_percentage")
    private BigDecimal priceChangePercentage;
    public static final String SERIALIZED_NAME_PRICE_CHANGE_OPTION = "price_change_option";
    @SerializedName(value="price_change_option")
    private PriceChangeOptionEnum priceChangeOption;
    public static final String SERIALIZED_NAME_PRICE_INCREASE_OPTION = "price_increase_option";
    @SerializedName(value="price_increase_option")
    private Boolean priceIncreaseOption;

    public PricePatchRequest() {
    }

    public PricePatchRequest(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public PricePatchRequest customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public PricePatchRequest putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public PricePatchRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the price.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PricePatchRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PricePatchRequest recognizedRevenueAccountingCode(String recognizedRevenueAccountingCode) {
        this.recognizedRevenueAccountingCode = recognizedRevenueAccountingCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code in your Zuora chart of accounts.")
    public String getRecognizedRevenueAccountingCode() {
        return this.recognizedRevenueAccountingCode;
    }

    public void setRecognizedRevenueAccountingCode(String recognizedRevenueAccountingCode) {
        this.recognizedRevenueAccountingCode = recognizedRevenueAccountingCode;
    }

    public PricePatchRequest deferredRevenueAccountingCode(String deferredRevenueAccountingCode) {
        this.deferredRevenueAccountingCode = deferredRevenueAccountingCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code in your Zuora chart of accounts.")
    public String getDeferredRevenueAccountingCode() {
        return this.deferredRevenueAccountingCode;
    }

    public void setDeferredRevenueAccountingCode(String deferredRevenueAccountingCode) {
        this.deferredRevenueAccountingCode = deferredRevenueAccountingCode;
    }

    public PricePatchRequest recurring(Recurring recurring) {
        this.recurring = recurring;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Recurring getRecurring() {
        return this.recurring;
    }

    public void setRecurring(Recurring recurring) {
        this.recurring = recurring;
    }

    public PricePatchRequest startEvent(StartEventEnum startEvent) {
        this.startEvent = startEvent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies when to start billing your customer.")
    public StartEventEnum getStartEvent() {
        return this.startEvent;
    }

    public void setStartEvent(StartEventEnum startEvent) {
        this.startEvent = startEvent;
    }

    public PricePatchRequest tiersMode(TiersModeEnum tiersMode) {
        this.tiersMode = tiersMode;
        return this;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(value="Specifies the mode for tiered prices.")
    public TiersModeEnum getTiersMode() {
        return this.tiersMode;
    }

    public void setTiersMode(TiersModeEnum tiersMode) {
        this.tiersMode = tiersMode;
    }

    public PricePatchRequest applyDiscountTo(List<ApplyDiscountToEnum> applyDiscountTo) {
        this.applyDiscountTo = applyDiscountTo;
        return this;
    }

    public PricePatchRequest addApplyDiscountToItem(ApplyDiscountToEnum applyDiscountToItem) {
        if (this.applyDiscountTo == null) {
            this.applyDiscountTo = new ArrayList<ApplyDiscountToEnum>();
        }
        this.applyDiscountTo.add(applyDiscountToItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Any combination of one_time, recurring and plan.")
    public List<ApplyDiscountToEnum> getApplyDiscountTo() {
        return this.applyDiscountTo;
    }

    public void setApplyDiscountTo(List<ApplyDiscountToEnum> applyDiscountTo) {
        this.applyDiscountTo = applyDiscountTo;
    }

    public PricePatchRequest tiers(List<Tier> tiers) {
        this.tiers = tiers;
        return this;
    }

    public PricePatchRequest addTiersItem(Tier tiersItem) {
        if (this.tiers == null) {
            this.tiers = new ArrayList<Tier>();
        }
        this.tiers.add(tiersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Price information for different tiers. When creating or updating tiered prices, you must specify this field and the `tiers_mode` field.")
    public List<Tier> getTiers() {
        return this.tiers;
    }

    public void setTiers(List<Tier> tiers) {
        this.tiers = tiers;
    }

    public PricePatchRequest taxCode(String taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A tax code identifier. If a `tax_code` of a price is not provided when you create or update a price, Zuora will treat the charged amount as non-taxable. If this code is provide, Zuora considers that this price is taxable and the charged amount will be handled accordingly.")
    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public PricePatchRequest taxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If this field is set to `true`, it indicates that amounts are inclusive of tax.")
    public Boolean getTaxInclusive() {
        return this.taxInclusive;
    }

    public void setTaxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
    }

    public PricePatchRequest unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A configured unit of measure. This field is required for per-unit prices.")
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public PricePatchRequest quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Quantity of the product to which your customers subscribe.")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public PricePatchRequest minQuantity(BigDecimal minQuantity) {
        this.minQuantity = minQuantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The minimum quantity for a price. Specify this field and the `max_quantity` field to create a range of quantities allowed in a price.")
    public BigDecimal getMinQuantity() {
        return this.minQuantity;
    }

    public void setMinQuantity(BigDecimal minQuantity) {
        this.minQuantity = minQuantity;
    }

    public PricePatchRequest maxQuantity(BigDecimal maxQuantity) {
        this.maxQuantity = maxQuantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum quantity for a price. Specify this field and the `min_quantity` field to create a range of quantities allowed in a price.")
    public BigDecimal getMaxQuantity() {
        return this.maxQuantity;
    }

    public void setMaxQuantity(BigDecimal maxQuantity) {
        this.maxQuantity = maxQuantity;
    }

    public PricePatchRequest discountLevel(DiscountLevelEnum discountLevel) {
        this.discountLevel = discountLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies at what level a discount should be applied: account, subscription, or plan.")
    public DiscountLevelEnum getDiscountLevel() {
        return this.discountLevel;
    }

    public void setDiscountLevel(DiscountLevelEnum discountLevel) {
        this.discountLevel = discountLevel;
    }

    public PricePatchRequest revenueRecognitionRule(RevenueRecognitionRuleEnum revenueRecognitionRule) {
        this.revenueRecognitionRule = revenueRecognitionRule;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Determines when to recognize the revenue for this charge. You can choose to recognize upon invoicing or daily over time.")
    public RevenueRecognitionRuleEnum getRevenueRecognitionRule() {
        return this.revenueRecognitionRule;
    }

    public void setRevenueRecognitionRule(RevenueRecognitionRuleEnum revenueRecognitionRule) {
        this.revenueRecognitionRule = revenueRecognitionRule;
    }

    public PricePatchRequest stackedDiscount(Boolean stackedDiscount) {
        this.stackedDiscount = stackedDiscount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This field is only applicable for the Percentage Discount price. This field indicates whether the discount is to be calculated as stacked discount. Possible values are as follows:        <ul>       <li>`true`: This is a stacked discount, which should be calculated by stacking with other discounts.</li>       <li> `false`: This is not a stacked discount, which should be calculated in sequence with other discounts.</li></ul> For more information, see <a href='https://knowledgecenter.zuora.com/Zuora_Billing/Products/Product_Catalog/B_Charge_Models/B_Discount_Charge_Models' target='_blank'>Stacked discounts</a>")
    public Boolean getStackedDiscount() {
        return this.stackedDiscount;
    }

    public void setStackedDiscount(Boolean stackedDiscount) {
        this.stackedDiscount = stackedDiscount;
    }

    public PricePatchRequest amounts(Map<String, BigDecimal> amounts) {
        this.amounts = amounts;
        return this;
    }

    public PricePatchRequest putAmountsItem(String key, BigDecimal amountsItem) {
        if (this.amounts == null) {
            this.amounts = new HashMap<String, BigDecimal>();
        }
        this.amounts.put(key, amountsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"USD\":10,\"GBP\":15}", value="")
    public Map<String, BigDecimal> getAmounts() {
        return this.amounts;
    }

    public void setAmounts(Map<String, BigDecimal> amounts) {
        this.amounts = amounts;
    }

    public PricePatchRequest unitAmounts(Map<String, BigDecimal> unitAmounts) {
        this.unitAmounts = unitAmounts;
        return this;
    }

    public PricePatchRequest putUnitAmountsItem(String key, BigDecimal unitAmountsItem) {
        if (this.unitAmounts == null) {
            this.unitAmounts = new HashMap<String, BigDecimal>();
        }
        this.unitAmounts.put(key, unitAmountsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"USD\":10,\"GBP\":15}", value="")
    public Map<String, BigDecimal> getUnitAmounts() {
        return this.unitAmounts;
    }

    public void setUnitAmounts(Map<String, BigDecimal> unitAmounts) {
        this.unitAmounts = unitAmounts;
    }

    public PricePatchRequest discountAmounts(Map<String, BigDecimal> discountAmounts) {
        this.discountAmounts = discountAmounts;
        return this;
    }

    public PricePatchRequest putDiscountAmountsItem(String key, BigDecimal discountAmountsItem) {
        if (this.discountAmounts == null) {
            this.discountAmounts = new HashMap<String, BigDecimal>();
        }
        this.discountAmounts.put(key, discountAmountsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"USD\":10,\"GBP\":15}", value="")
    public Map<String, BigDecimal> getDiscountAmounts() {
        return this.discountAmounts;
    }

    public void setDiscountAmounts(Map<String, BigDecimal> discountAmounts) {
        this.discountAmounts = discountAmounts;
    }

    public PricePatchRequest discountPercent(BigDecimal discountPercent) {
        this.discountPercent = discountPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Discount percent. Specify this field if you offer a percentage-based discount.")
    public BigDecimal getDiscountPercent() {
        return this.discountPercent;
    }

    public void setDiscountPercent(BigDecimal discountPercent) {
        this.discountPercent = discountPercent;
    }

    public PricePatchRequest priceBaseInterval(PriceBaseIntervalEnum priceBaseInterval) {
        this.priceBaseInterval = priceBaseInterval;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the base interval of a price. If not provided, this field defaults to `billing_period`.")
    public PriceBaseIntervalEnum getPriceBaseInterval() {
        return this.priceBaseInterval;
    }

    public void setPriceBaseInterval(PriceBaseIntervalEnum priceBaseInterval) {
        this.priceBaseInterval = priceBaseInterval;
    }

    public PricePatchRequest overage(Overage overage) {
        this.overage = overage;
        return this;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(value="")
    public Overage getOverage() {
        return this.overage;
    }

    public void setOverage(Overage overage) {
        this.overage = overage;
    }

    public PricePatchRequest revenue(Revenue revenue) {
        this.revenue = revenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Revenue getRevenue() {
        return this.revenue;
    }

    public void setRevenue(Revenue revenue) {
        this.revenue = revenue;
    }

    public PricePatchRequest accountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code defined in **Finance Settings > Configure Accounting Codes** in your Zuora tenant.")
    public String getAccountingCode() {
        return this.accountingCode;
    }

    public void setAccountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
    }

    public PricePatchRequest prepayment(Prepayment prepayment) {
        this.prepayment = prepayment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Prepayment getPrepayment() {
        return this.prepayment;
    }

    public void setPrepayment(Prepayment prepayment) {
        this.prepayment = prepayment;
    }

    public PricePatchRequest drawdown(Drawdown drawdown) {
        this.drawdown = drawdown;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Drawdown getDrawdown() {
        return this.drawdown;
    }

    public void setDrawdown(Drawdown drawdown) {
        this.drawdown = drawdown;
    }

    public PricePatchRequest taxable(Boolean taxable) {
        this.taxable = taxable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getTaxable() {
        return this.taxable;
    }

    public void setTaxable(Boolean taxable) {
        this.taxable = taxable;
    }

    public PricePatchRequest priceChangePercentage(BigDecimal priceChangePercentage) {
        this.priceChangePercentage = priceChangePercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage to increase or decrease the price of a termed subscription's renewal.")
    public BigDecimal getPriceChangePercentage() {
        return this.priceChangePercentage;
    }

    public void setPriceChangePercentage(BigDecimal priceChangePercentage) {
        this.priceChangePercentage = priceChangePercentage;
    }

    public PricePatchRequest priceChangeOption(PriceChangeOptionEnum priceChangeOption) {
        this.priceChangeOption = priceChangeOption;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Applies an automatic price change when a termed subscription is renewed.")
    public PriceChangeOptionEnum getPriceChangeOption() {
        return this.priceChangeOption;
    }

    public void setPriceChangeOption(PriceChangeOptionEnum priceChangeOption) {
        this.priceChangeOption = priceChangeOption;
    }

    public PricePatchRequest priceIncreaseOption(Boolean priceIncreaseOption) {
        this.priceIncreaseOption = priceIncreaseOption;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether to apply an automatic price change when a termed subscription is renewed.")
    public Boolean getPriceIncreaseOption() {
        return this.priceIncreaseOption;
    }

    public void setPriceIncreaseOption(Boolean priceIncreaseOption) {
        this.priceIncreaseOption = priceIncreaseOption;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PricePatchRequest pricePatchRequest = (PricePatchRequest)o;
        return Objects.equals(this.id, pricePatchRequest.id) && Objects.equals(this.updatedById, pricePatchRequest.updatedById) && Objects.equals(this.updatedTime, pricePatchRequest.updatedTime) && Objects.equals(this.createdById, pricePatchRequest.createdById) && Objects.equals(this.createdTime, pricePatchRequest.createdTime) && Objects.equals(this.customFields, pricePatchRequest.customFields) && Objects.equals(this.customObjects, pricePatchRequest.customObjects) && Objects.equals(this.name, pricePatchRequest.name) && Objects.equals(this.description, pricePatchRequest.description) && Objects.equals(this.recognizedRevenueAccountingCode, pricePatchRequest.recognizedRevenueAccountingCode) && Objects.equals(this.deferredRevenueAccountingCode, pricePatchRequest.deferredRevenueAccountingCode) && Objects.equals(this.recurring, pricePatchRequest.recurring) && Objects.equals((Object)this.startEvent, (Object)pricePatchRequest.startEvent) && Objects.equals((Object)this.tiersMode, (Object)pricePatchRequest.tiersMode) && Objects.equals(this.applyDiscountTo, pricePatchRequest.applyDiscountTo) && Objects.equals(this.tiers, pricePatchRequest.tiers) && Objects.equals(this.taxCode, pricePatchRequest.taxCode) && Objects.equals(this.taxInclusive, pricePatchRequest.taxInclusive) && Objects.equals(this.unitOfMeasure, pricePatchRequest.unitOfMeasure) && Objects.equals(this.quantity, pricePatchRequest.quantity) && Objects.equals(this.minQuantity, pricePatchRequest.minQuantity) && Objects.equals(this.maxQuantity, pricePatchRequest.maxQuantity) && Objects.equals((Object)this.discountLevel, (Object)pricePatchRequest.discountLevel) && Objects.equals((Object)this.revenueRecognitionRule, (Object)pricePatchRequest.revenueRecognitionRule) && Objects.equals(this.stackedDiscount, pricePatchRequest.stackedDiscount) && Objects.equals(this.amounts, pricePatchRequest.amounts) && Objects.equals(this.unitAmounts, pricePatchRequest.unitAmounts) && Objects.equals(this.discountAmounts, pricePatchRequest.discountAmounts) && Objects.equals(this.discountPercent, pricePatchRequest.discountPercent) && Objects.equals((Object)this.priceBaseInterval, (Object)pricePatchRequest.priceBaseInterval) && Objects.equals(this.overage, pricePatchRequest.overage) && Objects.equals(this.revenue, pricePatchRequest.revenue) && Objects.equals(this.accountingCode, pricePatchRequest.accountingCode) && Objects.equals(this.prepayment, pricePatchRequest.prepayment) && Objects.equals(this.drawdown, pricePatchRequest.drawdown) && Objects.equals(this.taxable, pricePatchRequest.taxable) && Objects.equals(this.priceChangePercentage, pricePatchRequest.priceChangePercentage) && Objects.equals((Object)this.priceChangeOption, (Object)pricePatchRequest.priceChangeOption) && Objects.equals(this.priceIncreaseOption, pricePatchRequest.priceIncreaseOption);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.name, this.description, this.recognizedRevenueAccountingCode, this.deferredRevenueAccountingCode, this.recurring, this.startEvent, this.tiersMode, this.applyDiscountTo, this.tiers, this.taxCode, this.taxInclusive, this.unitOfMeasure, this.quantity, this.minQuantity, this.maxQuantity, this.discountLevel, this.revenueRecognitionRule, this.stackedDiscount, this.amounts, this.unitAmounts, this.discountAmounts, this.discountPercent, this.priceBaseInterval, this.overage, this.revenue, this.accountingCode, this.prepayment, this.drawdown, this.taxable, this.priceChangePercentage, this.priceChangeOption, this.priceIncreaseOption});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PricePatchRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    recognizedRevenueAccountingCode: ").append(this.toIndentedString(this.recognizedRevenueAccountingCode)).append("\n");
        sb.append("    deferredRevenueAccountingCode: ").append(this.toIndentedString(this.deferredRevenueAccountingCode)).append("\n");
        sb.append("    recurring: ").append(this.toIndentedString(this.recurring)).append("\n");
        sb.append("    startEvent: ").append(this.toIndentedString((Object)this.startEvent)).append("\n");
        sb.append("    tiersMode: ").append(this.toIndentedString((Object)this.tiersMode)).append("\n");
        sb.append("    applyDiscountTo: ").append(this.toIndentedString(this.applyDiscountTo)).append("\n");
        sb.append("    tiers: ").append(this.toIndentedString(this.tiers)).append("\n");
        sb.append("    taxCode: ").append(this.toIndentedString(this.taxCode)).append("\n");
        sb.append("    taxInclusive: ").append(this.toIndentedString(this.taxInclusive)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    minQuantity: ").append(this.toIndentedString(this.minQuantity)).append("\n");
        sb.append("    maxQuantity: ").append(this.toIndentedString(this.maxQuantity)).append("\n");
        sb.append("    discountLevel: ").append(this.toIndentedString((Object)this.discountLevel)).append("\n");
        sb.append("    revenueRecognitionRule: ").append(this.toIndentedString((Object)this.revenueRecognitionRule)).append("\n");
        sb.append("    stackedDiscount: ").append(this.toIndentedString(this.stackedDiscount)).append("\n");
        sb.append("    amounts: ").append(this.toIndentedString(this.amounts)).append("\n");
        sb.append("    unitAmounts: ").append(this.toIndentedString(this.unitAmounts)).append("\n");
        sb.append("    discountAmounts: ").append(this.toIndentedString(this.discountAmounts)).append("\n");
        sb.append("    discountPercent: ").append(this.toIndentedString(this.discountPercent)).append("\n");
        sb.append("    priceBaseInterval: ").append(this.toIndentedString((Object)this.priceBaseInterval)).append("\n");
        sb.append("    overage: ").append(this.toIndentedString(this.overage)).append("\n");
        sb.append("    revenue: ").append(this.toIndentedString(this.revenue)).append("\n");
        sb.append("    accountingCode: ").append(this.toIndentedString(this.accountingCode)).append("\n");
        sb.append("    prepayment: ").append(this.toIndentedString(this.prepayment)).append("\n");
        sb.append("    drawdown: ").append(this.toIndentedString(this.drawdown)).append("\n");
        sb.append("    taxable: ").append(this.toIndentedString(this.taxable)).append("\n");
        sb.append("    priceChangePercentage: ").append(this.toIndentedString(this.priceChangePercentage)).append("\n");
        sb.append("    priceChangeOption: ").append(this.toIndentedString((Object)this.priceChangeOption)).append("\n");
        sb.append("    priceIncreaseOption: ").append(this.toIndentedString(this.priceIncreaseOption)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PriceChangeOptionEnum {
        LATEST_CATALOG_PRICING("latest_catalog_pricing"),
        PERCENTAGE("percentage"),
        NONE("none"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private PriceChangeOptionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PriceChangeOptionEnum fromValue(String value) {
            for (PriceChangeOptionEnum b : PriceChangeOptionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PriceChangeOptionEnum> {
            public void write(JsonWriter jsonWriter, PriceChangeOptionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PriceChangeOptionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PriceChangeOptionEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PriceBaseIntervalEnum {
        MONTH("month"),
        BILLING_PERIOD("billing_period"),
        WEEK("week"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private PriceBaseIntervalEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PriceBaseIntervalEnum fromValue(String value) {
            for (PriceBaseIntervalEnum b : PriceBaseIntervalEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PriceBaseIntervalEnum> {
            public void write(JsonWriter jsonWriter, PriceBaseIntervalEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PriceBaseIntervalEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PriceBaseIntervalEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RevenueRecognitionRuleEnum {
        ON_INVOICE("on_invoice"),
        DAILY_OVER_TIME("daily_over_time"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private RevenueRecognitionRuleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RevenueRecognitionRuleEnum fromValue(String value) {
            for (RevenueRecognitionRuleEnum b : RevenueRecognitionRuleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RevenueRecognitionRuleEnum> {
            public void write(JsonWriter jsonWriter, RevenueRecognitionRuleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RevenueRecognitionRuleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RevenueRecognitionRuleEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DiscountLevelEnum {
        ACCOUNT("account"),
        SUBSCRIPTION("subscription"),
        PLAN("plan"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private DiscountLevelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DiscountLevelEnum fromValue(String value) {
            for (DiscountLevelEnum b : DiscountLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DiscountLevelEnum> {
            public void write(JsonWriter jsonWriter, DiscountLevelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DiscountLevelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DiscountLevelEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ApplyDiscountToEnum {
        ONE_TIME("one_time"),
        RECURRING("recurring"),
        USAGE("usage"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ApplyDiscountToEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ApplyDiscountToEnum fromValue(String value) {
            for (ApplyDiscountToEnum b : ApplyDiscountToEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ApplyDiscountToEnum> {
            public void write(JsonWriter jsonWriter, ApplyDiscountToEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ApplyDiscountToEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ApplyDiscountToEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TiersModeEnum {
        GRADUATED("graduated"),
        VOLUME("volume"),
        HIGH_WATERMARK_VOLUME("high_watermark_volume"),
        HIGH_WATERMARK_GRADUATED("high_watermark_graduated"),
        GRADUATED_WITH_OVERAGE("graduated_with_overage"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TiersModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TiersModeEnum fromValue(String value) {
            for (TiersModeEnum b : TiersModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TiersModeEnum> {
            public void write(JsonWriter jsonWriter, TiersModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TiersModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TiersModeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StartEventEnum {
        CONTRACT_EFFECTIVE("contract_effective"),
        SERVICE_ACTIVATION("service_activation"),
        CUSTOMER_ACCEPTANCE("customer_acceptance"),
        SPECIFIC_DATE("specific_date"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StartEventEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StartEventEnum fromValue(String value) {
            for (StartEventEnum b : StartEventEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StartEventEnum> {
            public void write(JsonWriter jsonWriter, StartEventEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StartEventEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StartEventEnum.fromValue(value);
            }
        }
    }
}

