/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.ListQueryParams;
import org.openapitools.client.model.Payment;
import org.openapitools.client.model.PaymentApplyUnapplyRequest;
import org.openapitools.client.model.PaymentCreateRequest;
import org.openapitools.client.model.PaymentListResponse;
import org.openapitools.client.model.PaymentPatchRequest;

public class PaymentsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PaymentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PaymentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call applyPaymentCall(String paymentId, PaymentApplyUnapplyRequest paymentApplyUnapplyRequest, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PaymentApplyUnapplyRequest localVarPostBody = paymentApplyUnapplyRequest;
        String localVarPath = "/payments/{payment_id}/apply".replace("{payment_id}", this.localVarApiClient.escapeString(paymentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment.fields[]", paymentFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (paymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_method.fields[]", paymentMethodFields));
        }
        if (paymentAppliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_applied_to.fields[]", paymentAppliedToFields));
        }
        if (paymentAppliedToItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_applied_to_items.fields[]", paymentAppliedToItemsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call applyPaymentValidateBeforeCall(String paymentId, PaymentApplyUnapplyRequest paymentApplyUnapplyRequest, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentId == null) {
            throw new ApiException("Missing the required parameter 'paymentId' when calling applyPayment(Async)");
        }
        if (paymentApplyUnapplyRequest == null) {
            throw new ApiException("Missing the required parameter 'paymentApplyUnapplyRequest' when calling applyPayment(Async)");
        }
        return this.applyPaymentCall(paymentId, paymentApplyUnapplyRequest, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Payment> applyPaymentWithHttpInfo(String paymentId, PaymentApplyUnapplyRequest paymentApplyUnapplyRequest, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.applyPaymentValidateBeforeCall(paymentId, paymentApplyUnapplyRequest, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Payment>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call applyPaymentAsync(String paymentId, PaymentApplyUnapplyRequest paymentApplyUnapplyRequest, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Payment> _callback) throws ApiException {
        Call localVarCall = this.applyPaymentValidateBeforeCall(paymentId, paymentApplyUnapplyRequest, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Payment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ApplyPaymentParams applyPaymentParams(String paymentId, PaymentApplyUnapplyRequest paymentApplyUnapplyRequest) {
        return new ApplyPaymentParams(paymentId, paymentApplyUnapplyRequest);
    }

    public Payment applyPayment(String paymentId, PaymentApplyUnapplyRequest paymentApplyUnapplyRequest) throws ApiException {
        ApplyPaymentParams params = new ApplyPaymentParams(paymentId, paymentApplyUnapplyRequest);
        return this.executeApplyPaymentAPICall(params).getData();
    }

    public Payment applyPayment(String paymentId, PaymentApplyUnapplyRequest paymentApplyUnapplyRequest, List<String> expand) throws ApiException {
        ApplyPaymentParams params = new ApplyPaymentParams(paymentId, paymentApplyUnapplyRequest);
        params.expand(expand);
        return this.executeApplyPaymentAPICall(params).getData();
    }

    public Payment applyPayment(String paymentId, PaymentApplyUnapplyRequest paymentApplyUnapplyRequest, List<String> expand, Headers headers) throws ApiException {
        ApplyPaymentParams params = new ApplyPaymentParams(paymentId, paymentApplyUnapplyRequest).expand(expand).headers(headers);
        return this.executeApplyPaymentAPICall(params).getData();
    }

    public Payment apply(ApplyPaymentParams params) throws ApiException {
        return this.executeApplyPaymentAPICall(params).getData();
    }

    public ApiResponse<Payment> applyWithHttpInfo(ApplyPaymentParams params) throws ApiException {
        return this.executeApplyPaymentAPICall(params);
    }

    ApiResponse<Payment> executeApplyPaymentAPICall(ApplyPaymentParams params) throws ApiException {
        return this.applyPaymentWithHttpInfo(params.paymentId, params.paymentApplyUnapplyRequest, params.fields, params.paymentFields, params.accountFields, params.paymentMethodFields, params.paymentAppliedToFields, params.paymentAppliedToItemsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call cancelPaymentCall(String paymentId, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/payments/{payment_id}/cancel".replace("{payment_id}", this.localVarApiClient.escapeString(paymentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment.fields[]", paymentFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (paymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_method.fields[]", paymentMethodFields));
        }
        if (paymentAppliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_applied_to.fields[]", paymentAppliedToFields));
        }
        if (paymentAppliedToItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_applied_to_items.fields[]", paymentAppliedToItemsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelPaymentValidateBeforeCall(String paymentId, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentId == null) {
            throw new ApiException("Missing the required parameter 'paymentId' when calling cancelPayment(Async)");
        }
        return this.cancelPaymentCall(paymentId, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Payment> cancelPaymentWithHttpInfo(String paymentId, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.cancelPaymentValidateBeforeCall(paymentId, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Payment>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call cancelPaymentAsync(String paymentId, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Payment> _callback) throws ApiException {
        Call localVarCall = this.cancelPaymentValidateBeforeCall(paymentId, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Payment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelPaymentParams cancelPaymentParams(String paymentId) {
        return new CancelPaymentParams(paymentId);
    }

    public Payment cancelPayment(String paymentId) throws ApiException {
        CancelPaymentParams params = new CancelPaymentParams(paymentId);
        return this.executeCancelPaymentAPICall(params).getData();
    }

    public Payment cancelPayment(String paymentId, List<String> expand) throws ApiException {
        CancelPaymentParams params = new CancelPaymentParams(paymentId);
        params.expand(expand);
        return this.executeCancelPaymentAPICall(params).getData();
    }

    public Payment cancelPayment(String paymentId, List<String> expand, Headers headers) throws ApiException {
        CancelPaymentParams params = new CancelPaymentParams(paymentId).expand(expand).headers(headers);
        return this.executeCancelPaymentAPICall(params).getData();
    }

    public Payment cancel(CancelPaymentParams params) throws ApiException {
        return this.executeCancelPaymentAPICall(params).getData();
    }

    public ApiResponse<Payment> cancelWithHttpInfo(CancelPaymentParams params) throws ApiException {
        return this.executeCancelPaymentAPICall(params);
    }

    ApiResponse<Payment> executeCancelPaymentAPICall(CancelPaymentParams params) throws ApiException {
        return this.cancelPaymentWithHttpInfo(params.paymentId, params.fields, params.paymentFields, params.accountFields, params.paymentMethodFields, params.paymentAppliedToFields, params.paymentAppliedToItemsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call createPaymentCall(PaymentCreateRequest paymentCreateRequest, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PaymentCreateRequest localVarPostBody = paymentCreateRequest;
        String localVarPath = "/payments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment.fields[]", paymentFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (paymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_method.fields[]", paymentMethodFields));
        }
        if (paymentAppliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_applied_to.fields[]", paymentAppliedToFields));
        }
        if (paymentAppliedToItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_applied_to_items.fields[]", paymentAppliedToItemsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPaymentValidateBeforeCall(PaymentCreateRequest paymentCreateRequest, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'paymentCreateRequest' when calling createPayment(Async)");
        }
        return this.createPaymentCall(paymentCreateRequest, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Payment> createPaymentWithHttpInfo(PaymentCreateRequest paymentCreateRequest, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createPaymentValidateBeforeCall(paymentCreateRequest, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Payment>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createPaymentAsync(PaymentCreateRequest paymentCreateRequest, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Payment> _callback) throws ApiException {
        Call localVarCall = this.createPaymentValidateBeforeCall(paymentCreateRequest, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Payment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreatePaymentParams createPaymentParams(PaymentCreateRequest paymentCreateRequest) {
        return new CreatePaymentParams(paymentCreateRequest);
    }

    public Payment createPayment(PaymentCreateRequest paymentCreateRequest) throws ApiException {
        CreatePaymentParams params = new CreatePaymentParams(paymentCreateRequest);
        return this.executeCreatePaymentAPICall(params).getData();
    }

    public Payment createPayment(PaymentCreateRequest paymentCreateRequest, List<String> expand) throws ApiException {
        CreatePaymentParams params = new CreatePaymentParams(paymentCreateRequest);
        params.expand(expand);
        return this.executeCreatePaymentAPICall(params).getData();
    }

    public Payment createPayment(PaymentCreateRequest paymentCreateRequest, List<String> expand, Headers headers) throws ApiException {
        CreatePaymentParams params = new CreatePaymentParams(paymentCreateRequest).expand(expand).headers(headers);
        return this.executeCreatePaymentAPICall(params).getData();
    }

    public Payment create(CreatePaymentParams params) throws ApiException {
        return this.executeCreatePaymentAPICall(params).getData();
    }

    public ApiResponse<Payment> createWithHttpInfo(CreatePaymentParams params) throws ApiException {
        return this.executeCreatePaymentAPICall(params);
    }

    ApiResponse<Payment> executeCreatePaymentAPICall(CreatePaymentParams params) throws ApiException {
        return this.createPaymentWithHttpInfo(params.paymentCreateRequest, params.fields, params.paymentFields, params.accountFields, params.paymentMethodFields, params.paymentAppliedToFields, params.paymentAppliedToItemsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getPaymentCall(String paymentId, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/payments/{payment_id}".replace("{payment_id}", this.localVarApiClient.escapeString(paymentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment.fields[]", paymentFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (paymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_method.fields[]", paymentMethodFields));
        }
        if (paymentAppliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_applied_to.fields[]", paymentAppliedToFields));
        }
        if (paymentAppliedToItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_applied_to_items.fields[]", paymentAppliedToItemsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentValidateBeforeCall(String paymentId, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentId == null) {
            throw new ApiException("Missing the required parameter 'paymentId' when calling getPayment(Async)");
        }
        return this.getPaymentCall(paymentId, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Payment> getPaymentWithHttpInfo(String paymentId, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getPaymentValidateBeforeCall(paymentId, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Payment>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getPaymentAsync(String paymentId, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Payment> _callback) throws ApiException {
        Call localVarCall = this.getPaymentValidateBeforeCall(paymentId, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Payment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentParams getPaymentParams(String paymentId) {
        return new GetPaymentParams(paymentId);
    }

    public Payment getPayment(String paymentId) throws ApiException {
        GetPaymentParams params = new GetPaymentParams(paymentId);
        return this.executeGetPaymentAPICall(params).getData();
    }

    public Payment getPayment(String paymentId, List<String> expand) throws ApiException {
        GetPaymentParams params = new GetPaymentParams(paymentId);
        params.expand(expand);
        return this.executeGetPaymentAPICall(params).getData();
    }

    public Payment getPayment(String paymentId, List<String> expand, Headers headers) throws ApiException {
        GetPaymentParams params = new GetPaymentParams(paymentId).expand(expand).headers(headers);
        return this.executeGetPaymentAPICall(params).getData();
    }

    public Payment get(GetPaymentParams params) throws ApiException {
        return this.executeGetPaymentAPICall(params).getData();
    }

    public ApiResponse<Payment> getWithHttpInfo(GetPaymentParams params) throws ApiException {
        return this.executeGetPaymentAPICall(params);
    }

    ApiResponse<Payment> executeGetPaymentAPICall(GetPaymentParams params) throws ApiException {
        return this.getPaymentWithHttpInfo(params.paymentId, params.fields, params.paymentFields, params.accountFields, params.paymentMethodFields, params.paymentAppliedToFields, params.paymentAppliedToItemsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getPaymentsCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/payments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment.fields[]", paymentFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (paymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_method.fields[]", paymentMethodFields));
        }
        if (paymentAppliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_applied_to.fields[]", paymentAppliedToFields));
        }
        if (paymentAppliedToItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_applied_to_items.fields[]", paymentAppliedToItemsFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentsValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getPaymentsCall(cursor, expand, filter, sort, pageSize, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentListResponse> getPaymentsWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getPaymentsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getPaymentsAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<PaymentListResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentsParams getPaymentsParams() {
        return new GetPaymentsParams();
    }

    public PaymentListResponse getPayments() throws ApiException {
        GetPaymentsParams params = new GetPaymentsParams();
        return this.executeGetPaymentsAPICall(params).getData();
    }

    public PaymentListResponse getPayments(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetPaymentsParams params = new GetPaymentsParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetPaymentsAPICall(params).getData();
    }

    public PaymentListResponse getPayments(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetPaymentsParams params = new GetPaymentsParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetPaymentsAPICall(params).getData();
    }

    public PaymentListResponse list(GetPaymentsParams params) throws ApiException {
        return this.executeGetPaymentsAPICall(params).getData();
    }

    public ApiResponse<PaymentListResponse> listWithHttpInfo(GetPaymentsParams params) throws ApiException {
        return this.executeGetPaymentsAPICall(params);
    }

    ApiResponse<PaymentListResponse> executeGetPaymentsAPICall(GetPaymentsParams params) throws ApiException {
        return this.getPaymentsWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.paymentFields, params.accountFields, params.paymentMethodFields, params.paymentAppliedToFields, params.paymentAppliedToItemsFields, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call unapplyPaymentCall(String paymentId, PaymentApplyUnapplyRequest paymentApplyUnapplyRequest, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PaymentApplyUnapplyRequest localVarPostBody = paymentApplyUnapplyRequest;
        String localVarPath = "/payments/{payment_id}/unapply".replace("{payment_id}", this.localVarApiClient.escapeString(paymentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment.fields[]", paymentFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (paymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_method.fields[]", paymentMethodFields));
        }
        if (paymentAppliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_applied_to.fields[]", paymentAppliedToFields));
        }
        if (paymentAppliedToItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_applied_to_items.fields[]", paymentAppliedToItemsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unapplyPaymentValidateBeforeCall(String paymentId, PaymentApplyUnapplyRequest paymentApplyUnapplyRequest, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentId == null) {
            throw new ApiException("Missing the required parameter 'paymentId' when calling unapplyPayment(Async)");
        }
        if (paymentApplyUnapplyRequest == null) {
            throw new ApiException("Missing the required parameter 'paymentApplyUnapplyRequest' when calling unapplyPayment(Async)");
        }
        return this.unapplyPaymentCall(paymentId, paymentApplyUnapplyRequest, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Payment> unapplyPaymentWithHttpInfo(String paymentId, PaymentApplyUnapplyRequest paymentApplyUnapplyRequest, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.unapplyPaymentValidateBeforeCall(paymentId, paymentApplyUnapplyRequest, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Payment>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call unapplyPaymentAsync(String paymentId, PaymentApplyUnapplyRequest paymentApplyUnapplyRequest, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Payment> _callback) throws ApiException {
        Call localVarCall = this.unapplyPaymentValidateBeforeCall(paymentId, paymentApplyUnapplyRequest, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Payment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UnapplyPaymentParams unapplyPaymentParams(String paymentId, PaymentApplyUnapplyRequest paymentApplyUnapplyRequest) {
        return new UnapplyPaymentParams(paymentId, paymentApplyUnapplyRequest);
    }

    public Payment unapplyPayment(String paymentId, PaymentApplyUnapplyRequest paymentApplyUnapplyRequest) throws ApiException {
        UnapplyPaymentParams params = new UnapplyPaymentParams(paymentId, paymentApplyUnapplyRequest);
        return this.executeUnapplyPaymentAPICall(params).getData();
    }

    public Payment unapplyPayment(String paymentId, PaymentApplyUnapplyRequest paymentApplyUnapplyRequest, List<String> expand) throws ApiException {
        UnapplyPaymentParams params = new UnapplyPaymentParams(paymentId, paymentApplyUnapplyRequest);
        params.expand(expand);
        return this.executeUnapplyPaymentAPICall(params).getData();
    }

    public Payment unapplyPayment(String paymentId, PaymentApplyUnapplyRequest paymentApplyUnapplyRequest, List<String> expand, Headers headers) throws ApiException {
        UnapplyPaymentParams params = new UnapplyPaymentParams(paymentId, paymentApplyUnapplyRequest).expand(expand).headers(headers);
        return this.executeUnapplyPaymentAPICall(params).getData();
    }

    public Payment unapply(UnapplyPaymentParams params) throws ApiException {
        return this.executeUnapplyPaymentAPICall(params).getData();
    }

    public ApiResponse<Payment> unapplyWithHttpInfo(UnapplyPaymentParams params) throws ApiException {
        return this.executeUnapplyPaymentAPICall(params);
    }

    ApiResponse<Payment> executeUnapplyPaymentAPICall(UnapplyPaymentParams params) throws ApiException {
        return this.unapplyPaymentWithHttpInfo(params.paymentId, params.paymentApplyUnapplyRequest, params.fields, params.paymentFields, params.accountFields, params.paymentMethodFields, params.paymentAppliedToFields, params.paymentAppliedToItemsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call updatePaymentCall(String paymentId, PaymentPatchRequest paymentPatchRequest, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PaymentPatchRequest localVarPostBody = paymentPatchRequest;
        String localVarPath = "/payments/{payment_id}".replace("{payment_id}", this.localVarApiClient.escapeString(paymentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment.fields[]", paymentFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (paymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_method.fields[]", paymentMethodFields));
        }
        if (paymentAppliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_applied_to.fields[]", paymentAppliedToFields));
        }
        if (paymentAppliedToItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_applied_to_items.fields[]", paymentAppliedToItemsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updatePaymentValidateBeforeCall(String paymentId, PaymentPatchRequest paymentPatchRequest, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentId == null) {
            throw new ApiException("Missing the required parameter 'paymentId' when calling updatePayment(Async)");
        }
        if (paymentPatchRequest == null) {
            throw new ApiException("Missing the required parameter 'paymentPatchRequest' when calling updatePayment(Async)");
        }
        return this.updatePaymentCall(paymentId, paymentPatchRequest, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Payment> updatePaymentWithHttpInfo(String paymentId, PaymentPatchRequest paymentPatchRequest, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updatePaymentValidateBeforeCall(paymentId, paymentPatchRequest, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Payment>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updatePaymentAsync(String paymentId, PaymentPatchRequest paymentPatchRequest, List<String> fields, List<String> paymentFields, List<String> accountFields, List<String> paymentMethodFields, List<String> paymentAppliedToFields, List<String> paymentAppliedToItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Payment> _callback) throws ApiException {
        Call localVarCall = this.updatePaymentValidateBeforeCall(paymentId, paymentPatchRequest, fields, paymentFields, accountFields, paymentMethodFields, paymentAppliedToFields, paymentAppliedToItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Payment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdatePaymentParams updatePaymentParams(String paymentId, PaymentPatchRequest paymentPatchRequest) {
        return new UpdatePaymentParams(paymentId, paymentPatchRequest);
    }

    public Payment updatePayment(String paymentId, PaymentPatchRequest paymentPatchRequest) throws ApiException {
        UpdatePaymentParams params = new UpdatePaymentParams(paymentId, paymentPatchRequest);
        return this.executeUpdatePaymentAPICall(params).getData();
    }

    public Payment updatePayment(String paymentId, PaymentPatchRequest paymentPatchRequest, List<String> expand) throws ApiException {
        UpdatePaymentParams params = new UpdatePaymentParams(paymentId, paymentPatchRequest);
        params.expand(expand);
        return this.executeUpdatePaymentAPICall(params).getData();
    }

    public Payment updatePayment(String paymentId, PaymentPatchRequest paymentPatchRequest, List<String> expand, Headers headers) throws ApiException {
        UpdatePaymentParams params = new UpdatePaymentParams(paymentId, paymentPatchRequest).expand(expand).headers(headers);
        return this.executeUpdatePaymentAPICall(params).getData();
    }

    public Payment update(UpdatePaymentParams params) throws ApiException {
        return this.executeUpdatePaymentAPICall(params).getData();
    }

    public ApiResponse<Payment> updateWithHttpInfo(UpdatePaymentParams params) throws ApiException {
        return this.executeUpdatePaymentAPICall(params);
    }

    ApiResponse<Payment> executeUpdatePaymentAPICall(UpdatePaymentParams params) throws ApiException {
        return this.updatePaymentWithHttpInfo(params.paymentId, params.paymentPatchRequest, params.fields, params.paymentFields, params.accountFields, params.paymentMethodFields, params.paymentAppliedToFields, params.paymentAppliedToItemsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    public static class UpdatePaymentParams {
        private final String paymentId;
        private final PaymentPatchRequest paymentPatchRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentFields;
        private List<String> accountFields;
        private List<String> paymentMethodFields;
        private List<String> paymentAppliedToFields;
        private List<String> paymentAppliedToItemsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public UpdatePaymentParams(String paymentId, PaymentPatchRequest paymentPatchRequest) {
            this.paymentId = paymentId;
            this.paymentPatchRequest = paymentPatchRequest;
        }

        public UpdatePaymentParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public UpdatePaymentParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public UpdatePaymentParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public UpdatePaymentParams paymentFields(List<String> paymentFields) {
            this.paymentFields = paymentFields;
            return this;
        }

        public UpdatePaymentParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public UpdatePaymentParams paymentMethodFields(List<String> paymentMethodFields) {
            this.paymentMethodFields = paymentMethodFields;
            return this;
        }

        public UpdatePaymentParams paymentAppliedToFields(List<String> paymentAppliedToFields) {
            this.paymentAppliedToFields = paymentAppliedToFields;
            return this;
        }

        public UpdatePaymentParams paymentAppliedToItemsFields(List<String> paymentAppliedToItemsFields) {
            this.paymentAppliedToItemsFields = paymentAppliedToItemsFields;
            return this;
        }

        public UpdatePaymentParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public UpdatePaymentParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public UpdatePaymentParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class UnapplyPaymentParams {
        private final String paymentId;
        private final PaymentApplyUnapplyRequest paymentApplyUnapplyRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentFields;
        private List<String> accountFields;
        private List<String> paymentMethodFields;
        private List<String> paymentAppliedToFields;
        private List<String> paymentAppliedToItemsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public UnapplyPaymentParams(String paymentId, PaymentApplyUnapplyRequest paymentApplyUnapplyRequest) {
            this.paymentId = paymentId;
            this.paymentApplyUnapplyRequest = paymentApplyUnapplyRequest;
        }

        public UnapplyPaymentParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public UnapplyPaymentParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public UnapplyPaymentParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public UnapplyPaymentParams paymentFields(List<String> paymentFields) {
            this.paymentFields = paymentFields;
            return this;
        }

        public UnapplyPaymentParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public UnapplyPaymentParams paymentMethodFields(List<String> paymentMethodFields) {
            this.paymentMethodFields = paymentMethodFields;
            return this;
        }

        public UnapplyPaymentParams paymentAppliedToFields(List<String> paymentAppliedToFields) {
            this.paymentAppliedToFields = paymentAppliedToFields;
            return this;
        }

        public UnapplyPaymentParams paymentAppliedToItemsFields(List<String> paymentAppliedToItemsFields) {
            this.paymentAppliedToItemsFields = paymentAppliedToItemsFields;
            return this;
        }

        public UnapplyPaymentParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public UnapplyPaymentParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public UnapplyPaymentParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class GetPaymentsParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> paymentFields;
        private List<String> accountFields;
        private List<String> paymentMethodFields;
        private List<String> paymentAppliedToFields;
        private List<String> paymentAppliedToItemsFields;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetPaymentsParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetPaymentsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetPaymentsParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetPaymentsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetPaymentsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetPaymentsParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetPaymentsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetPaymentsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetPaymentsParams paymentFields(List<String> paymentFields) {
            this.paymentFields = paymentFields;
            return this;
        }

        public GetPaymentsParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public GetPaymentsParams paymentMethodFields(List<String> paymentMethodFields) {
            this.paymentMethodFields = paymentMethodFields;
            return this;
        }

        public GetPaymentsParams paymentAppliedToFields(List<String> paymentAppliedToFields) {
            this.paymentAppliedToFields = paymentAppliedToFields;
            return this;
        }

        public GetPaymentsParams paymentAppliedToItemsFields(List<String> paymentAppliedToItemsFields) {
            this.paymentAppliedToItemsFields = paymentAppliedToItemsFields;
            return this;
        }
    }

    public static class GetPaymentParams {
        private final String paymentId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentFields;
        private List<String> accountFields;
        private List<String> paymentMethodFields;
        private List<String> paymentAppliedToFields;
        private List<String> paymentAppliedToItemsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetPaymentParams(String paymentId) {
            this.paymentId = paymentId;
        }

        public GetPaymentParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetPaymentParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetPaymentParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetPaymentParams paymentFields(List<String> paymentFields) {
            this.paymentFields = paymentFields;
            return this;
        }

        public GetPaymentParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public GetPaymentParams paymentMethodFields(List<String> paymentMethodFields) {
            this.paymentMethodFields = paymentMethodFields;
            return this;
        }

        public GetPaymentParams paymentAppliedToFields(List<String> paymentAppliedToFields) {
            this.paymentAppliedToFields = paymentAppliedToFields;
            return this;
        }

        public GetPaymentParams paymentAppliedToItemsFields(List<String> paymentAppliedToItemsFields) {
            this.paymentAppliedToItemsFields = paymentAppliedToItemsFields;
            return this;
        }

        public GetPaymentParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetPaymentParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetPaymentParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class CreatePaymentParams {
        private final PaymentCreateRequest paymentCreateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentFields;
        private List<String> accountFields;
        private List<String> paymentMethodFields;
        private List<String> paymentAppliedToFields;
        private List<String> paymentAppliedToItemsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CreatePaymentParams(PaymentCreateRequest paymentCreateRequest) {
            this.paymentCreateRequest = paymentCreateRequest;
        }

        public CreatePaymentParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CreatePaymentParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreatePaymentParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreatePaymentParams paymentFields(List<String> paymentFields) {
            this.paymentFields = paymentFields;
            return this;
        }

        public CreatePaymentParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public CreatePaymentParams paymentMethodFields(List<String> paymentMethodFields) {
            this.paymentMethodFields = paymentMethodFields;
            return this;
        }

        public CreatePaymentParams paymentAppliedToFields(List<String> paymentAppliedToFields) {
            this.paymentAppliedToFields = paymentAppliedToFields;
            return this;
        }

        public CreatePaymentParams paymentAppliedToItemsFields(List<String> paymentAppliedToItemsFields) {
            this.paymentAppliedToItemsFields = paymentAppliedToItemsFields;
            return this;
        }

        public CreatePaymentParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CreatePaymentParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreatePaymentParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class CancelPaymentParams {
        private final String paymentId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentFields;
        private List<String> accountFields;
        private List<String> paymentMethodFields;
        private List<String> paymentAppliedToFields;
        private List<String> paymentAppliedToItemsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CancelPaymentParams(String paymentId) {
            this.paymentId = paymentId;
        }

        public CancelPaymentParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CancelPaymentParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CancelPaymentParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CancelPaymentParams paymentFields(List<String> paymentFields) {
            this.paymentFields = paymentFields;
            return this;
        }

        public CancelPaymentParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public CancelPaymentParams paymentMethodFields(List<String> paymentMethodFields) {
            this.paymentMethodFields = paymentMethodFields;
            return this;
        }

        public CancelPaymentParams paymentAppliedToFields(List<String> paymentAppliedToFields) {
            this.paymentAppliedToFields = paymentAppliedToFields;
            return this;
        }

        public CancelPaymentParams paymentAppliedToItemsFields(List<String> paymentAppliedToItemsFields) {
            this.paymentAppliedToItemsFields = paymentAppliedToItemsFields;
            return this;
        }

        public CancelPaymentParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CancelPaymentParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CancelPaymentParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class ApplyPaymentParams {
        private final String paymentId;
        private final PaymentApplyUnapplyRequest paymentApplyUnapplyRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentFields;
        private List<String> accountFields;
        private List<String> paymentMethodFields;
        private List<String> paymentAppliedToFields;
        private List<String> paymentAppliedToItemsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public ApplyPaymentParams(String paymentId, PaymentApplyUnapplyRequest paymentApplyUnapplyRequest) {
            this.paymentId = paymentId;
            this.paymentApplyUnapplyRequest = paymentApplyUnapplyRequest;
        }

        public ApplyPaymentParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public ApplyPaymentParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public ApplyPaymentParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public ApplyPaymentParams paymentFields(List<String> paymentFields) {
            this.paymentFields = paymentFields;
            return this;
        }

        public ApplyPaymentParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public ApplyPaymentParams paymentMethodFields(List<String> paymentMethodFields) {
            this.paymentMethodFields = paymentMethodFields;
            return this;
        }

        public ApplyPaymentParams paymentAppliedToFields(List<String> paymentAppliedToFields) {
            this.paymentAppliedToFields = paymentAppliedToFields;
            return this;
        }

        public ApplyPaymentParams paymentAppliedToItemsFields(List<String> paymentAppliedToItemsFields) {
            this.paymentAppliedToItemsFields = paymentAppliedToItemsFields;
            return this;
        }

        public ApplyPaymentParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public ApplyPaymentParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public ApplyPaymentParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

