/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum AccountingCodeCategory {
    ASSETS("Assets"),
    LIABILITIES("Liabilities"),
    EQUITY("Equity"),
    REVENUE("Revenue"),
    EXPENSES("Expenses");

    private String value;

    private AccountingCodeCategory(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccountingCodeCategory fromValue(String value) {
        for (AccountingCodeCategory b : AccountingCodeCategory.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter
    extends TypeAdapter<AccountingCodeCategory> {
        public void write(JsonWriter jsonWriter, AccountingCodeCategory enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public AccountingCodeCategory read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return AccountingCodeCategory.fromValue(value);
        }
    }
}

