/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.CustomObject;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.ListCustomObjectResponse;
import org.openapitools.client.model.ListQueryParams;

public class CustomObjectsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CustomObjectsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomObjectsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createCustomObjectCall(String customObjectType, Map<String, Object> requestBody, List<String> fields, List<String> customObjectCustomObjectTypeFields, List<String> customObjectFields, List<String> filter, Integer pageSize, List<String> expand, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Map<String, Object> localVarPostBody = requestBody;
        String localVarPath = "/custom_objects/{custom_object_type}".replace("{custom_object_type}", this.localVarApiClient.escapeString(customObjectType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (customObjectCustomObjectTypeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "custom_object[custom_object_type].fields[]", customObjectCustomObjectTypeFields));
        }
        if (customObjectFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "custom_object.fields[]", customObjectFields));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCustomObjectValidateBeforeCall(String customObjectType, Map<String, Object> requestBody, List<String> fields, List<String> customObjectCustomObjectTypeFields, List<String> customObjectFields, List<String> filter, Integer pageSize, List<String> expand, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (customObjectType == null) {
            throw new ApiException("Missing the required parameter 'customObjectType' when calling createCustomObject(Async)");
        }
        if (requestBody == null) {
            throw new ApiException("Missing the required parameter 'requestBody' when calling createCustomObject(Async)");
        }
        return this.createCustomObjectCall(customObjectType, requestBody, fields, customObjectCustomObjectTypeFields, customObjectFields, filter, pageSize, expand, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<CustomObject> createCustomObjectWithHttpInfo(String customObjectType, Map<String, Object> requestBody, List<String> fields, List<String> customObjectCustomObjectTypeFields, List<String> customObjectFields, List<String> filter, Integer pageSize, List<String> expand, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createCustomObjectValidateBeforeCall(customObjectType, requestBody, fields, customObjectCustomObjectTypeFields, customObjectFields, filter, pageSize, expand, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CustomObject>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createCustomObjectAsync(String customObjectType, Map<String, Object> requestBody, List<String> fields, List<String> customObjectCustomObjectTypeFields, List<String> customObjectFields, List<String> filter, Integer pageSize, List<String> expand, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<CustomObject> _callback) throws ApiException {
        Call localVarCall = this.createCustomObjectValidateBeforeCall(customObjectType, requestBody, fields, customObjectCustomObjectTypeFields, customObjectFields, filter, pageSize, expand, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CustomObject>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateCustomObjectParams createCustomObjectParams(String customObjectType, Map<String, Object> requestBody) {
        return new CreateCustomObjectParams(customObjectType, requestBody);
    }

    public CustomObject createCustomObject(String customObjectType, Map<String, Object> requestBody) throws ApiException {
        CreateCustomObjectParams params = new CreateCustomObjectParams(customObjectType, requestBody);
        return this.executeCreateCustomObjectAPICall(params).getData();
    }

    public CustomObject createCustomObject(String customObjectType, Map<String, Object> requestBody, List<String> expand) throws ApiException {
        CreateCustomObjectParams params = new CreateCustomObjectParams(customObjectType, requestBody);
        params.expand(expand);
        return this.executeCreateCustomObjectAPICall(params).getData();
    }

    public CustomObject createCustomObject(String customObjectType, Map<String, Object> requestBody, List<String> expand, Headers headers) throws ApiException {
        CreateCustomObjectParams params = new CreateCustomObjectParams(customObjectType, requestBody).expand(expand).headers(headers);
        return this.executeCreateCustomObjectAPICall(params).getData();
    }

    public CustomObject create(CreateCustomObjectParams params) throws ApiException {
        return this.executeCreateCustomObjectAPICall(params).getData();
    }

    public ApiResponse<CustomObject> createWithHttpInfo(CreateCustomObjectParams params) throws ApiException {
        return this.executeCreateCustomObjectAPICall(params);
    }

    ApiResponse<CustomObject> executeCreateCustomObjectAPICall(CreateCustomObjectParams params) throws ApiException {
        return this.createCustomObjectWithHttpInfo(params.customObjectType, params.requestBody, params.fields, params.customObjectCustomObjectTypeFields, params.customObjectFields, params.filter, params.pageSize, params.expand, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call deleteCustomObjectCall(String customObjectType, String customObjectId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/custom_objects/{custom_object_type}/{custom_object_id}".replace("{custom_object_type}", this.localVarApiClient.escapeString(customObjectType.toString())).replace("{custom_object_id}", this.localVarApiClient.escapeString(customObjectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCustomObjectValidateBeforeCall(String customObjectType, String customObjectId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (customObjectType == null) {
            throw new ApiException("Missing the required parameter 'customObjectType' when calling deleteCustomObject(Async)");
        }
        if (customObjectId == null) {
            throw new ApiException("Missing the required parameter 'customObjectId' when calling deleteCustomObject(Async)");
        }
        return this.deleteCustomObjectCall(customObjectType, customObjectId, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Void> deleteCustomObjectWithHttpInfo(String customObjectType, String customObjectId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deleteCustomObjectValidateBeforeCall(customObjectType, customObjectId, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteCustomObjectAsync(String customObjectType, String customObjectId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteCustomObjectValidateBeforeCall(customObjectType, customObjectId, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public DeleteCustomObjectParams deleteCustomObjectParams(String customObjectType, String customObjectId) {
        return new DeleteCustomObjectParams(customObjectType, customObjectId);
    }

    public void deleteCustomObject(String customObjectType, String customObjectId) throws ApiException {
        DeleteCustomObjectParams params = new DeleteCustomObjectParams(customObjectType, customObjectId);
        this.executeDeleteCustomObjectAPICall(params);
    }

    public void deleteCustomObject(String customObjectType, String customObjectId, Headers headers) throws ApiException {
        DeleteCustomObjectParams params = new DeleteCustomObjectParams(customObjectType, customObjectId).headers(headers);
        this.executeDeleteCustomObjectAPICall(params);
    }

    public void delete(DeleteCustomObjectParams params) throws ApiException {
        this.executeDeleteCustomObjectAPICall(params).getData();
    }

    public ApiResponse<Void> deleteWithHttpInfo(DeleteCustomObjectParams params) throws ApiException {
        return this.executeDeleteCustomObjectAPICall(params);
    }

    ApiResponse<Void> executeDeleteCustomObjectAPICall(DeleteCustomObjectParams params) throws ApiException {
        return this.deleteCustomObjectWithHttpInfo(params.customObjectType, params.customObjectId, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getCustomObjectCall(String customObjectType, String customObjectId, List<String> fields, List<String> customObjectCustomObjectTypeFields, List<String> customObjectFields, List<String> filter, Integer pageSize, List<String> expand, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/custom_objects/{custom_object_type}/{custom_object_id}".replace("{custom_object_type}", this.localVarApiClient.escapeString(customObjectType.toString())).replace("{custom_object_id}", this.localVarApiClient.escapeString(customObjectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (customObjectCustomObjectTypeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "custom_object[custom_object_type].fields[]", customObjectCustomObjectTypeFields));
        }
        if (customObjectFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "custom_object.fields[]", customObjectFields));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCustomObjectValidateBeforeCall(String customObjectType, String customObjectId, List<String> fields, List<String> customObjectCustomObjectTypeFields, List<String> customObjectFields, List<String> filter, Integer pageSize, List<String> expand, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (customObjectType == null) {
            throw new ApiException("Missing the required parameter 'customObjectType' when calling getCustomObject(Async)");
        }
        if (customObjectId == null) {
            throw new ApiException("Missing the required parameter 'customObjectId' when calling getCustomObject(Async)");
        }
        return this.getCustomObjectCall(customObjectType, customObjectId, fields, customObjectCustomObjectTypeFields, customObjectFields, filter, pageSize, expand, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<CustomObject> getCustomObjectWithHttpInfo(String customObjectType, String customObjectId, List<String> fields, List<String> customObjectCustomObjectTypeFields, List<String> customObjectFields, List<String> filter, Integer pageSize, List<String> expand, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getCustomObjectValidateBeforeCall(customObjectType, customObjectId, fields, customObjectCustomObjectTypeFields, customObjectFields, filter, pageSize, expand, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CustomObject>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getCustomObjectAsync(String customObjectType, String customObjectId, List<String> fields, List<String> customObjectCustomObjectTypeFields, List<String> customObjectFields, List<String> filter, Integer pageSize, List<String> expand, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<CustomObject> _callback) throws ApiException {
        Call localVarCall = this.getCustomObjectValidateBeforeCall(customObjectType, customObjectId, fields, customObjectCustomObjectTypeFields, customObjectFields, filter, pageSize, expand, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CustomObject>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCustomObjectParams getCustomObjectParams(String customObjectType, String customObjectId) {
        return new GetCustomObjectParams(customObjectType, customObjectId);
    }

    public CustomObject getCustomObject(String customObjectType, String customObjectId) throws ApiException {
        GetCustomObjectParams params = new GetCustomObjectParams(customObjectType, customObjectId);
        return this.executeGetCustomObjectAPICall(params).getData();
    }

    public CustomObject getCustomObject(String customObjectType, String customObjectId, List<String> expand) throws ApiException {
        GetCustomObjectParams params = new GetCustomObjectParams(customObjectType, customObjectId);
        params.expand(expand);
        return this.executeGetCustomObjectAPICall(params).getData();
    }

    public CustomObject getCustomObject(String customObjectType, String customObjectId, List<String> expand, Headers headers) throws ApiException {
        GetCustomObjectParams params = new GetCustomObjectParams(customObjectType, customObjectId).expand(expand).headers(headers);
        return this.executeGetCustomObjectAPICall(params).getData();
    }

    public CustomObject get(GetCustomObjectParams params) throws ApiException {
        return this.executeGetCustomObjectAPICall(params).getData();
    }

    public ApiResponse<CustomObject> getWithHttpInfo(GetCustomObjectParams params) throws ApiException {
        return this.executeGetCustomObjectAPICall(params);
    }

    ApiResponse<CustomObject> executeGetCustomObjectAPICall(GetCustomObjectParams params) throws ApiException {
        return this.getCustomObjectWithHttpInfo(params.customObjectType, params.customObjectId, params.fields, params.customObjectCustomObjectTypeFields, params.customObjectFields, params.filter, params.pageSize, params.expand, params.zuoraTrackId, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getCustomObjectsCall(String customObjectType, Integer pageSize, List<String> expand, String cursor, List<String> filter, List<String> sort, List<String> fields, List<String> customObjectCustomObjectTypeFields, List<String> customObjectFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/custom_objects/{custom_object_type}".replace("{custom_object_type}", this.localVarApiClient.escapeString(customObjectType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (customObjectCustomObjectTypeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "custom_object[custom_object_type].fields[]", customObjectCustomObjectTypeFields));
        }
        if (customObjectFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "custom_object.fields[]", customObjectFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCustomObjectsValidateBeforeCall(String customObjectType, Integer pageSize, List<String> expand, String cursor, List<String> filter, List<String> sort, List<String> fields, List<String> customObjectCustomObjectTypeFields, List<String> customObjectFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (customObjectType == null) {
            throw new ApiException("Missing the required parameter 'customObjectType' when calling getCustomObjects(Async)");
        }
        return this.getCustomObjectsCall(customObjectType, pageSize, expand, cursor, filter, sort, fields, customObjectCustomObjectTypeFields, customObjectFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<ListCustomObjectResponse> getCustomObjectsWithHttpInfo(String customObjectType, Integer pageSize, List<String> expand, String cursor, List<String> filter, List<String> sort, List<String> fields, List<String> customObjectCustomObjectTypeFields, List<String> customObjectFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getCustomObjectsValidateBeforeCall(customObjectType, pageSize, expand, cursor, filter, sort, fields, customObjectCustomObjectTypeFields, customObjectFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<ListCustomObjectResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getCustomObjectsAsync(String customObjectType, Integer pageSize, List<String> expand, String cursor, List<String> filter, List<String> sort, List<String> fields, List<String> customObjectCustomObjectTypeFields, List<String> customObjectFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<ListCustomObjectResponse> _callback) throws ApiException {
        Call localVarCall = this.getCustomObjectsValidateBeforeCall(customObjectType, pageSize, expand, cursor, filter, sort, fields, customObjectCustomObjectTypeFields, customObjectFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<ListCustomObjectResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCustomObjectsParams getCustomObjectsParams(String customObjectType) {
        return new GetCustomObjectsParams(customObjectType);
    }

    public ListCustomObjectResponse getCustomObjects(String customObjectType) throws ApiException {
        GetCustomObjectsParams params = new GetCustomObjectsParams(customObjectType);
        return this.executeGetCustomObjectsAPICall(params).getData();
    }

    public ListCustomObjectResponse getCustomObjects(String customObjectType, List<String> expand, String cursor, List<String> filter) throws ApiException {
        GetCustomObjectsParams params = new GetCustomObjectsParams(customObjectType);
        params.expand(expand);
        params.cursor(cursor);
        params.filter(filter);
        return this.executeGetCustomObjectsAPICall(params).getData();
    }

    public ListCustomObjectResponse getCustomObjects(String customObjectType, List<String> expand, String cursor, List<String> filter, Headers headers) throws ApiException {
        GetCustomObjectsParams params = new GetCustomObjectsParams(customObjectType).expand(expand).cursor(cursor).filter(filter).headers(headers);
        return this.executeGetCustomObjectsAPICall(params).getData();
    }

    public ListCustomObjectResponse list(GetCustomObjectsParams params) throws ApiException {
        return this.executeGetCustomObjectsAPICall(params).getData();
    }

    public ApiResponse<ListCustomObjectResponse> listWithHttpInfo(GetCustomObjectsParams params) throws ApiException {
        return this.executeGetCustomObjectsAPICall(params);
    }

    ApiResponse<ListCustomObjectResponse> executeGetCustomObjectsAPICall(GetCustomObjectsParams params) throws ApiException {
        return this.getCustomObjectsWithHttpInfo(params.customObjectType, params.pageSize, params.expand, params.cursor, params.filter, params.sort, params.fields, params.customObjectCustomObjectTypeFields, params.customObjectFields, params.zuoraTrackId, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call updateCustomObjectCall(String customObjectType, String customObjectId, Map<String, Object> requestBody, List<String> fields, List<String> customObjectCustomObjectTypeFields, List<String> customObjectFields, List<String> filter, Integer pageSize, List<String> expand, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Map<String, Object> localVarPostBody = requestBody;
        String localVarPath = "/custom_objects/{custom_object_type}/{custom_object_id}".replace("{custom_object_type}", this.localVarApiClient.escapeString(customObjectType.toString())).replace("{custom_object_id}", this.localVarApiClient.escapeString(customObjectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (customObjectCustomObjectTypeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "custom_object[custom_object_type].fields[]", customObjectCustomObjectTypeFields));
        }
        if (customObjectFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "custom_object.fields[]", customObjectFields));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateCustomObjectValidateBeforeCall(String customObjectType, String customObjectId, Map<String, Object> requestBody, List<String> fields, List<String> customObjectCustomObjectTypeFields, List<String> customObjectFields, List<String> filter, Integer pageSize, List<String> expand, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (customObjectType == null) {
            throw new ApiException("Missing the required parameter 'customObjectType' when calling updateCustomObject(Async)");
        }
        if (customObjectId == null) {
            throw new ApiException("Missing the required parameter 'customObjectId' when calling updateCustomObject(Async)");
        }
        if (requestBody == null) {
            throw new ApiException("Missing the required parameter 'requestBody' when calling updateCustomObject(Async)");
        }
        return this.updateCustomObjectCall(customObjectType, customObjectId, requestBody, fields, customObjectCustomObjectTypeFields, customObjectFields, filter, pageSize, expand, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<CustomObject> updateCustomObjectWithHttpInfo(String customObjectType, String customObjectId, Map<String, Object> requestBody, List<String> fields, List<String> customObjectCustomObjectTypeFields, List<String> customObjectFields, List<String> filter, Integer pageSize, List<String> expand, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updateCustomObjectValidateBeforeCall(customObjectType, customObjectId, requestBody, fields, customObjectCustomObjectTypeFields, customObjectFields, filter, pageSize, expand, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CustomObject>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updateCustomObjectAsync(String customObjectType, String customObjectId, Map<String, Object> requestBody, List<String> fields, List<String> customObjectCustomObjectTypeFields, List<String> customObjectFields, List<String> filter, Integer pageSize, List<String> expand, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<CustomObject> _callback) throws ApiException {
        Call localVarCall = this.updateCustomObjectValidateBeforeCall(customObjectType, customObjectId, requestBody, fields, customObjectCustomObjectTypeFields, customObjectFields, filter, pageSize, expand, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CustomObject>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateCustomObjectParams updateCustomObjectParams(String customObjectType, String customObjectId, Map<String, Object> requestBody) {
        return new UpdateCustomObjectParams(customObjectType, customObjectId, requestBody);
    }

    public CustomObject updateCustomObject(String customObjectType, String customObjectId, Map<String, Object> requestBody) throws ApiException {
        UpdateCustomObjectParams params = new UpdateCustomObjectParams(customObjectType, customObjectId, requestBody);
        return this.executeUpdateCustomObjectAPICall(params).getData();
    }

    public CustomObject updateCustomObject(String customObjectType, String customObjectId, Map<String, Object> requestBody, List<String> expand) throws ApiException {
        UpdateCustomObjectParams params = new UpdateCustomObjectParams(customObjectType, customObjectId, requestBody);
        params.expand(expand);
        return this.executeUpdateCustomObjectAPICall(params).getData();
    }

    public CustomObject updateCustomObject(String customObjectType, String customObjectId, Map<String, Object> requestBody, List<String> expand, Headers headers) throws ApiException {
        UpdateCustomObjectParams params = new UpdateCustomObjectParams(customObjectType, customObjectId, requestBody).expand(expand).headers(headers);
        return this.executeUpdateCustomObjectAPICall(params).getData();
    }

    public CustomObject update(UpdateCustomObjectParams params) throws ApiException {
        return this.executeUpdateCustomObjectAPICall(params).getData();
    }

    public ApiResponse<CustomObject> updateWithHttpInfo(UpdateCustomObjectParams params) throws ApiException {
        return this.executeUpdateCustomObjectAPICall(params);
    }

    ApiResponse<CustomObject> executeUpdateCustomObjectAPICall(UpdateCustomObjectParams params) throws ApiException {
        return this.updateCustomObjectWithHttpInfo(params.customObjectType, params.customObjectId, params.requestBody, params.fields, params.customObjectCustomObjectTypeFields, params.customObjectFields, params.filter, params.pageSize, params.expand, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    public static class UpdateCustomObjectParams {
        private final String customObjectType;
        private final String customObjectId;
        private final Map<String, Object> requestBody;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> customObjectCustomObjectTypeFields;
        private List<String> customObjectFields;
        private List<String> filter;
        private Integer pageSize;
        private List<String> expand;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public UpdateCustomObjectParams(String customObjectType, String customObjectId, Map<String, Object> requestBody) {
            this.customObjectType = customObjectType;
            this.customObjectId = customObjectId;
            this.requestBody = requestBody;
        }

        public UpdateCustomObjectParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            return this;
        }

        public UpdateCustomObjectParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public UpdateCustomObjectParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public UpdateCustomObjectParams customObjectCustomObjectTypeFields(List<String> customObjectCustomObjectTypeFields) {
            this.customObjectCustomObjectTypeFields = customObjectCustomObjectTypeFields;
            return this;
        }

        public UpdateCustomObjectParams customObjectFields(List<String> customObjectFields) {
            this.customObjectFields = customObjectFields;
            return this;
        }

        public UpdateCustomObjectParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public UpdateCustomObjectParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public UpdateCustomObjectParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }
    }

    public static class GetCustomObjectsParams {
        private final String customObjectType;
        private Headers headers;
        private ListQueryParams listQueryParams;
        private Integer pageSize;
        private List<String> expand;
        private String cursor;
        private List<String> filter;
        private List<String> sort;
        private List<String> fields;
        private List<String> customObjectCustomObjectTypeFields;
        private List<String> customObjectFields;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetCustomObjectsParams(String customObjectType) {
            this.customObjectType = customObjectType;
        }

        public GetCustomObjectsParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            return this;
        }

        public GetCustomObjectsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetCustomObjectsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetCustomObjectsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetCustomObjectsParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetCustomObjectsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetCustomObjectsParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetCustomObjectsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetCustomObjectsParams customObjectCustomObjectTypeFields(List<String> customObjectCustomObjectTypeFields) {
            this.customObjectCustomObjectTypeFields = customObjectCustomObjectTypeFields;
            return this;
        }

        public GetCustomObjectsParams customObjectFields(List<String> customObjectFields) {
            this.customObjectFields = customObjectFields;
            return this;
        }
    }

    public static class GetCustomObjectParams {
        private final String customObjectType;
        private final String customObjectId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> customObjectCustomObjectTypeFields;
        private List<String> customObjectFields;
        private List<String> filter;
        private Integer pageSize;
        private List<String> expand;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetCustomObjectParams(String customObjectType, String customObjectId) {
            this.customObjectType = customObjectType;
            this.customObjectId = customObjectId;
        }

        public GetCustomObjectParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            return this;
        }

        public GetCustomObjectParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetCustomObjectParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetCustomObjectParams customObjectCustomObjectTypeFields(List<String> customObjectCustomObjectTypeFields) {
            this.customObjectCustomObjectTypeFields = customObjectCustomObjectTypeFields;
            return this;
        }

        public GetCustomObjectParams customObjectFields(List<String> customObjectFields) {
            this.customObjectFields = customObjectFields;
            return this;
        }

        public GetCustomObjectParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetCustomObjectParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetCustomObjectParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }
    }

    public static class DeleteCustomObjectParams {
        private final String customObjectType;
        private final String customObjectId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public DeleteCustomObjectParams(String customObjectType, String customObjectId) {
            this.customObjectType = customObjectType;
            this.customObjectId = customObjectId;
        }

        public DeleteCustomObjectParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class CreateCustomObjectParams {
        private final String customObjectType;
        private final Map<String, Object> requestBody;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> customObjectCustomObjectTypeFields;
        private List<String> customObjectFields;
        private List<String> filter;
        private Integer pageSize;
        private List<String> expand;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CreateCustomObjectParams(String customObjectType, Map<String, Object> requestBody) {
            this.customObjectType = customObjectType;
            this.requestBody = requestBody;
        }

        public CreateCustomObjectParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            return this;
        }

        public CreateCustomObjectParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreateCustomObjectParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreateCustomObjectParams customObjectCustomObjectTypeFields(List<String> customObjectCustomObjectTypeFields) {
            this.customObjectCustomObjectTypeFields = customObjectCustomObjectTypeFields;
            return this;
        }

        public CreateCustomObjectParams customObjectFields(List<String> customObjectFields) {
            this.customObjectFields = customObjectFields;
            return this;
        }

        public CreateCustomObjectParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreateCustomObjectParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public CreateCustomObjectParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }
    }
}

