/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.Plan;
import org.openapitools.client.model.Product;
import org.openapitools.client.model.Subscription;
import org.openapitools.client.model.SubscriptionItemListResponse;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Subscription plan information.")
public class SubscriptionPlan {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_SUBSCRIPTION = "subscription";
    @SerializedName(value="subscription")
    private Subscription subscription;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_ID = "subscription_id";
    @SerializedName(value="subscription_id")
    private String subscriptionId;
    public static final String SERIALIZED_NAME_PRODUCT_ID = "product_id";
    @SerializedName(value="product_id")
    private String productId;
    public static final String SERIALIZED_NAME_PLAN_ID = "plan_id";
    @SerializedName(value="plan_id")
    private String planId;
    public static final String SERIALIZED_NAME_PLAN = "plan";
    @SerializedName(value="plan")
    private Plan plan;
    public static final String SERIALIZED_NAME_PRODUCT = "product";
    @SerializedName(value="product")
    private Product product;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_ITEMS = "subscription_items";
    @SerializedName(value="subscription_items")
    private SubscriptionItemListResponse subscriptionItems;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_PLAN_NUMBER = "subscription_plan_number";
    @SerializedName(value="subscription_plan_number")
    private String subscriptionPlanNumber;

    public SubscriptionPlan() {
    }

    public SubscriptionPlan(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects, SubscriptionItemListResponse subscriptionItems) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
        this.subscriptionItems = subscriptionItems;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public SubscriptionPlan customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public SubscriptionPlan putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public SubscriptionPlan subscription(Subscription subscription) {
        this.subscription = subscription;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The subscription to which this subscription plan belongs.")
    public Subscription getSubscription() {
        return this.subscription;
    }

    public void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }

    public SubscriptionPlan subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the subscription this subscription plan belongs to.")
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public SubscriptionPlan productId(String productId) {
        this.productId = productId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the product associated with this subscription plan.")
    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public SubscriptionPlan planId(String planId) {
        this.planId = planId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the plan associated with this subscription plan.")
    public String getPlanId() {
        return this.planId;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
    }

    public SubscriptionPlan plan(Plan plan) {
        this.plan = plan;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The plan object associated with this subscription plan.")
    public Plan getPlan() {
        return this.plan;
    }

    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    public SubscriptionPlan product(Product product) {
        this.product = product;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The product associated with the subscription plan.")
    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public SubscriptionPlan name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the subscription plan.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    @ApiModelProperty(value="List of subscription items.")
    public SubscriptionItemListResponse getSubscriptionItems() {
        return this.subscriptionItems;
    }

    public SubscriptionPlan subscriptionPlanNumber(String subscriptionPlanNumber) {
        this.subscriptionPlanNumber = subscriptionPlanNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getSubscriptionPlanNumber() {
        return this.subscriptionPlanNumber;
    }

    public void setSubscriptionPlanNumber(String subscriptionPlanNumber) {
        this.subscriptionPlanNumber = subscriptionPlanNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionPlan subscriptionPlan = (SubscriptionPlan)o;
        return Objects.equals(this.id, subscriptionPlan.id) && Objects.equals(this.updatedById, subscriptionPlan.updatedById) && Objects.equals(this.updatedTime, subscriptionPlan.updatedTime) && Objects.equals(this.createdById, subscriptionPlan.createdById) && Objects.equals(this.createdTime, subscriptionPlan.createdTime) && Objects.equals(this.customFields, subscriptionPlan.customFields) && Objects.equals(this.customObjects, subscriptionPlan.customObjects) && Objects.equals(this.subscription, subscriptionPlan.subscription) && Objects.equals(this.subscriptionId, subscriptionPlan.subscriptionId) && Objects.equals(this.productId, subscriptionPlan.productId) && Objects.equals(this.planId, subscriptionPlan.planId) && Objects.equals(this.plan, subscriptionPlan.plan) && Objects.equals(this.product, subscriptionPlan.product) && Objects.equals(this.name, subscriptionPlan.name) && Objects.equals(this.subscriptionItems, subscriptionPlan.subscriptionItems) && Objects.equals(this.subscriptionPlanNumber, subscriptionPlan.subscriptionPlanNumber);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.subscription, this.subscriptionId, this.productId, this.planId, this.plan, this.product, this.name, this.subscriptionItems, this.subscriptionPlanNumber);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionPlan {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    subscription: ").append(this.toIndentedString(this.subscription)).append("\n");
        sb.append("    subscriptionId: ").append(this.toIndentedString(this.subscriptionId)).append("\n");
        sb.append("    productId: ").append(this.toIndentedString(this.productId)).append("\n");
        sb.append("    planId: ").append(this.toIndentedString(this.planId)).append("\n");
        sb.append("    plan: ").append(this.toIndentedString(this.plan)).append("\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    subscriptionItems: ").append(this.toIndentedString(this.subscriptionItems)).append("\n");
        sb.append("    subscriptionPlanNumber: ").append(this.toIndentedString(this.subscriptionPlanNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

