/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.Mandate;

@ApiModel(description="If the `type` of the payment method is `cc_ref`, this hash contains details about the Credit Card Reference Transactions payment method. See [Supported payment methods](https://knowledgecenter.zuora.com/Billing/Billing_and_Payments/L_Payment_Methods/A_Supported_Payment_Methods) for payment gateways that support this type of payment method.")
public class CcRefUpdate {
    public static final String SERIALIZED_NAME_SECOND_TOKEN = "second_token";
    @SerializedName(value="second_token")
    private String secondToken;
    public static final String SERIALIZED_NAME_MANDATE = "mandate";
    @SerializedName(value="mandate")
    private Mandate mandate;

    public CcRefUpdate secondToken(String secondToken) {
        this.secondToken = secondToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A gateway unique identifier that replaces sensitive payment method data. This field is conditionally required only when `token` is being used to represent a gateway customer profile.")
    public String getSecondToken() {
        return this.secondToken;
    }

    public void setSecondToken(String secondToken) {
        this.secondToken = secondToken;
    }

    public CcRefUpdate mandate(Mandate mandate) {
        this.mandate = mandate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Mandate getMandate() {
        return this.mandate;
    }

    public void setMandate(Mandate mandate) {
        this.mandate = mandate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CcRefUpdate ccRefUpdate = (CcRefUpdate)o;
        return Objects.equals(this.secondToken, ccRefUpdate.secondToken) && Objects.equals(this.mandate, ccRefUpdate.mandate);
    }

    public int hashCode() {
        return Objects.hash(this.secondToken, this.mandate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CcRefUpdate {\n");
        sb.append("    secondToken: ").append(this.toIndentedString(this.secondToken)).append("\n");
        sb.append("    mandate: ").append(this.toIndentedString(this.mandate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

