/*
 * Decompiled with CFR 0.152.
 */
package com.zuora;

import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.api.AccountingCodesApi;
import com.zuora.api.AccountingPeriodsApi;
import com.zuora.api.AccountsApi;
import com.zuora.api.ActionsApi;
import com.zuora.api.AdjustmentsApi;
import com.zuora.api.AggregateQueriesApi;
import com.zuora.api.AttachmentsApi;
import com.zuora.api.AuthenticationApi;
import com.zuora.api.BillRunApi;
import com.zuora.api.BillingDocumentsApi;
import com.zuora.api.BillingPreviewRunApi;
import com.zuora.api.BookingDateBackfillJobApi;
import com.zuora.api.CatalogGroupsApi;
import com.zuora.api.ContactSnapshotsApi;
import com.zuora.api.ContactsApi;
import com.zuora.api.CreditMemosApi;
import com.zuora.api.CustomExchangeRatesApi;
import com.zuora.api.CustomObjectDefinitionsApi;
import com.zuora.api.CustomObjectJobsApi;
import com.zuora.api.CustomObjectRecordsApi;
import com.zuora.api.CustomPaymentMethodTypesApi;
import com.zuora.api.DataBackfillJobApi;
import com.zuora.api.DataQueriesApi;
import com.zuora.api.DebitMemosApi;
import com.zuora.api.DescribeApi;
import com.zuora.api.EInvoicingApi;
import com.zuora.api.FilesApi;
import com.zuora.api.FulfillmentsApi;
import com.zuora.api.HostedPagesApi;
import com.zuora.api.ImportsApi;
import com.zuora.api.InvoiceSchedulesApi;
import com.zuora.api.InvoicesApi;
import com.zuora.api.JournalRunsApi;
import com.zuora.api.MappingApi;
import com.zuora.api.MassUpdaterApi;
import com.zuora.api.OAuthApi;
import com.zuora.api.ObjectQueriesApi;
import com.zuora.api.OperationsApi;
import com.zuora.api.OrderActionsApi;
import com.zuora.api.OrderLineItemsApi;
import com.zuora.api.OrdersApi;
import com.zuora.api.PaymentAuthorizationApi;
import com.zuora.api.PaymentGatewayReconciliationApi;
import com.zuora.api.PaymentGatewaysApi;
import com.zuora.api.PaymentMethodSnapshotsApi;
import com.zuora.api.PaymentMethodTransactionLogsApi;
import com.zuora.api.PaymentMethodUpdaterApi;
import com.zuora.api.PaymentMethodsApi;
import com.zuora.api.PaymentRunsApi;
import com.zuora.api.PaymentSchedulesApi;
import com.zuora.api.PaymentTransactionLogsApi;
import com.zuora.api.PaymentsApi;
import com.zuora.api.ProductRatePlanChargeTiersApi;
import com.zuora.api.ProductRatePlanChargesApi;
import com.zuora.api.ProductRatePlansApi;
import com.zuora.api.ProductsApi;
import com.zuora.api.RampsApi;
import com.zuora.api.RatePlansApi;
import com.zuora.api.RefundsApi;
import com.zuora.api.RegenerateApi;
import com.zuora.api.ReportsApi;
import com.zuora.api.RsaSignaturesApi;
import com.zuora.api.SequenceSetsApi;
import com.zuora.api.SettingsApi;
import com.zuora.api.SignUpApi;
import com.zuora.api.SignedUrlApi;
import com.zuora.api.StageErrorApi;
import com.zuora.api.SubscriptionsApi;
import com.zuora.api.SummaryJournalEntriesApi;
import com.zuora.api.TaxationItemsApi;
import com.zuora.api.UploadApi;
import com.zuora.api.UsageApi;
import com.zuora.api.WorkflowsApi;
import com.zuora.api.ZuoraRevenueIntegrationApi;
import com.zuora.model.CreateTokenRequestGrantType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;

public class ZuoraClient {
    private static final Map<String, String> zuoraBaseUrls = Arrays.stream(ZuoraEnv.values()).collect(Collectors.toMap(env -> env.name(), env -> env.getBaseUrl()));
    private final String clientId;
    private final String clientSecret;
    private final String baseUrl;
    private final ApiClient apiClient;
    private final Timer timer;
    private TimerTask reinitTask;
    private String bearerToken = null;
    private final Map<String, String> defaultHeaders = new HashMap<String, String>();
    private int connectionTimeout = 65000;
    private int readTimeout = 65000;
    private int writeTimeout = 65000;

    public ZuoraClient(String clientId, String clientSecret, ZuoraEnv env) {
        this(clientId, clientSecret, env.baseUrl);
    }

    public static String getZuoraBaseUrls(String env) {
        return zuoraBaseUrls.get(env);
    }

    public ZuoraClient(String clientId, String clientSecret, String zuoraBaseUrl) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.baseUrl = zuoraBaseUrl;
        this.apiClient = new ApiClient();
        this.apiClient.setBasePath(this.baseUrl);
        this.apiClient.setConnectTimeout(this.connectionTimeout);
        this.apiClient.setReadTimeout(this.readTimeout);
        this.apiClient.setWriteTimeout(this.writeTimeout);
        this.timer = new Timer();
    }

    private ZuoraClient(String baseUrl, Map<String, String> headers) {
        this.clientId = null;
        this.clientSecret = null;
        this.baseUrl = baseUrl;
        this.timer = null;
        this.apiClient = new ApiClient();
        this.apiClient.setBasePath(this.baseUrl);
        headers.forEach(this.apiClient::addDefaultHeader);
    }

    public void setDebugging(boolean debugging) {
        this.apiClient.setDebugging(debugging);
    }

    public boolean isDebugging() {
        return this.apiClient.isDebugging();
    }

    public void addDefaultHeaders(Map<String, String> defaultHeaders) {
        this.defaultHeaders.putAll(defaultHeaders);
        defaultHeaders.forEach(this.apiClient::addDefaultHeader);
    }

    public void setZuoraVersion(String zuoraVersion) {
        this.apiClient.setZuoraVersion(zuoraVersion);
    }

    public String getZuoraVersion() {
        return this.apiClient.getZuoraVersion();
    }

    public void setEntityId(String entityId) {
        this.addDefaultHeaders(Collections.singletonMap("Zuora-Entity-Ids", entityId));
    }

    public String getEntityId() {
        return this.defaultHeaders.get("Zuora-Entity-Ids");
    }

    public void setAcceptEncoding(String acceptEncoding) {
        this.addDefaultHeaders(Collections.singletonMap("Accept-Encoding", acceptEncoding));
    }

    public String getAcceptEncoding() {
        return this.defaultHeaders.get("Accept-Encoding");
    }

    public void setContentEncoding(String contentEncoding) {
        this.addDefaultHeaders(Collections.singletonMap("Content-Encoding", contentEncoding));
    }

    public String getContentType() {
        return this.defaultHeaders.get("Content-Encoding");
    }

    public void setConnectTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        this.apiClient.setConnectTimeout(this.connectionTimeout);
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        this.apiClient.setReadTimeout(this.readTimeout);
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
        this.apiClient.setWriteTimeout(this.writeTimeout);
    }

    protected String fetchBearerToken() {
        try {
            return this.oAuthApi().createTokenApi(this.clientId, this.clientSecret, CreateTokenRequestGrantType.CLIENT_CREDENTIALS).execute().getAccessToken();
        }
        catch (ApiException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void auth() {
        String token = this.fetchBearerToken();
        this.apiClient.setBearerToken(token);
        this.setBearerToken(token);
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    protected void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    public void initialize() {
        if (this.reinitTask != null) {
            return;
        }
        this.auth();
        int reinitInterval = 600000;
        final ZuoraClient zc = this;
        this.reinitTask = new TimerTask(){

            @Override
            public void run() {
                zc.auth();
            }
        };
        this.timer.scheduleAtFixedRate(this.reinitTask, 0L, (long)reinitInterval);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public AccountingCodesApi accountingCodesApi() {
        return new AccountingCodesApi(this.apiClient);
    }

    public AccountingPeriodsApi accountingPeriodsApi() {
        return new AccountingPeriodsApi(this.apiClient);
    }

    public AccountsApi accountsApi() {
        return new AccountsApi(this.apiClient);
    }

    public ActionsApi actionsApi() {
        return new ActionsApi(this.apiClient);
    }

    public AdjustmentsApi adjustmentsApi() {
        return new AdjustmentsApi(this.apiClient);
    }

    public AggregateQueriesApi aggregateQueriesApi() {
        return new AggregateQueriesApi(this.apiClient);
    }

    public AttachmentsApi attachmentsApi() {
        return new AttachmentsApi(this.apiClient);
    }

    public AuthenticationApi authenticationApi() {
        return new AuthenticationApi(this.apiClient);
    }

    public BillingDocumentsApi billingDocumentsApi() {
        return new BillingDocumentsApi(this.apiClient);
    }

    public BillingPreviewRunApi billingPreviewRunApi() {
        return new BillingPreviewRunApi(this.apiClient);
    }

    public BillRunApi billRunApi() {
        return new BillRunApi(this.apiClient);
    }

    public BookingDateBackfillJobApi bookingDateBackfillJobApi() {
        return new BookingDateBackfillJobApi(this.apiClient);
    }

    public CatalogGroupsApi catalogGroupsApi() {
        return new CatalogGroupsApi(this.apiClient);
    }

    public ContactsApi contactsApi() {
        return new ContactsApi(this.apiClient);
    }

    public ContactSnapshotsApi contactSnapshotsApi() {
        return new ContactSnapshotsApi(this.apiClient);
    }

    public CreditMemosApi creditMemosApi() {
        return new CreditMemosApi(this.apiClient);
    }

    public CustomExchangeRatesApi customExchangeRatesApi() {
        return new CustomExchangeRatesApi(this.apiClient);
    }

    public CustomObjectDefinitionsApi customObjectDefinitionsApi() {
        return new CustomObjectDefinitionsApi(this.apiClient);
    }

    public CustomObjectJobsApi customObjectJobsApi() {
        return new CustomObjectJobsApi(this.apiClient);
    }

    public CustomObjectRecordsApi customObjectRecordsApi() {
        return new CustomObjectRecordsApi(this.apiClient);
    }

    public CustomPaymentMethodTypesApi customPaymentMethodTypesApi() {
        return new CustomPaymentMethodTypesApi(this.apiClient);
    }

    public DataBackfillJobApi dataBackfillJobApi() {
        return new DataBackfillJobApi(this.apiClient);
    }

    public DataQueriesApi dataQueriesApi() {
        return new DataQueriesApi(this.apiClient);
    }

    public DebitMemosApi debitMemosApi() {
        return new DebitMemosApi(this.apiClient);
    }

    public DescribeApi describeApi() {
        return new DescribeApi(this.apiClient);
    }

    public EInvoicingApi eInvoicingApi() {
        return new EInvoicingApi(this.apiClient);
    }

    public FilesApi filesApi() {
        return new FilesApi(this.apiClient);
    }

    public FulfillmentsApi fulfillmentsApi() {
        return new FulfillmentsApi(this.apiClient);
    }

    public HostedPagesApi hostedPagesApi() {
        return new HostedPagesApi(this.apiClient);
    }

    public ImportsApi importsApi() {
        return new ImportsApi(this.apiClient);
    }

    public InvoicesApi invoicesApi() {
        return new InvoicesApi(this.apiClient);
    }

    public InvoiceSchedulesApi invoiceSchedulesApi() {
        return new InvoiceSchedulesApi(this.apiClient);
    }

    public JournalRunsApi journalRunsApi() {
        return new JournalRunsApi(this.apiClient);
    }

    public MappingApi mappingApi() {
        return new MappingApi(this.apiClient);
    }

    public MassUpdaterApi massUpdaterApi() {
        return new MassUpdaterApi(this.apiClient);
    }

    public OAuthApi oAuthApi() {
        return new OAuthApi(this.apiClient);
    }

    public ObjectQueriesApi objectQueriesApi() {
        return new ObjectQueriesApi(this.apiClient);
    }

    public OperationsApi operationsApi() {
        return new OperationsApi(this.apiClient);
    }

    public OrderActionsApi orderActionsApi() {
        return new OrderActionsApi(this.apiClient);
    }

    public OrderLineItemsApi orderLineItemsApi() {
        return new OrderLineItemsApi(this.apiClient);
    }

    public OrdersApi ordersApi() {
        return new OrdersApi(this.apiClient);
    }

    public PaymentAuthorizationApi paymentAuthorizationApi() {
        return new PaymentAuthorizationApi(this.apiClient);
    }

    public PaymentGatewayReconciliationApi paymentGatewayReconciliationApi() {
        return new PaymentGatewayReconciliationApi(this.apiClient);
    }

    public PaymentGatewaysApi paymentGatewaysApi() {
        return new PaymentGatewaysApi(this.apiClient);
    }

    public PaymentMethodsApi paymentMethodsApi() {
        return new PaymentMethodsApi(this.apiClient);
    }

    public PaymentMethodSnapshotsApi paymentMethodSnapshotsApi() {
        return new PaymentMethodSnapshotsApi(this.apiClient);
    }

    public PaymentMethodTransactionLogsApi paymentMethodTransactionLogsApi() {
        return new PaymentMethodTransactionLogsApi(this.apiClient);
    }

    public PaymentMethodUpdaterApi paymentMethodUpdaterApi() {
        return new PaymentMethodUpdaterApi(this.apiClient);
    }

    public PaymentRunsApi paymentRunsApi() {
        return new PaymentRunsApi(this.apiClient);
    }

    public PaymentsApi paymentsApi() {
        return new PaymentsApi(this.apiClient);
    }

    public PaymentSchedulesApi paymentSchedulesApi() {
        return new PaymentSchedulesApi(this.apiClient);
    }

    public PaymentTransactionLogsApi paymentTransactionLogsApi() {
        return new PaymentTransactionLogsApi(this.apiClient);
    }

    public ProductRatePlanChargesApi productRatePlanChargesApi() {
        return new ProductRatePlanChargesApi(this.apiClient);
    }

    public ProductRatePlanChargeTiersApi productRatePlanChargeTiersApi() {
        return new ProductRatePlanChargeTiersApi(this.apiClient);
    }

    public ProductRatePlansApi productRatePlansApi() {
        return new ProductRatePlansApi(this.apiClient);
    }

    public ProductsApi productsApi() {
        return new ProductsApi(this.apiClient);
    }

    public RampsApi rampsApi() {
        return new RampsApi(this.apiClient);
    }

    public RatePlansApi ratePlansApi() {
        return new RatePlansApi(this.apiClient);
    }

    public RefundsApi refundsApi() {
        return new RefundsApi(this.apiClient);
    }

    public RegenerateApi regenerateApi() {
        return new RegenerateApi(this.apiClient);
    }

    public ReportsApi reportsApi() {
        return new ReportsApi(this.apiClient);
    }

    public RsaSignaturesApi rsaSignaturesApi() {
        return new RsaSignaturesApi(this.apiClient);
    }

    public SequenceSetsApi sequenceSetsApi() {
        return new SequenceSetsApi(this.apiClient);
    }

    public SettingsApi settingsApi() {
        return new SettingsApi(this.apiClient);
    }

    public SignedUrlApi signedUrlApi() {
        return new SignedUrlApi(this.apiClient);
    }

    public SignUpApi signUpApi() {
        return new SignUpApi(this.apiClient);
    }

    public StageErrorApi stageErrorApi() {
        return new StageErrorApi(this.apiClient);
    }

    public SubscriptionsApi subscriptionsApi() {
        return new SubscriptionsApi(this.apiClient);
    }

    public SummaryJournalEntriesApi summaryJournalEntriesApi() {
        return new SummaryJournalEntriesApi(this.apiClient);
    }

    public TaxationItemsApi taxationItemsApi() {
        return new TaxationItemsApi(this.apiClient);
    }

    public UploadApi uploadApi() {
        return new UploadApi(this.apiClient);
    }

    public UsageApi usageApi() {
        return new UsageApi(this.apiClient);
    }

    public WorkflowsApi workflowsApi() {
        return new WorkflowsApi(this.apiClient);
    }

    public ZuoraRevenueIntegrationApi zuoraRevenueIntegrationApi() {
        return new ZuoraRevenueIntegrationApi(this.apiClient);
    }

    public static enum ZuoraEnv {
        SBX("https://rest.apisandbox.zuora.com"),
        SBX_NA("https://rest.sandbox.na.zuora.com"),
        SBX_EU("https://rest.sandbox.eu.zuora.com"),
        CSBX("https://rest.test.zuora.com"),
        CSBX_EU("https://rest.test.eu.zuora.com"),
        PROD("https://rest.zuora.com"),
        PROD_NA("https://rest.na.zuora.com"),
        PROD_EU("https://rest.eu.zuora.com");

        private final String baseUrl;

        public String getBaseUrl() {
            return this.baseUrl;
        }

        private ZuoraEnv(String baseUrl) {
            this.baseUrl = baseUrl;
        }
    }
}

