/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.zevolve.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zuora.zevolve.api.model.OverageCalculationOption;
import com.zuora.zevolve.api.model.OverageSmoothingModel;
import com.zuora.zevolve.api.model.OverageUnusedUnitsCreditOption;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"includedUnits", "numberOfPeriods", "smoothingModel", "calculationOption", "unusedUnitsCreditOption"})
public class OverageOptions {
    public static final String JSON_PROPERTY_INCLUDED_UNITS = "includedUnits";
    private Double includedUnits;
    public static final String JSON_PROPERTY_NUMBER_OF_PERIODS = "numberOfPeriods";
    private Integer numberOfPeriods;
    public static final String JSON_PROPERTY_SMOOTHING_MODEL = "smoothingModel";
    private OverageSmoothingModel smoothingModel = OverageSmoothingModel.ROLLING_WINDOW;
    public static final String JSON_PROPERTY_CALCULATION_OPTION = "calculationOption";
    private OverageCalculationOption calculationOption = OverageCalculationOption.END_OF_SMOOTHING_PERIOD;
    public static final String JSON_PROPERTY_UNUSED_UNITS_CREDIT_OPTION = "unusedUnitsCreditOption";
    private OverageUnusedUnitsCreditOption unusedUnitsCreditOption = OverageUnusedUnitsCreditOption.NO_CREDIT;

    public OverageOptions() {
    }

    public OverageOptions includedUnits(Double includedUnits) {
        this.includedUnits = includedUnits;
        return this;
    }

    @Nullable
    @JsonProperty(value="includedUnits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getIncludedUnits() {
        return this.includedUnits;
    }

    @JsonProperty(value="includedUnits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludedUnits(Double includedUnits) {
        this.includedUnits = includedUnits;
    }

    public OverageOptions numberOfPeriods(Integer numberOfPeriods) {
        this.numberOfPeriods = numberOfPeriods;
        return this;
    }

    @Nullable
    @JsonProperty(value="numberOfPeriods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumberOfPeriods() {
        return this.numberOfPeriods;
    }

    @JsonProperty(value="numberOfPeriods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumberOfPeriods(Integer numberOfPeriods) {
        this.numberOfPeriods = numberOfPeriods;
    }

    public OverageOptions smoothingModel(OverageSmoothingModel smoothingModel) {
        this.smoothingModel = smoothingModel;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="smoothingModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OverageSmoothingModel getSmoothingModel() {
        return this.smoothingModel;
    }

    @JsonProperty(value="smoothingModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSmoothingModel(OverageSmoothingModel smoothingModel) {
        this.smoothingModel = smoothingModel;
    }

    public OverageOptions calculationOption(OverageCalculationOption calculationOption) {
        this.calculationOption = calculationOption;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="calculationOption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OverageCalculationOption getCalculationOption() {
        return this.calculationOption;
    }

    @JsonProperty(value="calculationOption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCalculationOption(OverageCalculationOption calculationOption) {
        this.calculationOption = calculationOption;
    }

    public OverageOptions unusedUnitsCreditOption(OverageUnusedUnitsCreditOption unusedUnitsCreditOption) {
        this.unusedUnitsCreditOption = unusedUnitsCreditOption;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="unusedUnitsCreditOption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OverageUnusedUnitsCreditOption getUnusedUnitsCreditOption() {
        return this.unusedUnitsCreditOption;
    }

    @JsonProperty(value="unusedUnitsCreditOption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnusedUnitsCreditOption(OverageUnusedUnitsCreditOption unusedUnitsCreditOption) {
        this.unusedUnitsCreditOption = unusedUnitsCreditOption;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverageOptions overageOptions = (OverageOptions)o;
        return Objects.equals(this.includedUnits, overageOptions.includedUnits) && Objects.equals(this.numberOfPeriods, overageOptions.numberOfPeriods) && Objects.equals((Object)this.smoothingModel, (Object)overageOptions.smoothingModel) && Objects.equals((Object)this.calculationOption, (Object)overageOptions.calculationOption) && Objects.equals((Object)this.unusedUnitsCreditOption, (Object)overageOptions.unusedUnitsCreditOption);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.includedUnits, this.numberOfPeriods, this.smoothingModel, this.calculationOption, this.unusedUnitsCreditOption});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OverageOptions {\n");
        sb.append("    includedUnits: ").append(this.toIndentedString(this.includedUnits)).append("\n");
        sb.append("    numberOfPeriods: ").append(this.toIndentedString(this.numberOfPeriods)).append("\n");
        sb.append("    smoothingModel: ").append(this.toIndentedString((Object)this.smoothingModel)).append("\n");
        sb.append("    calculationOption: ").append(this.toIndentedString((Object)this.calculationOption)).append("\n");
        sb.append("    unusedUnitsCreditOption: ").append(this.toIndentedString((Object)this.unusedUnitsCreditOption)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static OverageOptionsBuilder builder() {
        return new OverageOptionsBuilder();
    }

    public OverageOptions(Double includedUnits, Integer numberOfPeriods, OverageSmoothingModel smoothingModel, OverageCalculationOption calculationOption, OverageUnusedUnitsCreditOption unusedUnitsCreditOption) {
        this.includedUnits = includedUnits;
        this.numberOfPeriods = numberOfPeriods;
        this.smoothingModel = smoothingModel;
        this.calculationOption = calculationOption;
        this.unusedUnitsCreditOption = unusedUnitsCreditOption;
    }

    public static class OverageOptionsBuilder {
        private Double includedUnits;
        private Integer numberOfPeriods;
        private OverageSmoothingModel smoothingModel;
        private OverageCalculationOption calculationOption;
        private OverageUnusedUnitsCreditOption unusedUnitsCreditOption;

        OverageOptionsBuilder() {
        }

        public OverageOptionsBuilder includedUnits(Double includedUnits) {
            this.includedUnits = includedUnits;
            return this;
        }

        public OverageOptionsBuilder numberOfPeriods(Integer numberOfPeriods) {
            this.numberOfPeriods = numberOfPeriods;
            return this;
        }

        public OverageOptionsBuilder smoothingModel(OverageSmoothingModel smoothingModel) {
            this.smoothingModel = smoothingModel;
            return this;
        }

        public OverageOptionsBuilder calculationOption(OverageCalculationOption calculationOption) {
            this.calculationOption = calculationOption;
            return this;
        }

        public OverageOptionsBuilder unusedUnitsCreditOption(OverageUnusedUnitsCreditOption unusedUnitsCreditOption) {
            this.unusedUnitsCreditOption = unusedUnitsCreditOption;
            return this;
        }

        public OverageOptions build() {
            return new OverageOptions(this.includedUnits, this.numberOfPeriods, this.smoothingModel, this.calculationOption, this.unusedUnitsCreditOption);
        }

        public String toString() {
            return "OverageOptions.OverageOptionsBuilder(includedUnits=" + this.includedUnits + ", numberOfPeriods=" + this.numberOfPeriods + ", smoothingModel=" + this.smoothingModel + ", calculationOption=" + this.calculationOption + ", unusedUnitsCreditOption=" + this.unusedUnitsCreditOption + ")";
        }
    }
}

