/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.zevolve.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zuora.zevolve.api.model.BillCyclePeriod;
import com.zuora.zevolve.api.model.BillCyclePeriodAlignment;
import com.zuora.zevolve.api.model.BillCycleTiming;
import com.zuora.zevolve.api.model.BillCycleType;
import com.zuora.zevolve.api.model.DayOfWeek;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"type", "dayOfMonth", "dayOfWeek", "period", "specificPeriod", "periodAlignment", "timing"})
public class BillCycle {
    public static final String JSON_PROPERTY_TYPE = "type";
    private BillCycleType type = BillCycleType.DEFAULT_FROM_CUSTOMER;
    public static final String JSON_PROPERTY_DAY_OF_MONTH = "dayOfMonth";
    private Integer dayOfMonth;
    public static final String JSON_PROPERTY_DAY_OF_WEEK = "dayOfWeek";
    private DayOfWeek dayOfWeek = DayOfWeek.DAY_OF_WEEK_UNSPECIFIED;
    public static final String JSON_PROPERTY_PERIOD = "period";
    private BillCyclePeriod period = BillCyclePeriod.UNDEFINED;
    public static final String JSON_PROPERTY_SPECIFIC_PERIOD = "specificPeriod";
    private String specificPeriod;
    public static final String JSON_PROPERTY_PERIOD_ALIGNMENT = "periodAlignment";
    private BillCyclePeriodAlignment periodAlignment = BillCyclePeriodAlignment.UNSPECIFIED;
    public static final String JSON_PROPERTY_TIMING = "timing";
    private BillCycleTiming timing = BillCycleTiming.IN_ADVANCE;

    public BillCycle() {
    }

    public BillCycle type(BillCycleType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BillCycleType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(BillCycleType type) {
        this.type = type;
    }

    public BillCycle dayOfMonth(Integer dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
        return this;
    }

    @Nullable
    @JsonProperty(value="dayOfMonth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getDayOfMonth() {
        return this.dayOfMonth;
    }

    @JsonProperty(value="dayOfMonth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDayOfMonth(Integer dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public BillCycle dayOfWeek(DayOfWeek dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="dayOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DayOfWeek getDayOfWeek() {
        return this.dayOfWeek;
    }

    @JsonProperty(value="dayOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDayOfWeek(DayOfWeek dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public BillCycle period(BillCyclePeriod period) {
        this.period = period;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="period")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BillCyclePeriod getPeriod() {
        return this.period;
    }

    @JsonProperty(value="period")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPeriod(BillCyclePeriod period) {
        this.period = period;
    }

    public BillCycle specificPeriod(String specificPeriod) {
        this.specificPeriod = specificPeriod;
        return this;
    }

    @Nullable
    @JsonProperty(value="specificPeriod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSpecificPeriod() {
        return this.specificPeriod;
    }

    @JsonProperty(value="specificPeriod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSpecificPeriod(String specificPeriod) {
        this.specificPeriod = specificPeriod;
    }

    public BillCycle periodAlignment(BillCyclePeriodAlignment periodAlignment) {
        this.periodAlignment = periodAlignment;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="periodAlignment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BillCyclePeriodAlignment getPeriodAlignment() {
        return this.periodAlignment;
    }

    @JsonProperty(value="periodAlignment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPeriodAlignment(BillCyclePeriodAlignment periodAlignment) {
        this.periodAlignment = periodAlignment;
    }

    public BillCycle timing(BillCycleTiming timing) {
        this.timing = timing;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="timing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BillCycleTiming getTiming() {
        return this.timing;
    }

    @JsonProperty(value="timing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTiming(BillCycleTiming timing) {
        this.timing = timing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillCycle billCycle = (BillCycle)o;
        return Objects.equals((Object)this.type, (Object)billCycle.type) && Objects.equals(this.dayOfMonth, billCycle.dayOfMonth) && Objects.equals((Object)this.dayOfWeek, (Object)billCycle.dayOfWeek) && Objects.equals((Object)this.period, (Object)billCycle.period) && Objects.equals(this.specificPeriod, billCycle.specificPeriod) && Objects.equals((Object)this.periodAlignment, (Object)billCycle.periodAlignment) && Objects.equals((Object)this.timing, (Object)billCycle.timing);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.dayOfMonth, this.dayOfWeek, this.period, this.specificPeriod, this.periodAlignment, this.timing});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillCycle {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    dayOfMonth: ").append(this.toIndentedString(this.dayOfMonth)).append("\n");
        sb.append("    dayOfWeek: ").append(this.toIndentedString((Object)this.dayOfWeek)).append("\n");
        sb.append("    period: ").append(this.toIndentedString((Object)this.period)).append("\n");
        sb.append("    specificPeriod: ").append(this.toIndentedString(this.specificPeriod)).append("\n");
        sb.append("    periodAlignment: ").append(this.toIndentedString((Object)this.periodAlignment)).append("\n");
        sb.append("    timing: ").append(this.toIndentedString((Object)this.timing)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BillCycleBuilder builder() {
        return new BillCycleBuilder();
    }

    public BillCycle(BillCycleType type, Integer dayOfMonth, DayOfWeek dayOfWeek, BillCyclePeriod period, String specificPeriod, BillCyclePeriodAlignment periodAlignment, BillCycleTiming timing) {
        this.type = type;
        this.dayOfMonth = dayOfMonth;
        this.dayOfWeek = dayOfWeek;
        this.period = period;
        this.specificPeriod = specificPeriod;
        this.periodAlignment = periodAlignment;
        this.timing = timing;
    }

    public static class BillCycleBuilder {
        private BillCycleType type;
        private Integer dayOfMonth;
        private DayOfWeek dayOfWeek;
        private BillCyclePeriod period;
        private String specificPeriod;
        private BillCyclePeriodAlignment periodAlignment;
        private BillCycleTiming timing;

        BillCycleBuilder() {
        }

        public BillCycleBuilder type(BillCycleType type) {
            this.type = type;
            return this;
        }

        public BillCycleBuilder dayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        public BillCycleBuilder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        public BillCycleBuilder period(BillCyclePeriod period) {
            this.period = period;
            return this;
        }

        public BillCycleBuilder specificPeriod(String specificPeriod) {
            this.specificPeriod = specificPeriod;
            return this;
        }

        public BillCycleBuilder periodAlignment(BillCyclePeriodAlignment periodAlignment) {
            this.periodAlignment = periodAlignment;
            return this;
        }

        public BillCycleBuilder timing(BillCycleTiming timing) {
            this.timing = timing;
            return this;
        }

        public BillCycle build() {
            return new BillCycle(this.type, this.dayOfMonth, this.dayOfWeek, this.period, this.specificPeriod, this.periodAlignment, this.timing);
        }

        public String toString() {
            return "BillCycle.BillCycleBuilder(type=" + this.type + ", dayOfMonth=" + this.dayOfMonth + ", dayOfWeek=" + this.dayOfWeek + ", period=" + this.period + ", specificPeriod=" + this.specificPeriod + ", periodAlignment=" + this.periodAlignment + ", timing=" + this.timing + ")";
        }
    }
}

