/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog.charge.recurring;

import com.zuora.sdk.catalog.charge.Amount;
import com.zuora.sdk.catalog.charge.Billing;
import com.zuora.sdk.catalog.charge.SubscriptionRenewalOptions;
import com.zuora.sdk.catalog.charge.Taxation;
import com.zuora.sdk.catalog.charge.recurring.RecurringCharge;
import com.zuora.zevolve.api.model.Accounting;
import com.zuora.zevolve.api.model.ChargeModel;
import com.zuora.zevolve.api.model.ChargeType;
import com.zuora.zevolve.api.model.DeliverySchedule;
import com.zuora.zevolve.api.model.Drawdown;
import com.zuora.zevolve.api.model.EndDateCondition;
import com.zuora.zevolve.api.model.ListPriceBase;
import com.zuora.zevolve.api.model.Netsuite;
import com.zuora.zevolve.api.model.Prepayment;
import com.zuora.zevolve.api.model.Pricing;
import com.zuora.zevolve.api.model.ProductRatePlanChargeRequest;
import com.zuora.zevolve.api.model.Revenue;
import com.zuora.zevolve.api.model.TriggerEvent;
import com.zuora.zevolve.api.model.UpToPeriodsType;
import com.zuora.zevolve.api.model.Value;
import java.util.ArrayList;
import java.util.List;

public final class FlatFee
extends RecurringCharge {
    private final List<Amount> amounts = new ArrayList<Amount>();

    static FlatFee newInstance() {
        return new FlatFee();
    }

    public FlatFee withName(String name) {
        this.name = name;
        return this;
    }

    protected FlatFee with(DeliverySchedule deliverySchedule) {
        this.deliverySchedule = deliverySchedule;
        return this;
    }

    public FlatFee with(Billing billing) {
        this.billing = billing;
        return this;
    }

    public FlatFee with(TriggerEvent event) {
        this.triggerEvent = event;
        return this;
    }

    protected FlatFee with(Accounting accounting) {
        this.accounting = accounting;
        return this;
    }

    public FlatFee with(Revenue revenue) {
        this.revenue = revenue;
        return this;
    }

    public FlatFee with(Taxation taxation) {
        this.taxation = taxation;
        return this;
    }

    public FlatFee with(Netsuite netsuite) {
        this.netsuite = netsuite;
        return this;
    }

    protected FlatFee with(SubscriptionRenewalOptions options) {
        this.renewalOptions = options;
        return this;
    }

    public FlatFee with(EndDateCondition condition) {
        this.endDateCondition = condition;
        return this;
    }

    public FlatFee with(Integer periods, UpToPeriodsType periodsType) {
        this.upToPeriods = periods;
        this.upToPeriodsType = periodsType;
        return this;
    }

    public FlatFee with(ListPriceBase listPriceBase) {
        this.listPriceBase = listPriceBase;
        return this;
    }

    public FlatFee with(Amount amount) {
        this.and(amount);
        return this;
    }

    public FlatFee with(Prepayment prepayment) {
        this.prepayment = prepayment;
        return this;
    }

    public FlatFee with(Drawdown drawdown) {
        this.drawdown = drawdown;
        return this;
    }

    public FlatFee withCustomField(String name, Value value) {
        this.customFields.put(name, value);
        return this;
    }

    protected FlatFee withSpecificListPriceBase(Integer specificListPriceBase) {
        this.specificListPriceBase = specificListPriceBase;
        return this;
    }

    public FlatFee and(Amount amount) {
        if (amount != null) {
            this.amounts.add(amount);
        }
        return this;
    }

    @Override
    public ProductRatePlanChargeRequest toApi(ProductRatePlanChargeRequest.ProductRatePlanChargeRequestBuilder builder) {
        return builder.chargeType(ChargeType.RECURRING).chargeModel(ChargeModel.FLAT_FEE).pricing(Pricing.builder().flatAmounts(Amount.toApiMap(this.amounts)).build()).build();
    }
}

