/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog;

import com.fasterxml.jackson.core.util.VersionUtil;
import com.zuora.sdk.Zuora;
import com.zuora.sdk.catalog.CatalogSupport;
import com.zuora.sdk.catalog.ChargeDefinitionsService;
import com.zuora.sdk.catalog.ChargesService;
import com.zuora.sdk.catalog.DiscountsService;
import com.zuora.sdk.catalog.FeaturesService;
import com.zuora.sdk.catalog.PlanDefinitionsService;
import com.zuora.sdk.catalog.PlansService;
import com.zuora.sdk.catalog.ProductsService;
import com.zuora.sdk.catalog.SurchargeService;
import com.zuora.sdk.http.HttpClientProvider;
import com.zuora.sdk.http.HttpSupport;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class Catalog {
    private static final String PROXY_PREFIX = "commerce";
    private static final String ZUORA_ENTITY_IDS = "Zuora-Entity-Ids";
    private static final String ZUORA_ORG_IDS = "Zuora-Org-Ids";
    private final HttpSupport httpSupport;
    private final CatalogSupport catalogSupport;
    private final ProductsService products;
    private final PlansService plans;
    private final ChargesService charges;
    private final DiscountsService discounts;
    private final FeaturesService features;
    private final ChargeDefinitionsService chargeDefinitions;
    private final PlanDefinitionsService planDefinitions;
    private final SurchargeService surcharges;
    private static String sdkVersion;

    public static String getUserAgent() {
        return "zuora-java-sdk:catalog:" + sdkVersion;
    }

    public Catalog(Zuora zuora) {
        this(zuora, null, null);
    }

    public Catalog(Zuora zuora, String entityId) {
        this(zuora, entityId, null);
    }

    public Catalog(Zuora zuora, List<String> orgIds) {
        this(zuora, null, orgIds);
    }

    public Catalog(Zuora zuora, String entityId, List<String> orgIds) {
        this.httpSupport = new HttpSupport(zuora.getConfiguration(), () -> {
            Map headers = zuora.getAuthenticationProvider().getAuthHeaders();
            if (entityId != null && !entityId.trim().isEmpty()) {
                headers.put(ZUORA_ENTITY_IDS, entityId);
            }
            if (orgIds != null && !orgIds.isEmpty()) {
                headers.put(ZUORA_ORG_IDS, orgIds.stream().filter(v -> v != null && !v.trim().isEmpty()).collect(Collectors.joining(",")));
            }
            return headers;
        }, new HttpClientProvider(zuora));
        this.catalogSupport = new CatalogSupport(this.httpSupport);
        this.products = new ProductsService(zuora, this.catalogSupport, this.httpSupport);
        this.plans = new PlansService(zuora, this.catalogSupport, this.httpSupport);
        this.charges = new ChargesService(zuora, this.catalogSupport, this.httpSupport);
        this.discounts = new DiscountsService(this.httpSupport);
        this.features = new FeaturesService(this.httpSupport);
        this.chargeDefinitions = new ChargeDefinitionsService(this.httpSupport);
        this.planDefinitions = new PlanDefinitionsService(this.httpSupport);
        this.surcharges = new SurchargeService(this.httpSupport);
    }

    public static String getPathPrefix() {
        return String.format("/%s", PROXY_PREFIX);
    }

    public ProductsService products() {
        return this.products;
    }

    public PlansService plans() {
        return this.plans;
    }

    public ChargesService charges() {
        return this.charges;
    }

    public DiscountsService discounts() {
        return this.discounts;
    }

    public FeaturesService features() {
        return this.features;
    }

    public ChargeDefinitionsService chargeDefinitions() {
        return this.chargeDefinitions;
    }

    public PlanDefinitionsService planDefinitions() {
        return this.planDefinitions;
    }

    protected SurchargeService surcharges() {
        return this.surcharges;
    }

    public void close() {
        this.httpSupport.close();
    }

    static {
        block9: {
            Properties properties = new Properties();
            try (InputStream inputStream = VersionUtil.class.getResourceAsStream("/META-INF/version.properties");){
                if (inputStream != null) {
                    properties.load(inputStream);
                    sdkVersion = properties.getProperty("version");
                    break block9;
                }
                throw new IOException("version.properties file not found");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

