/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.zevolve.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zuora.zevolve.api.model.Tier;
import com.zuora.zevolve.api.model.TierMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"flatAmounts", "unitAmounts", "tiers", "tierMode", "discountAmounts", "discountPercentage"})
public class Pricing {
    public static final String JSON_PROPERTY_FLAT_AMOUNTS = "flatAmounts";
    private Map<String, Double> flatAmounts = new HashMap<String, Double>();
    public static final String JSON_PROPERTY_UNIT_AMOUNTS = "unitAmounts";
    private Map<String, Double> unitAmounts = new HashMap<String, Double>();
    public static final String JSON_PROPERTY_TIERS = "tiers";
    private List<@Valid Tier> tiers = new ArrayList<Tier>();
    public static final String JSON_PROPERTY_TIER_MODE = "tierMode";
    private TierMode tierMode = TierMode.UNSPECIFIED;
    public static final String JSON_PROPERTY_DISCOUNT_AMOUNTS = "discountAmounts";
    private Map<String, Double> discountAmounts = new HashMap<String, Double>();
    public static final String JSON_PROPERTY_DISCOUNT_PERCENTAGE = "discountPercentage";
    private Double discountPercentage;

    public Pricing() {
    }

    public Pricing flatAmounts(Map<String, Double> flatAmounts) {
        this.flatAmounts = flatAmounts;
        return this;
    }

    public Pricing putFlatAmountsItem(String key, Double flatAmountsItem) {
        if (this.flatAmounts == null) {
            this.flatAmounts = new HashMap<String, Double>();
        }
        this.flatAmounts.put(key, flatAmountsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="flatAmounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Double> getFlatAmounts() {
        return this.flatAmounts;
    }

    @JsonProperty(value="flatAmounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFlatAmounts(Map<String, Double> flatAmounts) {
        this.flatAmounts = flatAmounts;
    }

    public Pricing unitAmounts(Map<String, Double> unitAmounts) {
        this.unitAmounts = unitAmounts;
        return this;
    }

    public Pricing putUnitAmountsItem(String key, Double unitAmountsItem) {
        if (this.unitAmounts == null) {
            this.unitAmounts = new HashMap<String, Double>();
        }
        this.unitAmounts.put(key, unitAmountsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="unitAmounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Double> getUnitAmounts() {
        return this.unitAmounts;
    }

    @JsonProperty(value="unitAmounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnitAmounts(Map<String, Double> unitAmounts) {
        this.unitAmounts = unitAmounts;
    }

    public Pricing tiers(List<@Valid Tier> tiers) {
        this.tiers = tiers;
        return this;
    }

    public Pricing addTiersItem(Tier tiersItem) {
        if (this.tiers == null) {
            this.tiers = new ArrayList<Tier>();
        }
        this.tiers.add(tiersItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="tiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid Tier> getTiers() {
        return this.tiers;
    }

    @JsonProperty(value="tiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTiers(List<@Valid Tier> tiers) {
        this.tiers = tiers;
    }

    public Pricing tierMode(TierMode tierMode) {
        this.tierMode = tierMode;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="tierMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TierMode getTierMode() {
        return this.tierMode;
    }

    @JsonProperty(value="tierMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTierMode(TierMode tierMode) {
        this.tierMode = tierMode;
    }

    public Pricing discountAmounts(Map<String, Double> discountAmounts) {
        this.discountAmounts = discountAmounts;
        return this;
    }

    public Pricing putDiscountAmountsItem(String key, Double discountAmountsItem) {
        if (this.discountAmounts == null) {
            this.discountAmounts = new HashMap<String, Double>();
        }
        this.discountAmounts.put(key, discountAmountsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="discountAmounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Double> getDiscountAmounts() {
        return this.discountAmounts;
    }

    @JsonProperty(value="discountAmounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDiscountAmounts(Map<String, Double> discountAmounts) {
        this.discountAmounts = discountAmounts;
    }

    public Pricing discountPercentage(Double discountPercentage) {
        this.discountPercentage = discountPercentage;
        return this;
    }

    @Nullable
    @JsonProperty(value="discountPercentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getDiscountPercentage() {
        return this.discountPercentage;
    }

    @JsonProperty(value="discountPercentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDiscountPercentage(Double discountPercentage) {
        this.discountPercentage = discountPercentage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pricing pricing = (Pricing)o;
        return Objects.equals(this.flatAmounts, pricing.flatAmounts) && Objects.equals(this.unitAmounts, pricing.unitAmounts) && Objects.equals(this.tiers, pricing.tiers) && Objects.equals((Object)this.tierMode, (Object)pricing.tierMode) && Objects.equals(this.discountAmounts, pricing.discountAmounts) && Objects.equals(this.discountPercentage, pricing.discountPercentage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.flatAmounts, this.unitAmounts, this.tiers, this.tierMode, this.discountAmounts, this.discountPercentage});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Pricing {\n");
        sb.append("    flatAmounts: ").append(this.toIndentedString(this.flatAmounts)).append("\n");
        sb.append("    unitAmounts: ").append(this.toIndentedString(this.unitAmounts)).append("\n");
        sb.append("    tiers: ").append(this.toIndentedString(this.tiers)).append("\n");
        sb.append("    tierMode: ").append(this.toIndentedString((Object)this.tierMode)).append("\n");
        sb.append("    discountAmounts: ").append(this.toIndentedString(this.discountAmounts)).append("\n");
        sb.append("    discountPercentage: ").append(this.toIndentedString(this.discountPercentage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PricingBuilder builder() {
        return new PricingBuilder();
    }

    public Pricing(Map<String, Double> flatAmounts, Map<String, Double> unitAmounts, List<@Valid Tier> tiers, TierMode tierMode, Map<String, Double> discountAmounts, Double discountPercentage) {
        this.flatAmounts = flatAmounts;
        this.unitAmounts = unitAmounts;
        this.tiers = tiers;
        this.tierMode = tierMode;
        this.discountAmounts = discountAmounts;
        this.discountPercentage = discountPercentage;
    }

    public static class PricingBuilder {
        private Map<String, Double> flatAmounts;
        private Map<String, Double> unitAmounts;
        private List<@Valid Tier> tiers;
        private TierMode tierMode;
        private Map<String, Double> discountAmounts;
        private Double discountPercentage;

        PricingBuilder() {
        }

        public PricingBuilder flatAmounts(Map<String, Double> flatAmounts) {
            this.flatAmounts = flatAmounts;
            return this;
        }

        public PricingBuilder unitAmounts(Map<String, Double> unitAmounts) {
            this.unitAmounts = unitAmounts;
            return this;
        }

        public PricingBuilder tiers(List<@Valid Tier> tiers) {
            this.tiers = tiers;
            return this;
        }

        public PricingBuilder tierMode(TierMode tierMode) {
            this.tierMode = tierMode;
            return this;
        }

        public PricingBuilder discountAmounts(Map<String, Double> discountAmounts) {
            this.discountAmounts = discountAmounts;
            return this;
        }

        public PricingBuilder discountPercentage(Double discountPercentage) {
            this.discountPercentage = discountPercentage;
            return this;
        }

        public Pricing build() {
            return new Pricing(this.flatAmounts, this.unitAmounts, this.tiers, this.tierMode, this.discountAmounts, this.discountPercentage);
        }

        public String toString() {
            return "Pricing.PricingBuilder(flatAmounts=" + this.flatAmounts + ", unitAmounts=" + this.unitAmounts + ", tiers=" + this.tiers + ", tierMode=" + this.tierMode + ", discountAmounts=" + this.discountAmounts + ", discountPercentage=" + this.discountPercentage + ")";
        }
    }
}

