/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.zevolve.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zuora.zevolve.api.model.BillCycle;
import com.zuora.zevolve.api.model.ChargeType;
import com.zuora.zevolve.api.model.DiscountAccounting;
import com.zuora.zevolve.api.model.DiscountChargeModel;
import com.zuora.zevolve.api.model.DiscountLevel;
import com.zuora.zevolve.api.model.DiscountType;
import com.zuora.zevolve.api.model.EndDateCondition;
import com.zuora.zevolve.api.model.UpToPeriodsType;
import com.zuora.zevolve.api.model.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"discountNumber", "name", "description", "applyTo", "billCycle", "chargeModel", "type", "discountLevel", "endDateCondition", "discountClass", "stackedDiscount", "amounts", "percent", "upToPeriodsType", "upToPeriods", "customFields", "accounting", "productRatePlanId", "productRatePlanNumber"})
public class DiscountRequest {
    public static final String JSON_PROPERTY_DISCOUNT_NUMBER = "discountNumber";
    private String discountNumber;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_APPLY_TO = "applyTo";
    private List<ChargeType> applyTo = new ArrayList<ChargeType>();
    public static final String JSON_PROPERTY_BILL_CYCLE = "billCycle";
    private BillCycle billCycle;
    public static final String JSON_PROPERTY_CHARGE_MODEL = "chargeModel";
    private DiscountChargeModel chargeModel = DiscountChargeModel.FIXED_AMOUNT;
    public static final String JSON_PROPERTY_TYPE = "type";
    private DiscountType type = DiscountType.ONE_TIME_DISCOUNT;
    public static final String JSON_PROPERTY_DISCOUNT_LEVEL = "discountLevel";
    private DiscountLevel discountLevel = DiscountLevel.DISCOUNT_LEVEL_UNSPECIFIED;
    public static final String JSON_PROPERTY_END_DATE_CONDITION = "endDateCondition";
    private EndDateCondition endDateCondition = EndDateCondition.SUBSCRIPTION_END;
    public static final String JSON_PROPERTY_DISCOUNT_CLASS = "discountClass";
    private String discountClass;
    public static final String JSON_PROPERTY_STACKED_DISCOUNT = "stackedDiscount";
    private Boolean stackedDiscount;
    public static final String JSON_PROPERTY_AMOUNTS = "amounts";
    private Map<String, Double> amounts = new HashMap<String, Double>();
    public static final String JSON_PROPERTY_PERCENT = "percent";
    private Double percent;
    public static final String JSON_PROPERTY_UP_TO_PERIODS_TYPE = "upToPeriodsType";
    private UpToPeriodsType upToPeriodsType = UpToPeriodsType.BILLING_PERIODS;
    public static final String JSON_PROPERTY_UP_TO_PERIODS = "upToPeriods";
    private Integer upToPeriods;
    public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
    private Map<String, Value> customFields = new HashMap<String, Value>();
    public static final String JSON_PROPERTY_ACCOUNTING = "accounting";
    private DiscountAccounting accounting;
    public static final String JSON_PROPERTY_PRODUCT_RATE_PLAN_ID = "productRatePlanId";
    private String productRatePlanId;
    public static final String JSON_PROPERTY_PRODUCT_RATE_PLAN_NUMBER = "productRatePlanNumber";
    private String productRatePlanNumber;

    public DiscountRequest() {
    }

    public DiscountRequest discountNumber(String discountNumber) {
        this.discountNumber = discountNumber;
        return this;
    }

    @Nullable
    @JsonProperty(value="discountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDiscountNumber() {
        return this.discountNumber;
    }

    @JsonProperty(value="discountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDiscountNumber(String discountNumber) {
        this.discountNumber = discountNumber;
    }

    public DiscountRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public DiscountRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public DiscountRequest applyTo(List<ChargeType> applyTo) {
        this.applyTo = applyTo;
        return this;
    }

    public DiscountRequest addApplyToItem(ChargeType applyToItem) {
        if (this.applyTo == null) {
            this.applyTo = new ArrayList<ChargeType>();
        }
        this.applyTo.add(applyToItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="applyTo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ChargeType> getApplyTo() {
        return this.applyTo;
    }

    @JsonProperty(value="applyTo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplyTo(List<ChargeType> applyTo) {
        this.applyTo = applyTo;
    }

    public DiscountRequest billCycle(BillCycle billCycle) {
        this.billCycle = billCycle;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="billCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BillCycle getBillCycle() {
        return this.billCycle;
    }

    @JsonProperty(value="billCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBillCycle(BillCycle billCycle) {
        this.billCycle = billCycle;
    }

    public DiscountRequest chargeModel(DiscountChargeModel chargeModel) {
        this.chargeModel = chargeModel;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="chargeModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DiscountChargeModel getChargeModel() {
        return this.chargeModel;
    }

    @JsonProperty(value="chargeModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChargeModel(DiscountChargeModel chargeModel) {
        this.chargeModel = chargeModel;
    }

    public DiscountRequest type(DiscountType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DiscountType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(DiscountType type) {
        this.type = type;
    }

    public DiscountRequest discountLevel(DiscountLevel discountLevel) {
        this.discountLevel = discountLevel;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="discountLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DiscountLevel getDiscountLevel() {
        return this.discountLevel;
    }

    @JsonProperty(value="discountLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDiscountLevel(DiscountLevel discountLevel) {
        this.discountLevel = discountLevel;
    }

    public DiscountRequest endDateCondition(EndDateCondition endDateCondition) {
        this.endDateCondition = endDateCondition;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="endDateCondition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EndDateCondition getEndDateCondition() {
        return this.endDateCondition;
    }

    @JsonProperty(value="endDateCondition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDateCondition(EndDateCondition endDateCondition) {
        this.endDateCondition = endDateCondition;
    }

    public DiscountRequest discountClass(String discountClass) {
        this.discountClass = discountClass;
        return this;
    }

    @Nullable
    @JsonProperty(value="discountClass")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDiscountClass() {
        return this.discountClass;
    }

    @JsonProperty(value="discountClass")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDiscountClass(String discountClass) {
        this.discountClass = discountClass;
    }

    public DiscountRequest stackedDiscount(Boolean stackedDiscount) {
        this.stackedDiscount = stackedDiscount;
        return this;
    }

    @Nullable
    @JsonProperty(value="stackedDiscount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getStackedDiscount() {
        return this.stackedDiscount;
    }

    @JsonProperty(value="stackedDiscount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStackedDiscount(Boolean stackedDiscount) {
        this.stackedDiscount = stackedDiscount;
    }

    public DiscountRequest amounts(Map<String, Double> amounts) {
        this.amounts = amounts;
        return this;
    }

    public DiscountRequest putAmountsItem(String key, Double amountsItem) {
        if (this.amounts == null) {
            this.amounts = new HashMap<String, Double>();
        }
        this.amounts.put(key, amountsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="amounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Double> getAmounts() {
        return this.amounts;
    }

    @JsonProperty(value="amounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmounts(Map<String, Double> amounts) {
        this.amounts = amounts;
    }

    public DiscountRequest percent(Double percent) {
        this.percent = percent;
        return this;
    }

    @Nullable
    @JsonProperty(value="percent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getPercent() {
        return this.percent;
    }

    @JsonProperty(value="percent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPercent(Double percent) {
        this.percent = percent;
    }

    public DiscountRequest upToPeriodsType(UpToPeriodsType upToPeriodsType) {
        this.upToPeriodsType = upToPeriodsType;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="upToPeriodsType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UpToPeriodsType getUpToPeriodsType() {
        return this.upToPeriodsType;
    }

    @JsonProperty(value="upToPeriodsType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpToPeriodsType(UpToPeriodsType upToPeriodsType) {
        this.upToPeriodsType = upToPeriodsType;
    }

    public DiscountRequest upToPeriods(Integer upToPeriods) {
        this.upToPeriods = upToPeriods;
        return this;
    }

    @Nullable
    @JsonProperty(value="upToPeriods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getUpToPeriods() {
        return this.upToPeriods;
    }

    @JsonProperty(value="upToPeriods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpToPeriods(Integer upToPeriods) {
        this.upToPeriods = upToPeriods;
    }

    public DiscountRequest customFields(Map<String, Value> customFields) {
        this.customFields = customFields;
        return this;
    }

    public DiscountRequest putCustomFieldsItem(String key, Value customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Value>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Value> getCustomFields() {
        return this.customFields;
    }

    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomFields(Map<String, Value> customFields) {
        this.customFields = customFields;
    }

    public DiscountRequest accounting(DiscountAccounting accounting) {
        this.accounting = accounting;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="accounting")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DiscountAccounting getAccounting() {
        return this.accounting;
    }

    @JsonProperty(value="accounting")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccounting(DiscountAccounting accounting) {
        this.accounting = accounting;
    }

    public DiscountRequest productRatePlanId(String productRatePlanId) {
        this.productRatePlanId = productRatePlanId;
        return this;
    }

    @Nullable
    @JsonProperty(value="productRatePlanId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProductRatePlanId() {
        return this.productRatePlanId;
    }

    @JsonProperty(value="productRatePlanId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProductRatePlanId(String productRatePlanId) {
        this.productRatePlanId = productRatePlanId;
    }

    public DiscountRequest productRatePlanNumber(String productRatePlanNumber) {
        this.productRatePlanNumber = productRatePlanNumber;
        return this;
    }

    @Nullable
    @JsonProperty(value="productRatePlanNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProductRatePlanNumber() {
        return this.productRatePlanNumber;
    }

    @JsonProperty(value="productRatePlanNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProductRatePlanNumber(String productRatePlanNumber) {
        this.productRatePlanNumber = productRatePlanNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscountRequest discountRequest = (DiscountRequest)o;
        return Objects.equals(this.discountNumber, discountRequest.discountNumber) && Objects.equals(this.name, discountRequest.name) && Objects.equals(this.description, discountRequest.description) && Objects.equals(this.applyTo, discountRequest.applyTo) && Objects.equals(this.billCycle, discountRequest.billCycle) && Objects.equals((Object)this.chargeModel, (Object)discountRequest.chargeModel) && Objects.equals((Object)this.type, (Object)discountRequest.type) && Objects.equals((Object)this.discountLevel, (Object)discountRequest.discountLevel) && Objects.equals((Object)this.endDateCondition, (Object)discountRequest.endDateCondition) && Objects.equals(this.discountClass, discountRequest.discountClass) && Objects.equals(this.stackedDiscount, discountRequest.stackedDiscount) && Objects.equals(this.amounts, discountRequest.amounts) && Objects.equals(this.percent, discountRequest.percent) && Objects.equals((Object)this.upToPeriodsType, (Object)discountRequest.upToPeriodsType) && Objects.equals(this.upToPeriods, discountRequest.upToPeriods) && Objects.equals(this.customFields, discountRequest.customFields) && Objects.equals(this.accounting, discountRequest.accounting) && Objects.equals(this.productRatePlanId, discountRequest.productRatePlanId) && Objects.equals(this.productRatePlanNumber, discountRequest.productRatePlanNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.discountNumber, this.name, this.description, this.applyTo, this.billCycle, this.chargeModel, this.type, this.discountLevel, this.endDateCondition, this.discountClass, this.stackedDiscount, this.amounts, this.percent, this.upToPeriodsType, this.upToPeriods, this.customFields, this.accounting, this.productRatePlanId, this.productRatePlanNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DiscountRequest {\n");
        sb.append("    discountNumber: ").append(this.toIndentedString(this.discountNumber)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    applyTo: ").append(this.toIndentedString(this.applyTo)).append("\n");
        sb.append("    billCycle: ").append(this.toIndentedString(this.billCycle)).append("\n");
        sb.append("    chargeModel: ").append(this.toIndentedString((Object)this.chargeModel)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    discountLevel: ").append(this.toIndentedString((Object)this.discountLevel)).append("\n");
        sb.append("    endDateCondition: ").append(this.toIndentedString((Object)this.endDateCondition)).append("\n");
        sb.append("    discountClass: ").append(this.toIndentedString(this.discountClass)).append("\n");
        sb.append("    stackedDiscount: ").append(this.toIndentedString(this.stackedDiscount)).append("\n");
        sb.append("    amounts: ").append(this.toIndentedString(this.amounts)).append("\n");
        sb.append("    percent: ").append(this.toIndentedString(this.percent)).append("\n");
        sb.append("    upToPeriodsType: ").append(this.toIndentedString((Object)this.upToPeriodsType)).append("\n");
        sb.append("    upToPeriods: ").append(this.toIndentedString(this.upToPeriods)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    accounting: ").append(this.toIndentedString(this.accounting)).append("\n");
        sb.append("    productRatePlanId: ").append(this.toIndentedString(this.productRatePlanId)).append("\n");
        sb.append("    productRatePlanNumber: ").append(this.toIndentedString(this.productRatePlanNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DiscountRequestBuilder builder() {
        return new DiscountRequestBuilder();
    }

    public DiscountRequest(String discountNumber, String name, String description, List<ChargeType> applyTo, BillCycle billCycle, DiscountChargeModel chargeModel, DiscountType type, DiscountLevel discountLevel, EndDateCondition endDateCondition, String discountClass, Boolean stackedDiscount, Map<String, Double> amounts, Double percent, UpToPeriodsType upToPeriodsType, Integer upToPeriods, Map<String, Value> customFields, DiscountAccounting accounting, String productRatePlanId, String productRatePlanNumber) {
        this.discountNumber = discountNumber;
        this.name = name;
        this.description = description;
        this.applyTo = applyTo;
        this.billCycle = billCycle;
        this.chargeModel = chargeModel;
        this.type = type;
        this.discountLevel = discountLevel;
        this.endDateCondition = endDateCondition;
        this.discountClass = discountClass;
        this.stackedDiscount = stackedDiscount;
        this.amounts = amounts;
        this.percent = percent;
        this.upToPeriodsType = upToPeriodsType;
        this.upToPeriods = upToPeriods;
        this.customFields = customFields;
        this.accounting = accounting;
        this.productRatePlanId = productRatePlanId;
        this.productRatePlanNumber = productRatePlanNumber;
    }

    public static class DiscountRequestBuilder {
        private String discountNumber;
        private String name;
        private String description;
        private List<ChargeType> applyTo;
        private BillCycle billCycle;
        private DiscountChargeModel chargeModel;
        private DiscountType type;
        private DiscountLevel discountLevel;
        private EndDateCondition endDateCondition;
        private String discountClass;
        private Boolean stackedDiscount;
        private Map<String, Double> amounts;
        private Double percent;
        private UpToPeriodsType upToPeriodsType;
        private Integer upToPeriods;
        private Map<String, Value> customFields;
        private DiscountAccounting accounting;
        private String productRatePlanId;
        private String productRatePlanNumber;

        DiscountRequestBuilder() {
        }

        public DiscountRequestBuilder discountNumber(String discountNumber) {
            this.discountNumber = discountNumber;
            return this;
        }

        public DiscountRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DiscountRequestBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DiscountRequestBuilder applyTo(List<ChargeType> applyTo) {
            this.applyTo = applyTo;
            return this;
        }

        public DiscountRequestBuilder billCycle(BillCycle billCycle) {
            this.billCycle = billCycle;
            return this;
        }

        public DiscountRequestBuilder chargeModel(DiscountChargeModel chargeModel) {
            this.chargeModel = chargeModel;
            return this;
        }

        public DiscountRequestBuilder type(DiscountType type) {
            this.type = type;
            return this;
        }

        public DiscountRequestBuilder discountLevel(DiscountLevel discountLevel) {
            this.discountLevel = discountLevel;
            return this;
        }

        public DiscountRequestBuilder endDateCondition(EndDateCondition endDateCondition) {
            this.endDateCondition = endDateCondition;
            return this;
        }

        public DiscountRequestBuilder discountClass(String discountClass) {
            this.discountClass = discountClass;
            return this;
        }

        public DiscountRequestBuilder stackedDiscount(Boolean stackedDiscount) {
            this.stackedDiscount = stackedDiscount;
            return this;
        }

        public DiscountRequestBuilder amounts(Map<String, Double> amounts) {
            this.amounts = amounts;
            return this;
        }

        public DiscountRequestBuilder percent(Double percent) {
            this.percent = percent;
            return this;
        }

        public DiscountRequestBuilder upToPeriodsType(UpToPeriodsType upToPeriodsType) {
            this.upToPeriodsType = upToPeriodsType;
            return this;
        }

        public DiscountRequestBuilder upToPeriods(Integer upToPeriods) {
            this.upToPeriods = upToPeriods;
            return this;
        }

        public DiscountRequestBuilder customFields(Map<String, Value> customFields) {
            this.customFields = customFields;
            return this;
        }

        public DiscountRequestBuilder accounting(DiscountAccounting accounting) {
            this.accounting = accounting;
            return this;
        }

        public DiscountRequestBuilder productRatePlanId(String productRatePlanId) {
            this.productRatePlanId = productRatePlanId;
            return this;
        }

        public DiscountRequestBuilder productRatePlanNumber(String productRatePlanNumber) {
            this.productRatePlanNumber = productRatePlanNumber;
            return this;
        }

        public DiscountRequest build() {
            return new DiscountRequest(this.discountNumber, this.name, this.description, this.applyTo, this.billCycle, this.chargeModel, this.type, this.discountLevel, this.endDateCondition, this.discountClass, this.stackedDiscount, this.amounts, this.percent, this.upToPeriodsType, this.upToPeriods, this.customFields, this.accounting, this.productRatePlanId, this.productRatePlanNumber);
        }

        public String toString() {
            return "DiscountRequest.DiscountRequestBuilder(discountNumber=" + this.discountNumber + ", name=" + this.name + ", description=" + this.description + ", applyTo=" + this.applyTo + ", billCycle=" + this.billCycle + ", chargeModel=" + this.chargeModel + ", type=" + this.type + ", discountLevel=" + this.discountLevel + ", endDateCondition=" + this.endDateCondition + ", discountClass=" + this.discountClass + ", stackedDiscount=" + this.stackedDiscount + ", amounts=" + this.amounts + ", percent=" + this.percent + ", upToPeriodsType=" + this.upToPeriodsType + ", upToPeriods=" + this.upToPeriods + ", customFields=" + this.customFields + ", accounting=" + this.accounting + ", productRatePlanId=" + this.productRatePlanId + ", productRatePlanNumber=" + this.productRatePlanNumber + ")";
        }
    }
}

