/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog.plan;

import com.zuora.sdk.catalog.charge.Charge;
import com.zuora.sdk.common.ApiObject;
import com.zuora.sdk.error.Validations;
import com.zuora.sdk.values.IsoDate;
import com.zuora.zevolve.api.model.AggregatePlanRequest;
import com.zuora.zevolve.api.model.Attribute;
import com.zuora.zevolve.api.model.RatePlanNetsuite;
import com.zuora.zevolve.api.model.Value;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class NewPlan
implements ApiObject<AggregatePlanRequest> {
    private final String name;
    private final List<Charge> charges = new ArrayList<Charge>();
    private final Set<String> activeCurrencies = new HashSet<String>();
    private IsoDate startDate;
    private IsoDate endDate;
    private String description;
    private Integer grade;
    private RatePlanNetsuite netsuite;
    private Map<String, Value> customFields = new HashMap<String, Value>();
    private List<Attribute> attributes = new ArrayList<Attribute>();

    public NewPlan(String name) {
        this.name = name;
    }

    public static NewPlan withName(String name) {
        return new NewPlan(name);
    }

    public NewPlan withDescription(String description) {
        this.description = description;
        return this;
    }

    public NewPlan withGrade(Integer value) {
        this.grade = value;
        return this;
    }

    public NewPlan with(Charge charge) {
        if (charge != null) {
            this.charges.add(charge);
        }
        return this;
    }

    public NewPlan effectiveBetween(String startDate, String endDate) {
        return this.effectiveBetween(IsoDate.of((String)startDate), IsoDate.of((String)endDate));
    }

    public NewPlan effectiveBetween(IsoDate startDate, IsoDate endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
        return this;
    }

    public NewPlan withActiveCurrencies(String ... currencies) {
        if (currencies != null) {
            Arrays.stream(currencies).forEach(this.activeCurrencies::add);
        }
        return this;
    }

    public NewPlan withNetsuite(RatePlanNetsuite netsuite) {
        this.netsuite = netsuite;
        return this;
    }

    public NewPlan withCustomField(String name, Value value) {
        this.customFields.put(name, value);
        return this;
    }

    public NewPlan withAttribute(Attribute attribute) {
        if (this.attributes != null) {
            this.attributes.add(attribute);
        }
        return this;
    }

    public AggregatePlanRequest toApi() {
        Validations.requireNonNull((Object)this.name, (String)"plan name is required");
        Validations.require((this.name.length() <= 255 ? 1 : 0) != 0, (String)"name must be 255 characters or less");
        Validations.require((this.description == null || this.description.length() <= 255 ? 1 : 0) != 0, (String)"description must be 255 characters or less");
        return AggregatePlanRequest.builder().name(this.name).description(this.description).startDate(this.startDate != null ? ((LocalDate)this.startDate.value()).toString() : null).endDate(this.endDate != null ? ((LocalDate)this.endDate.value()).toString() : null).activeCurrencies(new ArrayList<String>(this.activeCurrencies)).charges(this.charges.stream().map(Charge::toApi).collect(Collectors.toList())).grade(this.grade).netsuite(this.netsuite).customFields(this.customFields).attributes(this.attributes).build();
    }
}

