/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog.charge.recurring;

import com.zuora.sdk.catalog.charge.Amount;
import com.zuora.sdk.catalog.charge.Billing;
import com.zuora.sdk.catalog.charge.SubscriptionRenewalOptions;
import com.zuora.sdk.catalog.charge.Taxation;
import com.zuora.sdk.catalog.charge.Uom;
import com.zuora.sdk.catalog.charge.recurring.RecurringCharge;
import com.zuora.sdk.error.Validations;
import com.zuora.zevolve.api.model.Accounting;
import com.zuora.zevolve.api.model.ChargeModel;
import com.zuora.zevolve.api.model.ChargeType;
import com.zuora.zevolve.api.model.DeliverySchedule;
import com.zuora.zevolve.api.model.Drawdown;
import com.zuora.zevolve.api.model.EndDateCondition;
import com.zuora.zevolve.api.model.ListPriceBase;
import com.zuora.zevolve.api.model.Netsuite;
import com.zuora.zevolve.api.model.Prepayment;
import com.zuora.zevolve.api.model.Pricing;
import com.zuora.zevolve.api.model.ProductRatePlanChargeRequest;
import com.zuora.zevolve.api.model.Revenue;
import com.zuora.zevolve.api.model.TriggerEvent;
import com.zuora.zevolve.api.model.UpToPeriodsType;
import com.zuora.zevolve.api.model.Value;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public final class PerUnitCharge
extends RecurringCharge {
    private final List<Amount> amounts = new ArrayList<Amount>();
    private BigDecimal defaultQuantity = BigDecimal.ZERO;
    private Uom uom;

    private PerUnitCharge() {
    }

    static PerUnitCharge newInstance() {
        return new PerUnitCharge();
    }

    public PerUnitCharge withName(String name) {
        this.name = name;
        return this;
    }

    public PerUnitCharge with(Billing billing) {
        this.billing = billing;
        return this;
    }

    public PerUnitCharge with(TriggerEvent event) {
        this.triggerEvent = event;
        return this;
    }

    protected PerUnitCharge with(Accounting accounting) {
        this.accounting = accounting;
        return this;
    }

    public PerUnitCharge with(Revenue revenue) {
        this.revenue = revenue;
        return this;
    }

    public PerUnitCharge with(Taxation taxation) {
        this.taxation = taxation;
        return this;
    }

    public PerUnitCharge with(Netsuite netsuite) {
        this.netsuite = netsuite;
        return this;
    }

    protected PerUnitCharge with(SubscriptionRenewalOptions options) {
        this.renewalOptions = options;
        return this;
    }

    protected PerUnitCharge with(DeliverySchedule deliverySchedule) {
        this.deliverySchedule = deliverySchedule;
        return this;
    }

    public PerUnitCharge with(EndDateCondition condition) {
        this.endDateCondition = condition;
        return this;
    }

    public PerUnitCharge with(Integer periods, UpToPeriodsType periodsType) {
        this.upToPeriods = periods;
        this.upToPeriodsType = periodsType;
        return this;
    }

    public PerUnitCharge with(ListPriceBase listPriceBase) {
        this.listPriceBase = listPriceBase;
        return this;
    }

    public PerUnitCharge with(Uom unitOfMeasure) {
        this.uom = unitOfMeasure;
        return this;
    }

    public PerUnitCharge with(Amount amount) {
        if (amount != null) {
            this.amounts.add(amount);
        }
        return this;
    }

    public PerUnitCharge with(Prepayment prepayment) {
        this.prepayment = prepayment;
        return this;
    }

    public PerUnitCharge with(Drawdown drawdown) {
        this.drawdown = drawdown;
        return this;
    }

    public PerUnitCharge withCustomField(String name, Value value) {
        this.customFields.put(name, value);
        return this;
    }

    protected PerUnitCharge withSpecificListPriceBase(Integer specificListPriceBase) {
        this.specificListPriceBase = specificListPriceBase;
        return this;
    }

    public PerUnitCharge withDefaultQuantity(BigDecimal defaultQuantity) {
        this.defaultQuantity = defaultQuantity;
        return this;
    }

    @Override
    public ProductRatePlanChargeRequest toApi(ProductRatePlanChargeRequest.ProductRatePlanChargeRequestBuilder builder) {
        Validations.requireNonNull((Object)((Object)this.uom), (String)"unitOfMeasure is required");
        Validations.requireNonNull((Object)this.defaultQuantity, (String)"defaultQuantity is required");
        return builder.chargeType(ChargeType.RECURRING).chargeModel(ChargeModel.PER_UNIT).triggerEvent(this.triggerEvent).unitOfMeasure((String)this.uom.value()).defaultQuantity(this.defaultQuantity != null ? Double.valueOf(this.defaultQuantity.doubleValue()) : null).pricing(Pricing.builder().unitAmounts(Amount.toApiMap(this.amounts)).build()).build();
    }
}

