/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog.charge.onetime;

import com.zuora.sdk.catalog.charge.Billing;
import com.zuora.sdk.catalog.charge.Charge;
import com.zuora.sdk.catalog.charge.SubscriptionRenewalOptions;
import com.zuora.sdk.catalog.charge.Taxation;
import com.zuora.sdk.catalog.charge.Tier;
import com.zuora.sdk.catalog.charge.Uom;
import com.zuora.sdk.error.ErrorCode;
import com.zuora.sdk.error.ErrorType;
import com.zuora.sdk.error.SdkError;
import com.zuora.sdk.error.SdkException;
import com.zuora.zevolve.api.model.Accounting;
import com.zuora.zevolve.api.model.ChargeModel;
import com.zuora.zevolve.api.model.ChargeType;
import com.zuora.zevolve.api.model.DeliverySchedule;
import com.zuora.zevolve.api.model.Drawdown;
import com.zuora.zevolve.api.model.Netsuite;
import com.zuora.zevolve.api.model.Prepayment;
import com.zuora.zevolve.api.model.Pricing;
import com.zuora.zevolve.api.model.ProductRatePlanChargeRequest;
import com.zuora.zevolve.api.model.Revenue;
import com.zuora.zevolve.api.model.TriggerEvent;
import com.zuora.zevolve.api.model.Value;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class VolumeCharge
extends Charge {
    private final List<Tier> tiers = new ArrayList<Tier>();
    private BigDecimal defaultQuantity = BigDecimal.ZERO;
    private Uom uom;

    private VolumeCharge() {
    }

    static VolumeCharge newInstance() {
        return new VolumeCharge();
    }

    public VolumeCharge withName(String name) {
        this.name = name;
        return this;
    }

    public VolumeCharge with(Billing billing) {
        throw new SdkException(SdkError.error((ErrorType)ErrorType.bad_request, (ErrorCode)ErrorCode.invalid_request, (String)"One-time charges do not support billing period."));
    }

    public VolumeCharge with(TriggerEvent event) {
        this.triggerEvent = event;
        return this;
    }

    protected VolumeCharge with(Accounting accounting) {
        this.accounting = accounting;
        return this;
    }

    public VolumeCharge with(Revenue revenue) {
        this.revenue = revenue;
        return this;
    }

    public VolumeCharge with(Taxation taxation) {
        this.taxation = taxation;
        return this;
    }

    public VolumeCharge with(Netsuite netsuite) {
        this.netsuite = netsuite;
        return this;
    }

    protected VolumeCharge with(SubscriptionRenewalOptions options) {
        this.renewalOptions = options;
        return this;
    }

    public VolumeCharge with(Uom uom) {
        this.uom = uom;
        return this;
    }

    public VolumeCharge with(Tier tier) {
        this.tiers.add(tier);
        return this;
    }

    protected VolumeCharge with(DeliverySchedule deliverySchedule) {
        this.deliverySchedule = deliverySchedule;
        return this;
    }

    public VolumeCharge with(Prepayment prepayment) {
        this.prepayment = prepayment;
        return this;
    }

    public VolumeCharge with(Drawdown drawdown) {
        this.drawdown = drawdown;
        return this;
    }

    public VolumeCharge withCustomField(String name, Value value) {
        this.customFields.put(name, value);
        return this;
    }

    public VolumeCharge withDefaultQuantity(BigDecimal defaultQuantity) {
        this.defaultQuantity = defaultQuantity;
        return this;
    }

    @Override
    public ProductRatePlanChargeRequest toApi(ProductRatePlanChargeRequest.ProductRatePlanChargeRequestBuilder builder) {
        return builder.chargeType(ChargeType.ONE_TIME).chargeModel(ChargeModel.VOLUME).unitOfMeasure(this.uom != null ? (String)this.uom.value() : null).pricing(Pricing.builder().tiers(this.tiers.stream().map(Tier::toApi).collect(Collectors.toList())).build()).defaultQuantity(this.defaultQuantity != null ? Double.valueOf(this.defaultQuantity.doubleValue()) : null).build();
    }
}

