/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog.charge;

import com.zuora.sdk.catalog.charge.Amount;
import com.zuora.sdk.common.ApiObject;
import com.zuora.zevolve.api.model.PriceFormat;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public final class Tier
implements ApiObject<com.zuora.zevolve.api.model.Tier> {
    private final BigDecimal from;
    private final BigDecimal upto;
    private final List<Amount> amounts = new ArrayList<Amount>();
    private final PriceFormat priceFormat;

    public Tier(BigDecimal from, BigDecimal upto, Amount amount, PriceFormat priceFormat) {
        this.from = from;
        this.upto = upto;
        this.amounts.add(amount);
        this.priceFormat = priceFormat;
    }

    public static Tier flatFee(long from, long upto, Amount amount) {
        return new Tier(BigDecimal.valueOf(from), BigDecimal.valueOf(upto), amount, PriceFormat.FLAT_FEE);
    }

    public static Tier flatFee(BigDecimal from, BigDecimal upto, Amount amount) {
        return new Tier(from, upto, amount, PriceFormat.FLAT_FEE);
    }

    public static Tier perUnit(BigDecimal from, BigDecimal upto, Amount amount) {
        return new Tier(from, upto, amount, PriceFormat.PER_UNIT);
    }

    public static Tier perUnit(long from, long upto, Amount amount) {
        return new Tier(BigDecimal.valueOf(from), BigDecimal.valueOf(upto), amount, PriceFormat.PER_UNIT);
    }

    public Tier and(Amount amount) {
        this.amounts.add(amount);
        return this;
    }

    public com.zuora.zevolve.api.model.Tier toApi() {
        return com.zuora.zevolve.api.model.Tier.builder().from(this.from != null ? Double.valueOf(this.from.doubleValue()) : null).upTo(this.upto != null ? Double.valueOf(this.upto.doubleValue()) : null).priceFormat(this.priceFormat).unitAmounts(Amount.toApiMap(this.amounts)).build();
    }
}

