/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog;

import com.fasterxml.jackson.core.type.TypeReference;
import com.zuora.sdk.Zuora;
import com.zuora.sdk.catalog.Catalog;
import com.zuora.sdk.catalog.CatalogSupport;
import com.zuora.sdk.catalog.product.NewProduct;
import com.zuora.sdk.common.CheckedFunction;
import com.zuora.sdk.common.Either;
import com.zuora.sdk.common.Page;
import com.zuora.sdk.config.StreamingConfig;
import com.zuora.sdk.error.ErrorMappers;
import com.zuora.sdk.error.SdkError;
import com.zuora.sdk.error.SdkException;
import com.zuora.sdk.error.Validations;
import com.zuora.sdk.http.HttpMethod;
import com.zuora.sdk.http.HttpSupport;
import com.zuora.sdk.json.PropertyNameScheme;
import com.zuora.sdk.stream.StreamingOptions;
import com.zuora.sdk.stream.StreamingSupport;
import com.zuora.zevolve.api.model.Product;
import com.zuora.zevolve.api.model.ProductAggregate;
import com.zuora.zevolve.api.model.ProductExpand;
import com.zuora.zevolve.api.model.ProductFilter;
import com.zuora.zevolve.api.model.UpdateProductRequest;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProductsService.class);
    private final Zuora zuora;
    private final CatalogSupport catalogSupport;
    private final HttpSupport httpSupport;

    public ProductsService(Zuora zuora, CatalogSupport catalogSupport, HttpSupport httpSupport) {
        this.zuora = zuora;
        this.catalogSupport = catalogSupport;
        this.httpSupport = httpSupport;
    }

    public Boolean deleteProduct(String id) throws SdkException {
        Validations.requireNotEmpty((String)id, (String)"id is required");
        String path = HttpSupport.encodePathParams((String)(Catalog.getPathPrefix() + "/products/%s"), (String[])new String[]{id.trim()});
        return "ok".equalsIgnoreCase((String)this.httpSupport.call(HttpMethod.DELETE, path, Optional.empty(), (TypeReference)new TypeReference<String>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent()));
    }

    public Stream<Either<SdkError, Boolean>> deleteProducts(Iterator<String> ids, StreamingOptions options) {
        LOGGER.debug("Removing products in batched streaming mode");
        Stream<String> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(ids, 16), false);
        StreamingConfig streamingConfig = this.zuora.getConfiguration().getStreamingConfig();
        return StreamingSupport.doStreaming(stream, id -> this.catalogSupport.deleteNonBlocking(Catalog.getPathPrefix() + "/products/%s", (String)id), (StreamingOptions)options, (int)streamingConfig.getMaxBatchSize(), (int)streamingConfig.getMaxBatchesToBuffer());
    }

    public Stream<Either<SdkError, Boolean>> deleteProducts(InputStream is, StreamingOptions options) {
        LOGGER.debug("Removing products in batched streaming mode");
        StreamingConfig streamingConfig = this.zuora.getConfiguration().getStreamingConfig();
        return StreamingSupport.doStreaming((InputStream)is, id -> id, id -> this.catalogSupport.deleteNonBlocking(Catalog.getPathPrefix() + "/products/%s", (String)id), (StreamingOptions)options, (int)streamingConfig.getMaxBatchSize(), (int)streamingConfig.getMaxBatchesToBuffer());
    }

    public ProductAggregate createProduct(NewProduct product) throws SdkException {
        return (ProductAggregate)this.httpSupport.call(HttpMethod.POST, Catalog.getPathPrefix() + "/products", Optional.ofNullable(product.toApi()), (TypeReference)new TypeReference<ProductAggregate>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    public Stream<Either<SdkError, ProductAggregate>> createProducts(Iterator<NewProduct> products, StreamingOptions options) {
        Stream<NewProduct> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(products, 16), false);
        StreamingConfig streamingConfig = this.zuora.getConfiguration().getStreamingConfig();
        return StreamingSupport.doStreaming(stream, request -> this.catalogSupport.postNonBlocking(Catalog.getPathPrefix() + "/products", request.toApi(), new TypeReference<ProductAggregate>(){}), (StreamingOptions)options, (int)streamingConfig.getMaxBatchSize(), (int)streamingConfig.getMaxBatchesToBuffer());
    }

    public <T> Stream<Either<SdkError, ProductAggregate>> createProducts(InputStream is, CheckedFunction<String, NewProduct> mapper, StreamingOptions options) {
        StreamingConfig streamingConfig = this.zuora.getConfiguration().getStreamingConfig();
        return StreamingSupport.doStreaming((InputStream)is, arg_0 -> mapper.apply(arg_0), request -> this.catalogSupport.postNonBlocking(Catalog.getPathPrefix() + "/products", request.toApi(), new TypeReference<ProductAggregate>(){}), (StreamingOptions)options, (int)streamingConfig.getMaxBatchSize(), (int)streamingConfig.getMaxBatchesToBuffer());
    }

    public Product updateProduct(UpdateProductRequest product) throws SdkException {
        Validations.requireNotEmpty((String)product.getId(), (String)"id is required");
        return (Product)this.httpSupport.call(HttpMethod.PUT, HttpSupport.encodePathParams((String)(Catalog.getPathPrefix() + "/products"), (String[])new String[0]), Optional.of(product), (TypeReference)new TypeReference<Product>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    public Stream<Either<SdkError, Product>> updateProducts(Iterator<UpdateProductRequest> products, StreamingOptions options) {
        Stream<UpdateProductRequest> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(products, 16), false);
        StreamingConfig streamingConfig = this.zuora.getConfiguration().getStreamingConfig();
        return StreamingSupport.doStreaming(stream, request -> this.catalogSupport.putNonBlocking(Catalog.getPathPrefix() + "/products", request, new TypeReference<Product>(){}, req -> Validations.checkNotEmpty((String)req.getId(), (String)"id is required")), (StreamingOptions)options, (int)streamingConfig.getMaxBatchSize(), (int)streamingConfig.getMaxBatchesToBuffer());
    }

    public <T> Stream<Either<SdkError, Product>> updateProducts(InputStream is, CheckedFunction<String, UpdateProductRequest> mapper, StreamingOptions options) {
        StreamingConfig streamingConfig = this.zuora.getConfiguration().getStreamingConfig();
        return StreamingSupport.doStreaming((InputStream)is, mapper, request -> this.catalogSupport.putNonBlocking(Catalog.getPathPrefix() + "/products", request, new TypeReference<Product>(){}, req -> Validations.checkNotEmpty((String)req.getId(), (String)"id is required")), (StreamingOptions)options, (int)streamingConfig.getMaxBatchSize(), (int)streamingConfig.getMaxBatchesToBuffer());
    }

    public Product getProduct(String productKey) throws SdkException {
        Validations.requireNotEmpty((String)productKey, (String)"product key is required");
        return (Product)this.httpSupport.call(HttpMethod.GET, HttpSupport.encodePathParams((String)(Catalog.getPathPrefix() + "/products/%s"), (String[])new String[]{productKey.trim()}), Optional.empty(), (TypeReference)new TypeReference<Product>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    public Stream<Either<SdkError, Product>> getProducts(Iterator<String> productKeys, StreamingOptions options) {
        Stream<String> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(productKeys, 16), false);
        StreamingConfig streamingConfig = this.zuora.getConfiguration().getStreamingConfig();
        return StreamingSupport.doStreaming(stream, id -> this.catalogSupport.getNonBlocking(Catalog.getPathPrefix() + "/products/%s", (String)id, new TypeReference<Product>(){}), (StreamingOptions)options, (int)streamingConfig.getMaxBatchSize(), (int)streamingConfig.getMaxBatchesToBuffer());
    }

    private Iterator<Page<List<Product>>> getProducts(int pageSize, ProductExpand expand, ProductFilter ... filters) {
        return CatalogSupport.paginate(pageSize, pagination -> {
            try {
                return Optional.empty();
            }
            catch (Throwable t) {
                throw new SdkException("Error while fetching next page", SdkError.unexpectedError((Throwable)t));
            }
        });
    }
}

