/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.zevolve.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zuora.zevolve.api.model.FilterOperator;
import com.zuora.zevolve.api.model.ProductFields;
import com.zuora.zevolve.api.model.Value;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"field", "customField", "operator", "value"})
public class ProductFilter {
    public static final String JSON_PROPERTY_FIELD = "field";
    private ProductFields field = ProductFields.ID;
    public static final String JSON_PROPERTY_CUSTOM_FIELD = "customField";
    private String customField;
    public static final String JSON_PROPERTY_OPERATOR = "operator";
    private FilterOperator operator = FilterOperator.EQ;
    public static final String JSON_PROPERTY_VALUE = "value";
    private Value value;

    public ProductFilter() {
    }

    public ProductFilter field(ProductFields field) {
        this.field = field;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="field")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProductFields getField() {
        return this.field;
    }

    @JsonProperty(value="field")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setField(ProductFields field) {
        this.field = field;
    }

    public ProductFilter customField(String customField) {
        this.customField = customField;
        return this;
    }

    @Nullable
    @JsonProperty(value="customField")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomField() {
        return this.customField;
    }

    @JsonProperty(value="customField")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomField(String customField) {
        this.customField = customField;
    }

    public ProductFilter operator(FilterOperator operator) {
        this.operator = operator;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="operator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FilterOperator getOperator() {
        return this.operator;
    }

    @JsonProperty(value="operator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperator(FilterOperator operator) {
        this.operator = operator;
    }

    public ProductFilter value(Value value) {
        this.value = value;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Value getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(Value value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductFilter productFilter = (ProductFilter)o;
        return Objects.equals((Object)this.field, (Object)productFilter.field) && Objects.equals(this.customField, productFilter.customField) && Objects.equals((Object)this.operator, (Object)productFilter.operator) && Objects.equals(this.value, productFilter.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.customField, this.operator, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductFilter {\n");
        sb.append("    field: ").append(this.toIndentedString((Object)this.field)).append("\n");
        sb.append("    customField: ").append(this.toIndentedString(this.customField)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ProductFilterBuilder builder() {
        return new ProductFilterBuilder();
    }

    public ProductFilter(ProductFields field, String customField, FilterOperator operator, Value value) {
        this.field = field;
        this.customField = customField;
        this.operator = operator;
        this.value = value;
    }

    public static class ProductFilterBuilder {
        private ProductFields field;
        private String customField;
        private FilterOperator operator;
        private Value value;

        ProductFilterBuilder() {
        }

        public ProductFilterBuilder field(ProductFields field) {
            this.field = field;
            return this;
        }

        public ProductFilterBuilder customField(String customField) {
            this.customField = customField;
            return this;
        }

        public ProductFilterBuilder operator(FilterOperator operator) {
            this.operator = operator;
            return this;
        }

        public ProductFilterBuilder value(Value value) {
            this.value = value;
            return this;
        }

        public ProductFilter build() {
            return new ProductFilter(this.field, this.customField, this.operator, this.value);
        }

        public String toString() {
            return "ProductFilter.ProductFilterBuilder(field=" + this.field + ", customField=" + this.customField + ", operator=" + this.operator + ", value=" + this.value + ")";
        }
    }
}

