/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.zevolve.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"page", "pageSize"})
public class Pagination {
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page;
    public static final String JSON_PROPERTY_PAGE_SIZE = "pageSize";
    private Integer pageSize;

    public Pagination() {
    }

    public Pagination page(Integer page) {
        this.page = page;
        return this;
    }

    @Nullable
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public Pagination pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="pageSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="pageSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pagination pagination = (Pagination)o;
        return Objects.equals(this.page, pagination.page) && Objects.equals(this.pageSize, pagination.pageSize);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.pageSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Pagination {\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaginationBuilder builder() {
        return new PaginationBuilder();
    }

    public Pagination(Integer page, Integer pageSize) {
        this.page = page;
        this.pageSize = pageSize;
    }

    public static class PaginationBuilder {
        private Integer page;
        private Integer pageSize;

        PaginationBuilder() {
        }

        public PaginationBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public PaginationBuilder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Pagination build() {
            return new Pagination(this.page, this.pageSize);
        }

        public String toString() {
            return "Pagination.PaginationBuilder(page=" + this.page + ", pageSize=" + this.pageSize + ")";
        }
    }
}

