/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.zevolve.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zuora.zevolve.api.model.Error;
import com.zuora.zevolve.api.model.ErrorType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"type", "errors"})
public class ErrorResponse {
    public static final String JSON_PROPERTY_TYPE = "type";
    private ErrorType type = ErrorType.BAD_REQUEST;
    public static final String JSON_PROPERTY_ERRORS = "errors";
    private List<@Valid Error> errors = new ArrayList<Error>();

    public ErrorResponse() {
    }

    public ErrorResponse type(ErrorType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ErrorType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(ErrorType type) {
        this.type = type;
    }

    public ErrorResponse errors(List<@Valid Error> errors) {
        this.errors = errors;
        return this;
    }

    public ErrorResponse addErrorsItem(Error errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<Error>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid Error> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrors(List<@Valid Error> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorResponse errorResponse = (ErrorResponse)o;
        return Objects.equals((Object)this.type, (Object)errorResponse.type) && Objects.equals(this.errors, errorResponse.errors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.errors});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ErrorResponse {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ErrorResponseBuilder builder() {
        return new ErrorResponseBuilder();
    }

    public ErrorResponse(ErrorType type, List<@Valid Error> errors) {
        this.type = type;
        this.errors = errors;
    }

    public static class ErrorResponseBuilder {
        private ErrorType type;
        private List<@Valid Error> errors;

        ErrorResponseBuilder() {
        }

        public ErrorResponseBuilder type(ErrorType type) {
            this.type = type;
            return this;
        }

        public ErrorResponseBuilder errors(List<@Valid Error> errors) {
            this.errors = errors;
            return this;
        }

        public ErrorResponse build() {
            return new ErrorResponse(this.type, this.errors);
        }

        public String toString() {
            return "ErrorResponse.ErrorResponseBuilder(type=" + this.type + ", errors=" + this.errors + ")";
        }
    }
}

