/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.zevolve.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zuora.zevolve.api.model.AttributeCombination;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"productRatePlanNumber", "attributeCombinations"})
public class CreateChargeDefinitionsRequest {
    public static final String JSON_PROPERTY_PRODUCT_RATE_PLAN_NUMBER = "productRatePlanNumber";
    private String productRatePlanNumber;
    public static final String JSON_PROPERTY_ATTRIBUTE_COMBINATIONS = "attributeCombinations";
    private List<@Valid AttributeCombination> attributeCombinations = new ArrayList<AttributeCombination>();

    public CreateChargeDefinitionsRequest() {
    }

    public CreateChargeDefinitionsRequest productRatePlanNumber(String productRatePlanNumber) {
        this.productRatePlanNumber = productRatePlanNumber;
        return this;
    }

    @Nullable
    @JsonProperty(value="productRatePlanNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProductRatePlanNumber() {
        return this.productRatePlanNumber;
    }

    @JsonProperty(value="productRatePlanNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProductRatePlanNumber(String productRatePlanNumber) {
        this.productRatePlanNumber = productRatePlanNumber;
    }

    public CreateChargeDefinitionsRequest attributeCombinations(List<@Valid AttributeCombination> attributeCombinations) {
        this.attributeCombinations = attributeCombinations;
        return this;
    }

    public CreateChargeDefinitionsRequest addAttributeCombinationsItem(AttributeCombination attributeCombinationsItem) {
        if (this.attributeCombinations == null) {
            this.attributeCombinations = new ArrayList<AttributeCombination>();
        }
        this.attributeCombinations.add(attributeCombinationsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="attributeCombinations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid AttributeCombination> getAttributeCombinations() {
        return this.attributeCombinations;
    }

    @JsonProperty(value="attributeCombinations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributeCombinations(List<@Valid AttributeCombination> attributeCombinations) {
        this.attributeCombinations = attributeCombinations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateChargeDefinitionsRequest createChargeDefinitionsRequest = (CreateChargeDefinitionsRequest)o;
        return Objects.equals(this.productRatePlanNumber, createChargeDefinitionsRequest.productRatePlanNumber) && Objects.equals(this.attributeCombinations, createChargeDefinitionsRequest.attributeCombinations);
    }

    public int hashCode() {
        return Objects.hash(this.productRatePlanNumber, this.attributeCombinations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateChargeDefinitionsRequest {\n");
        sb.append("    productRatePlanNumber: ").append(this.toIndentedString(this.productRatePlanNumber)).append("\n");
        sb.append("    attributeCombinations: ").append(this.toIndentedString(this.attributeCombinations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CreateChargeDefinitionsRequestBuilder builder() {
        return new CreateChargeDefinitionsRequestBuilder();
    }

    public CreateChargeDefinitionsRequest(String productRatePlanNumber, List<@Valid AttributeCombination> attributeCombinations) {
        this.productRatePlanNumber = productRatePlanNumber;
        this.attributeCombinations = attributeCombinations;
    }

    public static class CreateChargeDefinitionsRequestBuilder {
        private String productRatePlanNumber;
        private List<@Valid AttributeCombination> attributeCombinations;

        CreateChargeDefinitionsRequestBuilder() {
        }

        public CreateChargeDefinitionsRequestBuilder productRatePlanNumber(String productRatePlanNumber) {
            this.productRatePlanNumber = productRatePlanNumber;
            return this;
        }

        public CreateChargeDefinitionsRequestBuilder attributeCombinations(List<@Valid AttributeCombination> attributeCombinations) {
            this.attributeCombinations = attributeCombinations;
            return this;
        }

        public CreateChargeDefinitionsRequest build() {
            return new CreateChargeDefinitionsRequest(this.productRatePlanNumber, this.attributeCombinations);
        }

        public String toString() {
            return "CreateChargeDefinitionsRequest.CreateChargeDefinitionsRequestBuilder(productRatePlanNumber=" + this.productRatePlanNumber + ", attributeCombinations=" + this.attributeCombinations + ")";
        }
    }
}

