/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog.charge;

import com.zuora.sdk.catalog.charge.DayOfMonth;
import com.zuora.sdk.common.ApiObject;
import com.zuora.sdk.error.Validations;
import com.zuora.zevolve.api.model.BillCycle;
import com.zuora.zevolve.api.model.BillCyclePeriod;
import com.zuora.zevolve.api.model.BillCyclePeriodAlignment;
import com.zuora.zevolve.api.model.BillCycleTiming;
import com.zuora.zevolve.api.model.BillCycleType;
import com.zuora.zevolve.api.model.DayOfWeek;

public final class Billing
implements ApiObject<BillCycle> {
    private BillCycleType type;
    private DayOfMonth dayOfMonth;
    private DayOfWeek dayOfWeek;
    private BillCyclePeriod period;
    private BillCyclePeriodAlignment alignment;
    private BillCycleTiming timing;
    private Long specificPeriod;

    private Billing() {
    }

    public static Billing of(BillCycleType type) {
        return Billing.newInstance().with(type);
    }

    static Billing newInstance() {
        return new Billing();
    }

    private Billing with(BillCycleType type) {
        this.type = type;
        return this;
    }

    public Billing with(DayOfMonth dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
        return this;
    }

    public Billing with(BillCyclePeriod period) {
        this.period = period;
        return this;
    }

    public Billing with(BillCycleTiming timing) {
        this.timing = timing;
        return this;
    }

    public Billing with(BillCyclePeriodAlignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public Billing with(DayOfWeek day) {
        this.dayOfWeek = day;
        return this;
    }

    public Billing withSpecificPeriod(Long specificPeriod) {
        this.specificPeriod = specificPeriod;
        return this;
    }

    public BillCycle toApi() {
        Validations.requireNonNull((Object)((Object)this.type), (String)"Billing type is required");
        Validations.requireNonNull((Object)((Object)this.period), (String)"Billing period is required");
        return BillCycle.builder().type(this.type).dayOfMonth(this.dayOfMonth != null ? (Integer)this.dayOfMonth.value() : null).dayOfWeek(this.dayOfWeek).period(this.period).periodAlignment(this.alignment).timing(this.timing).specificPeriod(this.specificPeriod != null ? this.specificPeriod.toString() : null).build();
    }
}

