/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog;

import com.fasterxml.jackson.core.type.TypeReference;
import com.zuora.sdk.catalog.Catalog;
import com.zuora.sdk.catalog.ChargesService;
import com.zuora.sdk.error.ErrorMappers;
import com.zuora.sdk.error.Validations;
import com.zuora.sdk.http.HttpMethod;
import com.zuora.sdk.http.HttpSupport;
import com.zuora.sdk.json.PropertyNameScheme;
import com.zuora.zevolve.api.model.CreateProductChargeDefinitionRequest;
import com.zuora.zevolve.api.model.EffectiveDatingQueryOption;
import com.zuora.zevolve.api.model.GetPlanChargesByContextRequest;
import com.zuora.zevolve.api.model.GetPlanChargesByContextRequestv2;
import com.zuora.zevolve.api.model.GetProductChargeDefinitionRequest;
import com.zuora.zevolve.api.model.GetProductChargeDefinitionsRequest;
import com.zuora.zevolve.api.model.MigrateToAbpV2Request;
import com.zuora.zevolve.api.model.ProductChargeDefinition;
import com.zuora.zevolve.api.model.ProductChargeDefinitionWithRevisions;
import com.zuora.zevolve.api.model.ProductChargeDefinitions;
import com.zuora.zevolve.api.model.UpdateProductChargeDefinitionRequest;
import com.zuora.zevolve.api.model.Value;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChargeDefinitionsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChargesService.class);
    private final HttpSupport httpSupport;

    public ChargeDefinitionsService(HttpSupport httpSupport) {
        this.httpSupport = httpSupport;
    }

    public ProductChargeDefinitionWithRevisions createChargeDefinition(CreateProductChargeDefinitionRequest request) {
        Validations.requireNonNull((Object)request, (String)"request is required");
        return (ProductChargeDefinitionWithRevisions)this.httpSupport.call(HttpMethod.POST, Catalog.getPathPrefix() + "/charge-definitions", Optional.of(request), (TypeReference)new TypeReference<ProductChargeDefinitionWithRevisions>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    public ProductChargeDefinitionWithRevisions getChargeDefinition(String chargeDefinitionKey, boolean hideInheritedValues, EffectiveDatingQueryOption effectiveDatingQueryOption, String time) {
        Validations.requireNotEmpty((String)chargeDefinitionKey, (String)"chargeDefinitionKey required");
        return (ProductChargeDefinitionWithRevisions)this.httpSupport.call(HttpMethod.POST, Catalog.getPathPrefix() + "/charge-definitions/singleton-query", Optional.of(GetProductChargeDefinitionRequest.builder().hideInheritedValues(hideInheritedValues).chargeDefinitionKey(chargeDefinitionKey).time(time).effectiveDatingQueryOption(effectiveDatingQueryOption).build()), (TypeReference)new TypeReference<ProductChargeDefinitionWithRevisions>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    public List<ProductChargeDefinition> getChargeDefinitions(String chargeKey, int page, int pageSize, boolean hideInheritedValues) {
        ProductChargeDefinitions response = (ProductChargeDefinitions)this.httpSupport.call(HttpMethod.POST, Catalog.getPathPrefix() + "/charge-definitions/query", Optional.of(GetProductChargeDefinitionsRequest.builder().charge(chargeKey).page(page).pageSize(pageSize).hideInheritedValues(hideInheritedValues).build()), (TypeReference)new TypeReference<ProductChargeDefinitions>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
        return response.getChargeDefinitions();
    }

    public List<ProductChargeDefinition> getChargeDefinitions(String contextName, Map<String, Value> contextMap) {
        ProductChargeDefinitions response = (ProductChargeDefinitions)this.httpSupport.call(HttpMethod.POST, Catalog.getPathPrefix() + "/plans/charge-definitions/context-query-v2", Optional.of(GetPlanChargesByContextRequestv2.builder().contextName(contextName).contextmap(contextMap).build()), (TypeReference)new TypeReference<ProductChargeDefinitions>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
        return response.getChargeDefinitions();
    }

    public ProductChargeDefinitionWithRevisions updateChargeDefinition(UpdateProductChargeDefinitionRequest request) {
        Validations.requireNonNull((Object)request, (String)"request is required");
        return (ProductChargeDefinitionWithRevisions)this.httpSupport.call(HttpMethod.PUT, Catalog.getPathPrefix() + "/charge-definitions", Optional.of(request), (TypeReference)new TypeReference<ProductChargeDefinitionWithRevisions>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    public Boolean deleteChargeDefinition(String chargeDefinitionKey) {
        Validations.requireNotEmpty((String)chargeDefinitionKey, (String)"chargeDefinitionKey required");
        return "ok".equalsIgnoreCase((String)this.httpSupport.call(HttpMethod.DELETE, Catalog.getPathPrefix() + "/charge-definitions/" + chargeDefinitionKey, Optional.empty(), (TypeReference)new TypeReference<String>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent()));
    }

    public List<ProductChargeDefinition> getPlanChargeDefinitions(String ratePlanId, String contextName, Map<String, Value> contextMap) {
        Validations.requireNotEmpty((String)ratePlanId, (String)"ratePlanId required");
        ProductChargeDefinitions response = (ProductChargeDefinitions)this.httpSupport.call(HttpMethod.POST, Catalog.getPathPrefix() + "/plans/charge-definitions/context-query", Optional.of(GetPlanChargesByContextRequest.builder().ratePlanId(ratePlanId).contextName(contextName).contextmap(contextMap).build()), (TypeReference)new TypeReference<ProductChargeDefinitions>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
        return response.getChargeDefinitions();
    }

    public Boolean migrateToDynamicPricing(String ratePlanNumber) {
        Validations.requireNotEmpty((String)ratePlanNumber, (String)"ratePlanNumber required");
        return "ok".equalsIgnoreCase((String)this.httpSupport.call(HttpMethod.POST, Catalog.getPathPrefix() + "/charge-definitions/migrations", Optional.of(MigrateToAbpV2Request.builder().productRatePlanNumber(ratePlanNumber).build()), (TypeReference)new TypeReference<String>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent()));
    }
}

