/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.load_wrapper;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.common.error.ErrorRefreshView;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.external.cpv.CircularProgressView;
import java.util.List;

public class LoadWrapperLayout
extends FrameLayout {
    private List<Integer> componentIds = ListUtils.newArrayList(R.id.ch_rootLoadWrapper, R.id.ch_layoutLoadWrapperContent, R.id.ch_progressLoadWrapper, R.id.ch_errorLoadWrapper);
    @Nullable
    private FrameLayout layoutLoadWrapperContent;
    @Nullable
    private CircularProgressView progressLoadWrapper;
    @Nullable
    private ErrorRefreshView errorLoadWrapper;

    public LoadWrapperLayout(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public LoadWrapperLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public LoadWrapperLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_load_wrapper, (ViewGroup)this);
        this.layoutLoadWrapperContent = (FrameLayout)this.findViewById(R.id.ch_layoutLoadWrapperContent);
        this.progressLoadWrapper = (CircularProgressView)this.findViewById(R.id.ch_progressLoadWrapper);
        this.errorLoadWrapper = (ErrorRefreshView)this.findViewById(R.id.ch_errorLoadWrapper);
    }

    public void setLoadState(FetchState fetchState) {
        Views.setVisibility(this.progressLoadWrapper, fetchState == FetchState.LOADING);
        Views.setVisibility((View)this.errorLoadWrapper, fetchState == FetchState.FAILED);
        Views.setVisibility((View)this.layoutLoadWrapperContent, fetchState == FetchState.COMPLETE);
    }

    public void setRefreshListener(View.OnClickListener listener) {
        if (this.errorLoadWrapper != null) {
            this.errorLoadWrapper.setListener(listener);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (child != null && this.componentIds.contains(child.getId())) {
            super.addView(child, index, params);
        } else if (this.layoutLoadWrapperContent != null && child != null) {
            this.layoutLoadWrapperContent.addView(child, index, params);
        }
    }
}

