/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.cardview.widget.CardView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.ListUtils;
import java.util.List;

public class ChBorderLayout
extends FrameLayout {
    private List<Integer> componentIds = ListUtils.newArrayList(R.id.ch_rootBorderLayout, R.id.ch_cardBorderLayoutBack, R.id.ch_cardBorderLayoutContent);
    private CardView cardBack;
    private CardView cardContent;
    private Float borderRadius = Float.valueOf(0.0f);
    private int borderWidth = 0;
    private int borderColor = 0;
    private int backColor = -1;

    public ChBorderLayout(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public ChBorderLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ChBorderLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public ChBorderLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(@NonNull Context context, @Nullable AttributeSet attrs) {
        LayoutInflater.from((Context)context).inflate(R.layout.ch_layout_border, (ViewGroup)this);
        this.cardBack = (CardView)this.findViewById(R.id.ch_cardBorderLayoutBack);
        this.cardContent = (CardView)this.findViewById(R.id.ch_cardBorderLayoutContent);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ChBorderLayout, 0, 0);
        try {
            this.borderRadius = Float.valueOf(typedArray.getDimension(R.styleable.ChBorderLayout_ch_bl_borderRadius, this.borderRadius.floatValue()));
            this.borderWidth = (int)typedArray.getDimension(R.styleable.ChBorderLayout_ch_bl_borderWidth, (float)this.borderWidth);
            this.borderColor = typedArray.getColor(R.styleable.ChBorderLayout_ch_bl_borderColor, this.borderColor);
            this.backColor = typedArray.getColor(R.styleable.ChBorderLayout_ch_bl_backColor, this.backColor);
        }
        finally {
            typedArray.recycle();
        }
        this.resolveStyle();
    }

    public void setBorderRadius(Float borderRadius) {
        this.borderRadius = borderRadius;
        this.resolveStyle();
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = (int)borderWidth;
        this.resolveStyle();
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        this.resolveStyle();
    }

    public void setBackColor(int backColor) {
        this.backColor = backColor;
        this.resolveStyle();
    }

    private void resolveStyle() {
        if (this.cardBack != null) {
            this.cardBack.setRadius(this.borderRadius.floatValue());
            this.cardBack.setCardBackgroundColor(this.borderColor);
        }
        if (this.cardContent != null) {
            ViewGroup.LayoutParams params = this.cardContent.getLayoutParams();
            if (params instanceof ViewGroup.MarginLayoutParams) {
                ((ViewGroup.MarginLayoutParams)params).setMargins(this.borderWidth, this.borderWidth, this.borderWidth, this.borderWidth);
            }
            if (Build.VERSION.SDK_INT >= 21) {
                this.cardContent.setRadius(Math.max(0.0f, this.borderRadius.floatValue() - (float)this.borderWidth));
            } else {
                this.cardContent.setRadius(Math.max(1.0f, this.borderRadius.floatValue() - (float)this.borderWidth));
            }
            this.cardContent.setCardBackgroundColor(this.backColor);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (child != null && this.componentIds.contains(child.getId())) {
            super.addView(child, index, params);
        } else if (this.cardContent != null && child != null) {
            this.cardContent.addView(child, index, params);
        }
    }
}

