/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.integrations.instagram;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.media.instagram.InstagramData;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.integrations.instagram.OnInstagramThumbnailClickListener;
import com.zoyi.com.bumptech.glide.Glide;

public class InstagramPreviewItemView
extends FrameLayout {
    public InstagramPreviewItemView(@NonNull Context context, InstagramData data, OnInstagramThumbnailClickListener listener) {
        super(context);
        this.init(context, data, listener);
    }

    @Initializer
    private void init(Context context, InstagramData data, OnInstagramThumbnailClickListener listener) {
        LayoutInflater.from((Context)context).inflate(R.layout.ch_view_integration_instagram_preview_item, (ViewGroup)this);
        ImageView imageView = (ImageView)this.findViewById(R.id.ch_imageInstagramPreviewItem);
        switch (data.getMediaType()) {
            case "IMAGE": 
            case "CAROUSEL_ALBUM": {
                this.setImage(imageView, data.getMediaUrl());
                break;
            }
            case "VIDEO": {
                this.setImage(imageView, data.getThumbnailUrl());
            }
        }
        this.setOnClickListener(v -> listener.onDataClick(data));
    }

    private void setImage(ImageView imageView, @Nullable String imageUrl) {
        if (imageUrl != null) {
            Glide.with((Context)this.getContext()).load(imageUrl).centerCrop().into(imageView);
        }
    }
}

