/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.handler;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.zoyi.channel.plugin.android.util.Utils;

public abstract class InfiniteScrollListener
extends RecyclerView.OnScrollListener {
    private static int SCROLL_THRESHOLD = (int)Utils.dpToPx(200.0f);

    public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        if (!recyclerView.canScrollVertically(1)) {
            this.scrollAttachedToBottom();
        } else if (!recyclerView.canScrollVertically(-1) || recyclerView.computeVerticalScrollOffset() < SCROLL_THRESHOLD) {
            this.scrollAttachedToTop();
        }
    }

    public abstract void scrollAttachedToBottom();

    public abstract void scrollAttachedToTop();
}

