/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.dock;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;

public class DockLayout
extends ViewGroup {
    private int spaceWidth = 0;
    private int baseItemCount = 1;

    public DockLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public DockLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public DockLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initializer
    private void init(Context context, @Nullable AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.DockLayout, 0, 0);
            try {
                this.spaceWidth = (int)typedArray.getDimension(R.styleable.DockLayout_ch_dl_spaceWidth, (float)this.spaceWidth);
                this.baseItemCount = Math.max(1, typedArray.getInt(R.styleable.DockLayout_ch_dl_baseItemCount, this.baseItemCount));
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int visibleChildCount = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            if (view == null || view.getVisibility() == 8) continue;
            ++visibleChildCount;
        }
        int containerWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int itemSize = visibleChildCount <= this.baseItemCount ? (containerWidth - this.spaceWidth * (this.baseItemCount - 1)) / this.baseItemCount : (int)((float)(containerWidth - this.spaceWidth * this.baseItemCount) / ((float)this.baseItemCount + 0.5f));
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            if (view == null || view.getVisibility() == 8) continue;
            view.measure(View.MeasureSpec.makeMeasureSpec((int)itemSize, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)itemSize, (int)0x40000000));
        }
        this.setMeasuredDimension(Math.max(containerWidth, (itemSize + this.spaceWidth) * visibleChildCount - this.spaceWidth), itemSize);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int itemSize = b - t;
        int visibleChildCount = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            if (view == null || view.getVisibility() == 8) continue;
            ++visibleChildCount;
        }
        int horizontalStartPosition = Math.max(0, (r - l - visibleChildCount * itemSize - this.spaceWidth * (visibleChildCount - 1)) / 2);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            if (view == null || view.getVisibility() == 8) continue;
            view.layout(horizontalStartPosition + (itemSize + this.spaceWidth) * i, t, horizontalStartPosition + (itemSize + this.spaceWidth) * i + itemSize, b);
        }
    }
}

