/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util.message;

import android.text.TextPaint;
import android.text.style.ClickableSpan;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.action.MarketingAction;
import com.zoyi.channel.plugin.android.enumerate.LinkType;
import com.zoyi.channel.plugin.android.model.rest.Marketing;
import com.zoyi.channel.plugin.android.util.Executor;

public class LinkSpan
extends ClickableSpan {
    private String linkText;
    private LinkType linkType;
    @Nullable
    private Object payload;

    public LinkSpan(String linkText, LinkType linkType, @Nullable Object payload) {
        this.linkText = linkText;
        this.linkType = linkType;
        this.payload = payload;
    }

    public void onClick(View view) {
        Executor.executeLinkAction(view.getContext(), this.linkText, this.linkType);
        if (this.payload != null && this.payload instanceof Marketing) {
            switch (this.linkType) {
                case URL: {
                    MarketingAction.sendClickEvent((Marketing)this.payload, this.linkText);
                    break;
                }
                case EMAIL: {
                    MarketingAction.sendClickEvent((Marketing)this.payload, null);
                }
            }
        }
    }

    public void updateDrawState(@NonNull TextPaint textPaint) {
        super.updateDrawState(textPaint);
        try {
            textPaint.setUnderlineText(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

