/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.deserializer;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.model.etc.BlockParseResult;
import com.zoyi.channel.plugin.android.model.rest.NestedMessage;
import com.zoyi.channel.plugin.android.util.MessageUtils;
import com.zoyi.channel.plugin.android.util.message.MessageParseOptions;
import com.zoyi.channel.plugin.android.util.message.MessageParserUtils;
import com.zoyi.com.google.gson.Gson;
import com.zoyi.com.google.gson.JsonDeserializationContext;
import com.zoyi.com.google.gson.JsonDeserializer;
import com.zoyi.com.google.gson.JsonElement;
import com.zoyi.com.google.gson.JsonParseException;
import java.lang.reflect.Type;

public class NestedMessageDeserializer
implements JsonDeserializer {
    private Gson gson = new Gson();
    private MessageParseOptions options = MessageUtils.getWelcomeMessageOption();

    @Nullable
    private String getPlainText(NestedMessage nestedMessage, @Nullable BlockParseResult result) {
        if (result != null && !TextUtils.isEmpty((CharSequence)result.getPlainText())) {
            return result.getPlainText();
        }
        if (nestedMessage.getWebPage() != null) {
            return nestedMessage.getWebPage().getUrl();
        }
        return null;
    }

    public Object deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        NestedMessage nestedMessage = (NestedMessage)this.gson.fromJson(json, type);
        if (nestedMessage != null) {
            BlockParseResult result = MessageParserUtils.parseBlocks(nestedMessage.getBlocks(), this.options);
            nestedMessage.setPlainText(this.getPlainText(nestedMessage, result));
        }
        return nestedMessage;
    }
}

