/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.profile.view;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.profile.view.BaseEditProfileView;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

public class EditProfileNumberView
extends FrameLayout
implements BaseEditProfileView {
    private WatchedEditText editText;
    private View clearButton;

    public EditProfileNumberView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public EditProfileNumberView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public EditProfileNumberView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Override
    @Initializer
    public void init(Context context) {
        View root = LayoutInflater.from((Context)context).inflate(R.layout.ch_view_edit_profile_number, (ViewGroup)this, true);
        this.editText = (WatchedEditText)root.findViewById(R.id.ch_editEditProfileNumber);
        this.clearButton = root.findViewById(R.id.ch_buttonEditProfileNumberClearText);
        this.editText.setWatchedTextChangedListener(s -> Views.setVisibility(this.clearButton, !TextUtils.isEmpty((CharSequence)s)));
        this.clearButton.setOnClickListener(v -> this.editText.setText(null));
    }

    @Override
    public void focus() {
        if (this.editText != null) {
            this.editText.requestFocus();
        }
    }

    @Override
    public boolean isValidValue() {
        String text = this.editText.getString().trim();
        if (text.isEmpty()) {
            return true;
        }
        return ParseUtils.parseNumber(text) != null;
    }

    @Override
    @Nullable
    public Object getValue() {
        return ParseUtils.parseNumber(this.editText.getString().trim());
    }

    @Override
    public void setValue(@Nullable Object value) {
        if (this.editText != null) {
            if (value != null) {
                this.editText.setText(value.toString());
            } else {
                this.editText.setText(null);
            }
        }
    }
}

