/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.profile.view;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.CountryAction;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumber;
import com.zoyi.channel.plugin.android.activity.profile.view.BaseEditProfileView;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.store.CountryStore;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.dialog.CountryCodeDialog;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;
import com.zoyi.com.annimon.stream.Optional;
import java.util.List;
import java.util.Locale;

public class EditProfileMobileNumberView
extends FrameLayout
implements BaseEditProfileView {
    private View buttonSelectCountry;
    private TextView textCountry;
    private WatchedEditText editText;
    private View clearButton;
    private int countryCode = 1;

    public EditProfileMobileNumberView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public EditProfileMobileNumberView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public EditProfileMobileNumberView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Override
    @Initializer
    public void init(Context context) {
        View root = LayoutInflater.from((Context)context).inflate(R.layout.ch_view_edit_profile_mobile_number, (ViewGroup)this, true);
        this.buttonSelectCountry = root.findViewById(R.id.ch_buttonEditProfileSelectCountry);
        this.textCountry = (TextView)root.findViewById(R.id.ch_textEditProfileSelectCountry);
        this.editText = (WatchedEditText)root.findViewById(R.id.ch_editEditProfileMobileNumber);
        this.clearButton = root.findViewById(R.id.ch_buttonEditProfileMobileNumberClearText);
        this.editText.setWatchedTextChangedListener(s -> Views.setVisibility(this.clearButton, !TextUtils.isEmpty((CharSequence)s)));
        this.clearButton.setOnClickListener(v -> this.editText.setText(null));
        this.buttonSelectCountry.setOnClickListener(v -> this.requestCountrySelector());
    }

    @Override
    public void focus() {
        if (this.editText != null) {
            this.editText.requestFocus();
        }
    }

    @Override
    public boolean isValidValue() {
        return true;
    }

    @Override
    @Nullable
    public Object getValue() {
        if (this.editText.getString().trim().isEmpty()) {
            return null;
        }
        return String.format(Locale.US, "+%d%s", this.countryCode, this.editText.getString());
    }

    @Override
    public void setValue(@Nullable Object value) {
        MobileNumber mobileNumber = new MobileNumber((String)Optional.ofNullable((Object)value).map(Object::toString).orElse(null));
        this.countryCode = mobileNumber.getCountryCode();
        this.textCountry.setText((CharSequence)String.format(Locale.US, "+%d", mobileNumber.getCountryCode()));
        this.editText.setText(mobileNumber.getPhoneNumber());
    }

    private void requestCountrySelector() {
        List<Country> countries = CountryStore.get().countries.get();
        if (countries == null) {
            this.showProgress(ResUtils.getString(this.getContext(), "ch.loading_information"));
            CountryAction.fetchCountries(new RestSubscriber<List<Country>>(){

                @Override
                public void onError(RetrofitException error) {
                    EditProfileMobileNumberView.this.hideProgress();
                }

                @Override
                public void onSuccess(@NonNull List<Country> countries) {
                    EditProfileMobileNumberView.this.hideProgress();
                    CountryStore.get().countries.set(countries);
                    if (countries.size() > 0) {
                        EditProfileMobileNumberView.this.openCountrySelector(countries);
                    }
                }
            });
        } else {
            this.openCountrySelector(countries);
        }
    }

    private void openCountrySelector(List<Country> countries) {
        new CountryCodeDialog(this.getContext(), countries, (position, countryCode) -> {
            try {
                this.countryCode = Integer.parseInt(countryCode);
                this.textCountry.setText((CharSequence)String.format("+%s", countryCode));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).show();
    }

    private void showProgress(String message) {
        if (this.getContext() instanceof BaseActivity2) {
            ((BaseActivity2)this.getContext()).showProgress(message);
        }
    }

    private void hideProgress() {
        if (this.getContext() instanceof BaseActivity2) {
            ((BaseActivity2)this.getContext()).hideProgress();
        }
    }
}

