/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.lounge.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.selector.ManagerSelector;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.rx.functions.Action2;
import java.util.List;

public class FollowingManagersView
extends FrameLayout {
    private AvatarLayout avatar1;
    private AvatarLayout avatar2;
    private AvatarLayout avatar3;
    private AvatarLayout avatar4;
    private ImageView outOfWorking;
    @Nullable
    private Binder binder;

    public FollowingManagersView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public FollowingManagersView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public FollowingManagersView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_following_managers, (ViewGroup)this, true);
        this.avatar1 = (AvatarLayout)view.findViewById(R.id.ch_avatarFollowingManagers1);
        this.avatar2 = (AvatarLayout)view.findViewById(R.id.ch_avatarFollowingManagers2);
        this.avatar3 = (AvatarLayout)view.findViewById(R.id.ch_avatarFollowingManagers3);
        this.avatar4 = (AvatarLayout)view.findViewById(R.id.ch_avatarFollowingManagers4);
        this.outOfWorking = (ImageView)view.findViewById(R.id.ch_imageFollowingManagersOutOfWorking);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.binder = ManagerSelector.bindFollowingManagers((Action2<List<Manager>, Boolean>)((Action2)(managers, isWorking) -> {
            if (isWorking != null && !isWorking.booleanValue()) {
                this.setOutOfWorking();
            } else if (managers != null) {
                this.setAvatarLayouts((List<Manager>)managers);
            } else {
                this.hideLayout();
            }
        }));
    }

    private void setAvatarLayouts(List<Manager> managers) {
        this.avatar1.setVisibility(8);
        this.avatar2.setVisibility(8);
        this.avatar3.setVisibility(8);
        this.avatar4.setVisibility(8);
        this.outOfWorking.setVisibility(8);
        switch (managers.size()) {
            case 0: {
                break;
            }
            case 1: {
                this.setAvatar(this.avatar1, 60, 0, 0, managers.get(0));
                break;
            }
            case 2: {
                this.setAvatar(this.avatar1, 48, 0, 0, managers.get(0));
                this.setAvatar(this.avatar2, 48, 0, 50, managers.get(1));
                break;
            }
            case 3: {
                this.setAvatar(this.avatar1, 40, 0, 22, managers.get(0));
                this.setAvatar(this.avatar2, 40, 36, 0, managers.get(1));
                this.setAvatar(this.avatar3, 40, 36, 42, managers.get(2));
                break;
            }
            default: {
                this.setAvatar(this.avatar1, 36, 0, 0, managers.get(0));
                this.setAvatar(this.avatar2, 36, 0, 38, managers.get(1));
                this.setAvatar(this.avatar3, 36, 38, 0, managers.get(2));
                this.setAvatar(this.avatar4, 36, 38, 38, managers.get(3));
            }
        }
    }

    private void setAvatar(AvatarLayout avatar, int sizeDp, int topMarginDp, int leftMarginDp, Manager manager) {
        avatar.setVisibility(0);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)avatar.getLayoutParams();
        layoutParams.width = (int)Utils.dpToPx(sizeDp);
        layoutParams.height = (int)Utils.dpToPx(sizeDp);
        layoutParams.setMargins((int)Utils.dpToPx(leftMarginDp), (int)Utils.dpToPx(topMarginDp), 0, 0);
        avatar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        avatar.set(manager);
    }

    private void setOutOfWorking() {
        this.avatar1.setVisibility(8);
        this.avatar2.setVisibility(8);
        this.avatar3.setVisibility(8);
        this.avatar4.setVisibility(8);
        this.outOfWorking.setVisibility(0);
    }

    private void hideLayout() {
        this.avatar1.setVisibility(8);
        this.avatar2.setVisibility(8);
        this.avatar3.setVisibility(8);
        this.avatar4.setVisibility(8);
        this.outOfWorking.setVisibility(8);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.binder != null) {
            this.binder.unbind();
            this.binder = null;
        }
    }
}

