/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.listener.viewholder.OnBaseMessageActionListener;
import com.zoyi.channel.plugin.android.activity.chat.model.SupportBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.AbsHostMessageHolder;
import com.zoyi.channel.plugin.android.model.rest.ActionButton;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.com.annimon.stream.Optional;

public class SupportBotMessageHolder
extends AbsHostMessageHolder {
    @Nullable
    private OnBaseMessageActionListener listener;
    @Nullable
    private SupportBotMessageItem item;

    private SupportBotMessageHolder(View itemView, @Nullable OnBaseMessageActionListener listener) {
        super(itemView, listener);
        this.listener = listener;
    }

    public void bind(SupportBotMessageItem item, boolean isLast) {
        super.bind(item.getDefaultBot(), item.getCreatedAt(), true, true, true);
        this.item = item;
        this.setBlocks(item.getBlocks());
        Optional.ofNullable((Object)item.getWebPage()).ifPresent(webPage -> this.setWebPage(String.valueOf(item.getCreatedAt()), (WebPage)webPage));
        this.setAttachments(String.valueOf(item.getId()), item.getFiles(), this);
        if (item.getLinkButtons() != null) {
            this.setLinkButtons(item.getLinkButtons());
        }
        if (item.getButtons() != null && isLast) {
            this.setActionButtons("supportBot", item.getButtons());
        } else {
            this.setActionButtons(null, null);
        }
    }

    @Override
    public void onActionButtonClick(@NonNull String actionType, @NonNull ActionButton actionButton) {
        if (this.listener != null && this.item != null && "supportBot".equals(actionType)) {
            this.listener.onLocalSupportBotActionClick(this.item.getId(), actionType, actionButton);
        }
    }

    @Override
    protected void onRecycled() {
        super.onRecycled();
        this.item = null;
    }

    public static SupportBotMessageHolder newInstance(ViewGroup parent, @Nullable OnBaseMessageActionListener listener) {
        return new SupportBotMessageHolder(SupportBotMessageHolder.getItemView(parent), listener);
    }
}

