/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelLauncherView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.selector.GlobalSelector;
import com.zoyi.channel.plugin.android.selector.PopupSelector;
import com.zoyi.channel.plugin.android.store.PopupStore;
import com.zoyi.channel.plugin.android.util.ContextUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.listener.OnPopupClickListener;
import com.zoyi.channel.plugin.android.view.popup.BubblePopupView;
import com.zoyi.channel.plugin.android.view.popup.FullScreenPopupView;
import com.zoyi.rx.functions.Action1;

class ChannelView
extends FrameLayout
implements OnPopupClickListener {
    private Context context;
    private ChannelLauncherView launcherView;
    private FullScreenPopupView viewPopupFullScreen;
    private BubblePopupView viewPopupBubble;
    @Nullable
    private Binder visibilityBinder;
    @Nullable
    private Binder launcherVisibilityBinder;
    @Nullable
    private Binder popupBinder;

    public ChannelView(Context context) {
        super(context);
        this.init(context);
    }

    public ChannelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ChannelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_channel_view, (ViewGroup)this, true);
        this.launcherView = (ChannelLauncherView)view.findViewById(R.id.ch_viewLauncher);
        this.viewPopupBubble = (BubblePopupView)view.findViewById(R.id.ch_viewPopupBubble);
        this.viewPopupBubble.setPopupClickListener(this);
        this.viewPopupFullScreen = (FullScreenPopupView)view.findViewById(R.id.ch_viewPopupFullScreen);
        this.viewPopupFullScreen.setPopupClickListener(this);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.visibilityBinder = GlobalSelector.bindBootState((Action1<Boolean>)((Action1)booted -> this.setVisibility(booted != false ? 0 : 8)));
        this.launcherVisibilityBinder = GlobalSelector.bindLauncherVisibility((Action1<Boolean>)((Action1)showLauncher -> {
            if (showLauncher.booleanValue()) {
                this.launcherView.show();
            } else {
                this.launcherView.hide();
            }
        }));
        this.popupBinder = PopupSelector.bindPopup((Action1<Message>)((Action1)message -> {
            if (message != null) {
                if (message.getMarketing() != null && message.getMarketing().isFullScreen()) {
                    this.viewPopupBubble.resetView();
                    this.viewPopupFullScreen.show((Message)message);
                } else {
                    this.viewPopupFullScreen.resetView();
                    this.viewPopupBubble.show((Message)message);
                }
            } else {
                this.viewPopupFullScreen.resetView();
                this.viewPopupBubble.resetView();
            }
        }));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.visibilityBinder != null) {
            this.visibilityBinder.unbind();
        }
        if (this.launcherVisibilityBinder != null) {
            this.launcherVisibilityBinder.unbind();
        }
        if (this.popupBinder != null) {
            this.popupBinder.unbind();
        }
    }

    @Override
    public void onPopupClick(@NonNull String chatId) {
        PopupStore.get().popupMessage.set(null);
        Activity activity = ContextUtils.getActivity(this.context);
        if (activity != null) {
            ChannelIO.openChat((Activity)this.context, chatId, null);
        }
    }
}

