/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import com.splunk.mint.Logger;
import com.splunk.mint.Mint;
import com.splunk.mint.Properties;
import com.splunk.mint.SequentialExecutor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class CrashInfo {
    private static final String crashCounterFile = "crashCounter";
    private static final SequentialExecutor executor = new SequentialExecutor();
    private static final String lastCrashIDFile = "lastCrashID";

    CrashInfo() {
    }

    protected int getTotalCrashesNum() {
        Future<Integer> future = executor.getExecutor().submit(new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() {
                Integer crashCounter = 0;
                if (Properties.FILES_PATH == null) {
                    Logger.logWarning("Please use getTotalCrashesNum after initializing the plugin! Returning 0.");
                    return 0;
                }
                File file = new File(Properties.FILES_PATH + "/" + CrashInfo.crashCounterFile);
                if (file != null && !file.exists()) {
                    try {
                        file.createNewFile();
                        return crashCounter;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                BufferedReader bin = null;
                try {
                    bin = new BufferedReader(new FileReader(file));
                    try {
                        crashCounter = Integer.parseInt(bin.readLine().trim());
                    }
                    catch (Exception e) {
                        crashCounter = 0;
                    }
                    Integer e = crashCounter;
                    return e;
                }
                catch (Exception e) {
                    Logger.logWarning("There was a problem getting the crash counter");
                    if (Mint.DEBUG) {
                        e.printStackTrace();
                    }
                    Integer n = 0;
                    return n;
                }
                finally {
                    if (bin != null) {
                        try {
                            bin.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return 0;
    }

    protected void clearCrashCounter() {
        executor.getExecutor().submit(new Runnable(){

            @Override
            public void run() {
                File file = new File(Properties.FILES_PATH + "/" + CrashInfo.crashCounterFile);
                if (file != null && file.exists()) {
                    file.delete();
                }
            }
        });
    }

    protected static void saveCrashCounter() {
        executor.getExecutor().submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File file = new File(Properties.FILES_PATH + "/" + CrashInfo.crashCounterFile);
                if (file != null && !file.exists()) {
                    try {
                        file.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                BufferedReader bin = null;
                BufferedWriter bos = null;
                try {
                    bin = new BufferedReader(new FileReader(file));
                    Integer crashCounter = 0;
                    try {
                        crashCounter = Integer.parseInt(bin.readLine().trim());
                    }
                    catch (Exception e) {
                        crashCounter = 0;
                    }
                    Integer n = crashCounter;
                    Integer n2 = crashCounter = Integer.valueOf(crashCounter + 1);
                    bos = new BufferedWriter(new FileWriter(file));
                    bos.write(String.valueOf(crashCounter));
                    bos.newLine();
                    bos.flush();
                    bos.close();
                }
                catch (IOException e) {
                    Logger.logWarning("There was a problem saving the crash counter");
                    if (Mint.DEBUG) {
                        e.printStackTrace();
                    }
                }
                finally {
                    if (bin != null) {
                        try {
                            bin.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    protected static void saveLastCrashID(final String lastID) {
        if (lastID != null) {
            executor.getExecutor().submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    File file = new File(Properties.FILES_PATH + "/" + CrashInfo.lastCrashIDFile);
                    if (file != null && !file.exists()) {
                        try {
                            file.createNewFile();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    BufferedWriter bos = null;
                    try {
                        bos = new BufferedWriter(new FileWriter(file));
                        bos.write(lastID);
                        bos.newLine();
                        bos.flush();
                        bos.close();
                    }
                    catch (IOException e) {
                        Logger.logWarning("There was a problem saving the last crash id");
                        if (Mint.DEBUG) {
                            e.printStackTrace();
                        }
                    }
                    finally {
                        if (bos != null) {
                            try {
                                bos.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            });
        }
    }

    protected String getLastCrashID() {
        Future<String> future = executor.getExecutor().submit(new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() {
                String crashID = null;
                File file = new File(Properties.FILES_PATH + "/" + CrashInfo.lastCrashIDFile);
                if (file != null && !file.exists()) {
                    try {
                        file.createNewFile();
                        return null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                BufferedReader bin = null;
                try {
                    bin = new BufferedReader(new FileReader(file));
                    try {
                        crashID = bin.readLine().trim();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        crashID = null;
                    }
                    String e = crashID;
                    return e;
                }
                catch (Exception e) {
                    Logger.logWarning("There was a problem getting the last crash id");
                    if (Mint.DEBUG) {
                        e.printStackTrace();
                    }
                    String string = null;
                    return string;
                }
                finally {
                    if (bin != null) {
                        try {
                            bin.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return null;
    }
}

