/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.com.annimon.stream.function;

import com.zoyi.com.annimon.stream.Objects;
import com.zoyi.com.annimon.stream.function.ThrowableConsumer;

public interface Consumer<T> {
    public void accept(T var1);

    public static class Util {
        private Util() {
        }

        public static <T> Consumer<T> andThen(final Consumer<? super T> c1, final Consumer<? super T> c2) {
            return new Consumer<T>(){

                @Override
                public void accept(T value) {
                    c1.accept(value);
                    c2.accept(value);
                }
            };
        }

        public static <T> Consumer<T> safe(ThrowableConsumer<? super T, Throwable> throwableConsumer) {
            return Util.safe(throwableConsumer, null);
        }

        public static <T> Consumer<T> safe(final ThrowableConsumer<? super T, Throwable> throwableConsumer, final Consumer<? super T> onFailedConsumer) {
            return new Consumer<T>(){

                @Override
                public void accept(T value) {
                    block2: {
                        Objects.requireNonNull(throwableConsumer);
                        try {
                            throwableConsumer.accept(value);
                        }
                        catch (Throwable ex) {
                            if (onFailedConsumer == null) break block2;
                            onFailedConsumer.accept(value);
                        }
                    }
                }
            };
        }
    }
}

