package com.zoyi.channel.plugin.android.view.youtube.ui.menu.defaultMenu;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.view.youtube.ui.menu.MenuItem;

import java.util.List;


public class MenuAdapter extends RecyclerView.Adapter<MenuAdapter.ViewHolder> {

  private Context context;
  private List<MenuItem> menuItems;

  public MenuAdapter(Context context, List<MenuItem> menuItems) {
    this.context = context;
    this.menuItems = menuItems;
  }

  @Override
  public MenuAdapter.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
    View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.ch_plugin_ayp_menu_item, parent, false);
    return new ViewHolder(view);
  }

  @Override
  public void onBindViewHolder(ViewHolder holder, int position) {
    holder.itemView.setOnClickListener(menuItems.get(position).getOnClickListener());
    holder.textView.setText(menuItems.get(position).getText());

    if (menuItems.get(position).getIcon() != 0) {
      holder.textView.setCompoundDrawablesWithIntrinsicBounds(
          ContextCompat.getDrawable(context, menuItems.get(position).getIcon()),
          null,
          null,
          null
      );
    }
  }

  @Override
  public int getItemCount() {
    return menuItems.size();
  }

  class ViewHolder extends RecyclerView.ViewHolder {

    TextView textView;

    ViewHolder(@NonNull View itemView) {
      super(itemView);
      textView = itemView.findViewById(R.id.ch_textAypMenuItem);
    }
  }
}